/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.jcache.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import javax.annotation.PreDestroy;
import javax.cache.annotation.CacheDefaults;
import javax.cache.annotation.CacheKey;
import javax.cache.annotation.CacheKeyGenerator;
import javax.cache.annotation.CachePut;
import javax.cache.annotation.CacheRemove;
import javax.cache.annotation.CacheRemoveAll;
import javax.cache.annotation.CacheResolverFactory;
import javax.cache.annotation.CacheResult;
import javax.cache.annotation.CacheValue;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.interceptor.InvocationContext;
import org.apache.commons.jcs3.jcache.cdi.CacheKeyGeneratorImpl;
import org.apache.commons.jcs3.jcache.cdi.CacheResolverFactoryImpl;

@ApplicationScoped
public class CDIJCacheHelper {
    private static final Logger LOGGER = Logger.getLogger(CDIJCacheHelper.class.getName());
    private static final boolean CLOSE_CACHE = !Boolean.getBoolean("org.apache.commons.jcs3.jcache.cdi.skip-close");
    private volatile CacheResolverFactoryImpl defaultCacheResolverFactory;
    private final CacheKeyGeneratorImpl defaultCacheKeyGenerator = new CacheKeyGeneratorImpl();
    private final Collection<CreationalContext<?>> toRelease = new ArrayList();
    private final ConcurrentMap<MethodKey, MethodMeta> methods = new ConcurrentHashMap<MethodKey, MethodMeta>();
    @Inject
    private BeanManager beanManager;

    @PreDestroy
    private void release() {
        if (CLOSE_CACHE && this.defaultCacheResolverFactory != null) {
            this.defaultCacheResolverFactory.release();
        }
        for (CreationalContext<?> cc : this.toRelease) {
            try {
                cc.release();
            }
            catch (RuntimeException re) {
                LOGGER.warning(re.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodMeta findMeta(InvocationContext ic) {
        Method mtd = ic.getMethod();
        Class<?> refType = CDIJCacheHelper.findKeyType(ic.getTarget());
        MethodKey key = new MethodKey(refType, mtd);
        MethodMeta methodMeta = (MethodMeta)this.methods.get(key);
        if (methodMeta == null) {
            CDIJCacheHelper cDIJCacheHelper = this;
            synchronized (cDIJCacheHelper) {
                methodMeta = (MethodMeta)this.methods.get(key);
                if (methodMeta == null) {
                    methodMeta = this.createMeta(ic);
                    this.methods.put(key, methodMeta);
                }
            }
        }
        return methodMeta;
    }

    private static Class<?> findKeyType(Object target) {
        if (null == target) {
            return null;
        }
        return target.getClass();
    }

    private MethodMeta createMeta(InvocationContext ic) {
        CacheDefaults defaults = CDIJCacheHelper.findDefaults(ic.getTarget() == null ? null : ic.getTarget().getClass(), ic.getMethod());
        Class<?>[] parameterTypes = ic.getMethod().getParameterTypes();
        Annotation[][] parameterAnnotations = ic.getMethod().getParameterAnnotations();
        ArrayList<Set<Annotation>> annotations = new ArrayList<Set<Annotation>>();
        for (Annotation[] parameterAnnotation : parameterAnnotations) {
            HashSet<Annotation> set = new HashSet<Annotation>(parameterAnnotation.length);
            set.addAll(Arrays.asList(parameterAnnotation));
            annotations.add(set);
        }
        HashSet<Annotation> mtdAnnotations = new HashSet<Annotation>(Arrays.asList(ic.getMethod().getAnnotations()));
        CacheResult cacheResult = ic.getMethod().getAnnotation(CacheResult.class);
        String cacheResultCacheResultName = cacheResult == null ? null : CDIJCacheHelper.defaultName(ic.getMethod(), defaults, cacheResult.cacheName());
        CacheResolverFactory cacheResultCacheResolverFactory = cacheResult == null ? null : this.cacheResolverFactoryFor(defaults, cacheResult.cacheResolverFactory());
        CacheKeyGenerator cacheResultCacheKeyGenerator = cacheResult == null ? null : this.cacheKeyGeneratorFor(defaults, cacheResult.cacheKeyGenerator());
        CachePut cachePut = ic.getMethod().getAnnotation(CachePut.class);
        String cachePutCachePutName = cachePut == null ? null : CDIJCacheHelper.defaultName(ic.getMethod(), defaults, cachePut.cacheName());
        CacheResolverFactory cachePutCacheResolverFactory = cachePut == null ? null : this.cacheResolverFactoryFor(defaults, cachePut.cacheResolverFactory());
        CacheKeyGenerator cachePutCacheKeyGenerator = cachePut == null ? null : this.cacheKeyGeneratorFor(defaults, cachePut.cacheKeyGenerator());
        CacheRemove cacheRemove = ic.getMethod().getAnnotation(CacheRemove.class);
        String cacheRemoveCacheRemoveName = cacheRemove == null ? null : CDIJCacheHelper.defaultName(ic.getMethod(), defaults, cacheRemove.cacheName());
        CacheResolverFactory cacheRemoveCacheResolverFactory = cacheRemove == null ? null : this.cacheResolverFactoryFor(defaults, cacheRemove.cacheResolverFactory());
        CacheKeyGenerator cacheRemoveCacheKeyGenerator = cacheRemove == null ? null : this.cacheKeyGeneratorFor(defaults, cacheRemove.cacheKeyGenerator());
        CacheRemoveAll cacheRemoveAll = ic.getMethod().getAnnotation(CacheRemoveAll.class);
        String cacheRemoveAllCacheRemoveAllName = cacheRemoveAll == null ? null : CDIJCacheHelper.defaultName(ic.getMethod(), defaults, cacheRemoveAll.cacheName());
        CacheResolverFactory cacheRemoveAllCacheResolverFactory = cacheRemoveAll == null ? null : this.cacheResolverFactoryFor(defaults, cacheRemoveAll.cacheResolverFactory());
        return new MethodMeta(parameterTypes, annotations, mtdAnnotations, CDIJCacheHelper.keyParameterIndexes(ic.getMethod()), CDIJCacheHelper.getValueParameter(annotations), CDIJCacheHelper.getKeyParameters(annotations), cacheResultCacheResultName, cacheResultCacheResolverFactory, cacheResultCacheKeyGenerator, cacheResult, cachePutCachePutName, cachePutCacheResolverFactory, cachePutCacheKeyGenerator, cachePut != null && cachePut.afterInvocation(), cachePut, cacheRemoveCacheRemoveName, cacheRemoveCacheResolverFactory, cacheRemoveCacheKeyGenerator, cacheRemove != null && cacheRemove.afterInvocation(), cacheRemove, cacheRemoveAllCacheRemoveAllName, cacheRemoveAllCacheResolverFactory, cacheRemoveAll != null && cacheRemoveAll.afterInvocation(), cacheRemoveAll);
    }

    private static Integer[] getKeyParameters(List<Set<Annotation>> annotations) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int idx = 0;
        for (Set<Annotation> set : annotations) {
            for (Annotation a : set) {
                if (a.annotationType() != CacheKey.class) continue;
                list.add(idx);
            }
            ++idx;
        }
        if (list.isEmpty()) {
            for (int i = 0; i < annotations.size(); ++i) {
                list.add(i);
            }
        }
        return list.toArray(new Integer[0]);
    }

    private static Integer getValueParameter(List<Set<Annotation>> annotations) {
        boolean idx = false;
        for (Set<Annotation> set : annotations) {
            for (Annotation a : set) {
                if (a.annotationType() != CacheValue.class) continue;
                return 0;
            }
        }
        return -1;
    }

    private static String defaultName(Method method, CacheDefaults defaults, String cacheName) {
        CharSequence name;
        if (!cacheName.isEmpty()) {
            return cacheName;
        }
        if (defaults != null && !((String)(name = defaults.cacheName())).isEmpty()) {
            return name;
        }
        name = new StringBuilder(method.getDeclaringClass().getName());
        ((StringBuilder)name).append(".");
        ((StringBuilder)name).append(method.getName());
        ((StringBuilder)name).append("(");
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int pIdx = 0; pIdx < parameterTypes.length; ++pIdx) {
            ((StringBuilder)name).append(parameterTypes[pIdx].getName());
            if (pIdx + 1 >= parameterTypes.length) continue;
            ((StringBuilder)name).append(",");
        }
        ((StringBuilder)name).append(")");
        return ((StringBuilder)name).toString();
    }

    private static CacheDefaults findDefaults(Class<?> targetType, Method method) {
        if (Proxy.isProxyClass(targetType)) {
            Class<?> api = method.getDeclaringClass();
            for (Class<?> type : targetType.getInterfaces()) {
                if (!api.isAssignableFrom(type)) continue;
                return CDIJCacheHelper.extractDefaults(type);
            }
        }
        return CDIJCacheHelper.extractDefaults(targetType);
    }

    private static CacheDefaults extractDefaults(Class<?> type) {
        CacheDefaults annotation = null;
        for (Class<?> clazz = type; clazz != null && clazz != Object.class && (annotation = clazz.getAnnotation(CacheDefaults.class)) == null; clazz = clazz.getSuperclass()) {
        }
        return annotation;
    }

    public boolean isIncluded(Class<?> aClass, Class<?>[] in, Class<?>[] out) {
        if (in.length == 0 && out.length == 0) {
            return false;
        }
        for (Class<?> potentialIn : in) {
            if (!potentialIn.isAssignableFrom(aClass)) continue;
            for (Class<?> potentialOut : out) {
                if (!potentialOut.isAssignableFrom(aClass)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private CacheKeyGenerator cacheKeyGeneratorFor(CacheDefaults defaults, Class<? extends CacheKeyGenerator> cacheKeyGenerator) {
        Class defaultCacheKeyGenerator;
        if (!CacheKeyGenerator.class.equals(cacheKeyGenerator)) {
            return this.instance(cacheKeyGenerator);
        }
        if (defaults != null && !CacheKeyGenerator.class.equals((Object)(defaultCacheKeyGenerator = defaults.cacheKeyGenerator()))) {
            return (CacheKeyGenerator)this.instance(defaultCacheKeyGenerator);
        }
        return this.defaultCacheKeyGenerator;
    }

    private CacheResolverFactory cacheResolverFactoryFor(CacheDefaults defaults, Class<? extends CacheResolverFactory> cacheResolverFactory) {
        Class defaultCacheResolverFactory;
        if (!CacheResolverFactory.class.equals(cacheResolverFactory)) {
            return this.instance(cacheResolverFactory);
        }
        if (defaults != null && !CacheResolverFactory.class.equals((Object)(defaultCacheResolverFactory = defaults.cacheResolverFactory()))) {
            return (CacheResolverFactory)this.instance(defaultCacheResolverFactory);
        }
        return this.defaultCacheResolverFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T instance(Class<T> type) {
        Set beans = this.beanManager.getBeans(type, new Annotation[0]);
        if (beans.isEmpty()) {
            if (CacheKeyGenerator.class == type) {
                return (T)this.defaultCacheKeyGenerator;
            }
            if (CacheResolverFactory.class == type) {
                return (T)this.defaultCacheResolverFactory();
            }
            return null;
        }
        Bean bean = this.beanManager.resolve(beans);
        CreationalContext context = this.beanManager.createCreationalContext((Contextual)bean);
        Class scope = bean.getScope();
        boolean normalScope = this.beanManager.isNormalScope(scope);
        try {
            Object reference = this.beanManager.getReference(bean, (Type)bean.getBeanClass(), context);
            if (!normalScope) {
                this.toRelease.add(context);
            }
            Object object = reference;
            return (T)object;
        }
        finally {
            if (normalScope) {
                context.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheResolverFactoryImpl defaultCacheResolverFactory() {
        if (this.defaultCacheResolverFactory != null) {
            return this.defaultCacheResolverFactory;
        }
        CDIJCacheHelper cDIJCacheHelper = this;
        synchronized (cDIJCacheHelper) {
            if (this.defaultCacheResolverFactory != null) {
                return this.defaultCacheResolverFactory;
            }
            this.defaultCacheResolverFactory = new CacheResolverFactoryImpl();
        }
        return this.defaultCacheResolverFactory;
    }

    private static Integer[] keyParameterIndexes(Method method) {
        Annotation[] annotations;
        int i;
        LinkedList<Integer> keys = new LinkedList<Integer>();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        block0: for (i = 0; i < method.getParameterTypes().length; ++i) {
            for (Annotation a : annotations = parameterAnnotations[i]) {
                if (!a.annotationType().equals(CacheKey.class)) continue;
                keys.add(i);
                continue block0;
            }
        }
        if (keys.isEmpty()) {
            for (i = 0; i < method.getParameterTypes().length; ++i) {
                annotations = parameterAnnotations[i];
                boolean value = false;
                for (Annotation a : annotations) {
                    if (!a.annotationType().equals(CacheValue.class)) continue;
                    value = true;
                    break;
                }
                if (value) continue;
                keys.add(i);
            }
        }
        return keys.toArray(new Integer[0]);
    }

    public static class MethodMeta {
        private final Class<?>[] parameterTypes;
        private final List<Set<Annotation>> parameterAnnotations;
        private final Set<Annotation> annotations;
        private final Integer[] keysIndices;
        private final Integer valueIndex;
        private final Integer[] parameterIndices;
        private final String cacheResultCacheName;
        private final CacheResolverFactory cacheResultResolverFactory;
        private final CacheKeyGenerator cacheResultKeyGenerator;
        private final CacheResult cacheResult;
        private final String cachePutCacheName;
        private final CacheResolverFactory cachePutResolverFactory;
        private final CacheKeyGenerator cachePutKeyGenerator;
        private final boolean cachePutAfter;
        private final CachePut cachePut;
        private final String cacheRemoveCacheName;
        private final CacheResolverFactory cacheRemoveResolverFactory;
        private final CacheKeyGenerator cacheRemoveKeyGenerator;
        private final boolean cacheRemoveAfter;
        private final CacheRemove cacheRemove;
        private final String cacheRemoveAllCacheName;
        private final CacheResolverFactory cacheRemoveAllResolverFactory;
        private final boolean cacheRemoveAllAfter;
        private final CacheRemoveAll cacheRemoveAll;

        public MethodMeta(Class<?>[] parameterTypes, List<Set<Annotation>> parameterAnnotations, Set<Annotation> annotations, Integer[] keysIndices, Integer valueIndex, Integer[] parameterIndices, String cacheResultCacheName, CacheResolverFactory cacheResultResolverFactory, CacheKeyGenerator cacheResultKeyGenerator, CacheResult cacheResult, String cachePutCacheName, CacheResolverFactory cachePutResolverFactory, CacheKeyGenerator cachePutKeyGenerator, boolean cachePutAfter, CachePut cachePut, String cacheRemoveCacheName, CacheResolverFactory cacheRemoveResolverFactory, CacheKeyGenerator cacheRemoveKeyGenerator, boolean cacheRemoveAfter, CacheRemove cacheRemove, String cacheRemoveAllCacheName, CacheResolverFactory cacheRemoveAllResolverFactory, boolean cacheRemoveAllAfter, CacheRemoveAll cacheRemoveAll) {
            this.parameterTypes = parameterTypes;
            this.parameterAnnotations = parameterAnnotations;
            this.annotations = annotations;
            this.keysIndices = keysIndices;
            this.valueIndex = valueIndex;
            this.parameterIndices = parameterIndices;
            this.cacheResultCacheName = cacheResultCacheName;
            this.cacheResultResolverFactory = cacheResultResolverFactory;
            this.cacheResultKeyGenerator = cacheResultKeyGenerator;
            this.cacheResult = cacheResult;
            this.cachePutCacheName = cachePutCacheName;
            this.cachePutResolverFactory = cachePutResolverFactory;
            this.cachePutKeyGenerator = cachePutKeyGenerator;
            this.cachePutAfter = cachePutAfter;
            this.cachePut = cachePut;
            this.cacheRemoveCacheName = cacheRemoveCacheName;
            this.cacheRemoveResolverFactory = cacheRemoveResolverFactory;
            this.cacheRemoveKeyGenerator = cacheRemoveKeyGenerator;
            this.cacheRemoveAfter = cacheRemoveAfter;
            this.cacheRemove = cacheRemove;
            this.cacheRemoveAllCacheName = cacheRemoveAllCacheName;
            this.cacheRemoveAllResolverFactory = cacheRemoveAllResolverFactory;
            this.cacheRemoveAllAfter = cacheRemoveAllAfter;
            this.cacheRemoveAll = cacheRemoveAll;
        }

        public boolean isCacheRemoveAfter() {
            return this.cacheRemoveAfter;
        }

        public boolean isCachePutAfter() {
            return this.cachePutAfter;
        }

        public Class<?>[] getParameterTypes() {
            return this.parameterTypes;
        }

        public List<Set<Annotation>> getParameterAnnotations() {
            return this.parameterAnnotations;
        }

        public String getCacheResultCacheName() {
            return this.cacheResultCacheName;
        }

        public CacheResolverFactory getCacheResultResolverFactory() {
            return this.cacheResultResolverFactory;
        }

        public CacheKeyGenerator getCacheResultKeyGenerator() {
            return this.cacheResultKeyGenerator;
        }

        public CacheResult getCacheResult() {
            return this.cacheResult;
        }

        public Integer[] getParameterIndices() {
            return this.parameterIndices;
        }

        public Set<Annotation> getAnnotations() {
            return this.annotations;
        }

        public Integer[] getKeysIndices() {
            return this.keysIndices;
        }

        public Integer getValuesIndex() {
            return this.valueIndex;
        }

        public Integer getValueIndex() {
            return this.valueIndex;
        }

        public String getCachePutCacheName() {
            return this.cachePutCacheName;
        }

        public CacheResolverFactory getCachePutResolverFactory() {
            return this.cachePutResolverFactory;
        }

        public CacheKeyGenerator getCachePutKeyGenerator() {
            return this.cachePutKeyGenerator;
        }

        public CachePut getCachePut() {
            return this.cachePut;
        }

        public String getCacheRemoveCacheName() {
            return this.cacheRemoveCacheName;
        }

        public CacheResolverFactory getCacheRemoveResolverFactory() {
            return this.cacheRemoveResolverFactory;
        }

        public CacheKeyGenerator getCacheRemoveKeyGenerator() {
            return this.cacheRemoveKeyGenerator;
        }

        public CacheRemove getCacheRemove() {
            return this.cacheRemove;
        }

        public String getCacheRemoveAllCacheName() {
            return this.cacheRemoveAllCacheName;
        }

        public CacheResolverFactory getCacheRemoveAllResolverFactory() {
            return this.cacheRemoveAllResolverFactory;
        }

        public boolean isCacheRemoveAllAfter() {
            return this.cacheRemoveAllAfter;
        }

        public CacheRemoveAll getCacheRemoveAll() {
            return this.cacheRemoveAll;
        }
    }

    private static final class MethodKey {
        private final Class<?> base;
        private final Method delegate;
        private final int hash;

        private MethodKey(Class<?> base, Method delegate) {
            this.base = base;
            this.delegate = delegate;
            this.hash = 31 * delegate.hashCode() + (base == null ? 0 : base.hashCode());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodKey classKey = (MethodKey)MethodKey.class.cast(o);
            return this.delegate.equals(classKey.delegate) && (this.base == null && classKey.base == null || this.base != null && this.base.equals(classKey.base));
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

