/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.jcache.cdi;

import java.io.Serializable;
import java.lang.reflect.Method;
import javax.annotation.Priority;
import javax.cache.Cache;
import javax.cache.annotation.CacheDefaults;
import javax.cache.annotation.CacheKeyInvocationContext;
import javax.cache.annotation.CachePut;
import javax.cache.annotation.GeneratedCacheKey;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.apache.commons.jcs.jcache.cdi.CDIJCacheHelper;
import org.apache.commons.jcs.jcache.cdi.CacheKeyInvocationContextImpl;

@CachePut
@Interceptor
@Priority(value=1000)
public class CachePutInterceptor
implements Serializable {
    @Inject
    private CDIJCacheHelper helper;

    @AroundInvoke
    public Object cache(InvocationContext ic) throws Throwable {
        Object result;
        CacheDefaults defaults = this.helper.findDefaults(ic);
        Method method = ic.getMethod();
        CachePut cachePut = method.getAnnotation(CachePut.class);
        String cacheName = this.helper.defaultName(method, defaults, cachePut.cacheName());
        boolean afterInvocation = cachePut.afterInvocation();
        CacheKeyInvocationContextImpl<CachePut> context = new CacheKeyInvocationContextImpl<CachePut>(ic, cachePut, cacheName, this.helper.keyParameterIndexes(method));
        if (!afterInvocation) {
            this.doCache(context, defaults, cachePut);
        }
        try {
            result = ic.proceed();
        }
        catch (Throwable t) {
            if (afterInvocation && this.helper.isIncluded(t.getClass(), cachePut.cacheFor(), cachePut.noCacheFor())) {
                this.doCache(context, defaults, cachePut);
            }
            throw t;
        }
        if (afterInvocation) {
            this.doCache(context, defaults, cachePut);
        }
        return result;
    }

    private void doCache(CacheKeyInvocationContext<CachePut> context, CacheDefaults defaults, CachePut cachePut) {
        Cache cache = this.helper.cacheResolverFactoryFor(defaults, cachePut.cacheResolverFactory()).getCacheResolver(context).resolveCache(context);
        GeneratedCacheKey key = this.helper.cacheKeyGeneratorFor(defaults, cachePut.cacheKeyGenerator()).generateCacheKey(context);
        cache.put((Object)key, context.getValueParameter().getValue());
    }
}

