/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.jcache.cdi;

import javax.cache.Cache;
import javax.cache.annotation.CacheDefaults;
import javax.cache.annotation.CacheKeyInvocationContext;
import javax.cache.annotation.CacheRemove;
import javax.cache.annotation.GeneratedCacheKey;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.apache.commons.jcs.jcache.cdi.CDIJCacheHelper;
import org.apache.commons.jcs.jcache.cdi.CacheKeyInvocationContextImpl;

@CacheRemove
@Interceptor
public class CacheRemoveInterceptor {
    @Inject
    private CDIJCacheHelper helper;

    @AroundInvoke
    public Object cache(InvocationContext ic) throws Throwable {
        Object result;
        CacheDefaults defaults = this.helper.findDefaults(ic);
        CacheRemove cacheRemove = ic.getMethod().getAnnotation(CacheRemove.class);
        String cacheName = this.helper.defaultName(ic.getMethod(), defaults, cacheRemove.cacheName());
        boolean afterInvocation = cacheRemove.afterInvocation();
        CacheKeyInvocationContextImpl<CacheRemove> context = new CacheKeyInvocationContextImpl<CacheRemove>(ic, cacheRemove, cacheName);
        if (!afterInvocation) {
            this.doRemove(context, defaults, cacheRemove);
        }
        try {
            result = ic.proceed();
        }
        catch (Throwable t) {
            if (afterInvocation && this.helper.isIncluded(t.getClass(), cacheRemove.evictFor(), cacheRemove.noEvictFor())) {
                this.doRemove(context, defaults, cacheRemove);
            }
            throw t;
        }
        if (afterInvocation) {
            this.doRemove(context, defaults, cacheRemove);
        }
        return result;
    }

    private void doRemove(CacheKeyInvocationContext<CacheRemove> context, CacheDefaults defaults, CacheRemove cacheRemove) {
        Cache cache = this.helper.cacheResolverFactoryFor(defaults, cacheRemove.cacheResolverFactory()).getCacheResolver(context).resolveCache(context);
        GeneratedCacheKey key = this.helper.cacheKeyGeneratorFor(defaults, cacheRemove.cacheKeyGenerator()).generateCacheKey(context);
        cache.remove((Object)key);
    }
}

