/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.jcache.openjpa;

import java.net.URI;
import java.util.Map;
import java.util.Properties;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.FactoryBuilder;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.cache.spi.CachingProvider;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.datacache.DataCacheManagerImpl;
import org.apache.openjpa.lib.conf.ObjectValue;

public class OpenJPAJCacheDataCacheManager
extends DataCacheManagerImpl {
    private CachingProvider provider;
    private CacheManager cacheManager;

    public void initialize(OpenJPAConfiguration conf, ObjectValue dataCache, ObjectValue queryCache) {
        super.initialize(conf, dataCache, queryCache);
        this.provider = Caching.getCachingProvider();
        Properties properties = new Properties();
        Map props = conf.toProperties(false);
        if (props != null) {
            for (Map.Entry entry : props.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                properties.setProperty(entry.getKey().toString(), entry.getValue().toString());
            }
        }
        String uri = properties.getProperty("jcache.uri", this.provider.getDefaultURI().toString());
        this.cacheManager = this.provider.getCacheManager(URI.create(uri), this.provider.getDefaultClassLoader(), properties);
    }

    public void close() {
        super.close();
        if (!this.cacheManager.isClosed()) {
            this.cacheManager.close();
        }
        this.provider.close();
    }

    Cache<Object, Object> getOrCreateCache(String prefix, String entity) {
        String internalName = prefix + entity;
        Cache cache = this.cacheManager.getCache(internalName);
        if (cache == null) {
            String expirtyPolicy;
            Properties properties = this.cacheManager.getProperties();
            MutableConfiguration configuration = new MutableConfiguration().setStoreByValue("true".equalsIgnoreCase(properties.getProperty("jcache.store-by-value", "false")));
            configuration.setReadThrough("true".equals(properties.getProperty("jcache.read-through", "false")));
            configuration.setWriteThrough("true".equals(properties.getProperty("jcache.write-through", "false")));
            if (configuration.isReadThrough()) {
                configuration.setCacheLoaderFactory((Factory)new FactoryBuilder.ClassFactory(properties.getProperty("jcache.cache-loader-factory")));
            }
            if (configuration.isWriteThrough()) {
                configuration.setCacheWriterFactory((Factory)new FactoryBuilder.ClassFactory(properties.getProperty("jcache.cache-writer-factory")));
            }
            if ((expirtyPolicy = properties.getProperty("jcache.expiry-policy-factory")) != null) {
                configuration.setExpiryPolicyFactory((Factory)new FactoryBuilder.ClassFactory(expirtyPolicy));
            } else {
                configuration.setExpiryPolicyFactory((Factory)new FactoryBuilder.SingletonFactory((Object)new CreatedExpiryPolicy(Duration.FIVE_MINUTES)));
            }
            configuration.setManagementEnabled("true".equals(properties.getProperty("jcache.management-enabled", "false")));
            configuration.setStatisticsEnabled("true".equals(properties.getProperty("jcache.statistics-enabled", "false")));
            cache = this.cacheManager.createCache(internalName, (Configuration)configuration);
        }
        return cache;
    }

    CacheManager getCacheManager() {
        return this.cacheManager;
    }
}

