/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.jcache.openjpa;

import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.cache.Cache;
import javax.cache.CacheManager;
import org.apache.commons.jcs.jcache.openjpa.OpenJPAJCacheDataCacheManager;
import org.apache.openjpa.datacache.AbstractDataCache;
import org.apache.openjpa.datacache.DataCacheManager;
import org.apache.openjpa.datacache.DataCachePCData;
import org.apache.openjpa.util.OpenJPAId;

public class OpenJPAJCacheDataCache
extends AbstractDataCache {
    private static final String OPENJPA_PREFIX = "openjpa.datacache.";
    private final Lock lock = new ReentrantLock();
    private OpenJPAJCacheDataCacheManager manager;

    public void initialize(DataCacheManager manager) {
        super.initialize(manager);
        this.manager = (OpenJPAJCacheDataCacheManager)((Object)OpenJPAJCacheDataCacheManager.class.cast(manager));
    }

    protected DataCachePCData getInternal(Object oid) {
        Object result = null;
        if (OpenJPAId.class.isInstance(oid)) {
            Class cls = ((OpenJPAId)OpenJPAId.class.cast(oid)).getType();
            Cache<Object, Object> cache = this.manager.getOrCreateCache(OPENJPA_PREFIX, cls.getName());
            if (cache == null) {
                return null;
            }
            result = cache.get(oid);
        } else {
            String cacheName;
            CacheManager cacheManager = this.manager.getCacheManager();
            Iterator i$ = cacheManager.getCacheNames().iterator();
            while (i$.hasNext() && (!(cacheName = (String)i$.next()).startsWith(OPENJPA_PREFIX) || (result = cacheManager.getCache(cacheName).get(oid)) == null)) {
            }
        }
        if (result == null) {
            return null;
        }
        return (DataCachePCData)DataCachePCData.class.cast(result);
    }

    protected DataCachePCData putInternal(Object oid, DataCachePCData pc) {
        this.manager.getOrCreateCache(OPENJPA_PREFIX, pc.getType().getName()).put(oid, (Object)pc);
        return pc;
    }

    protected DataCachePCData removeInternal(Object oid) {
        if (OpenJPAId.class.isInstance(oid)) {
            Object remove = this.manager.getOrCreateCache(OPENJPA_PREFIX, ((OpenJPAId)OpenJPAId.class.cast(oid)).getType().getName()).getAndRemove(oid);
            if (remove == null) {
                return null;
            }
            return (DataCachePCData)DataCachePCData.class.cast(remove);
        }
        return null;
    }

    protected void removeAllInternal(Class<?> cls, boolean subclasses) {
        String name = subclasses ? cls.getSuperclass().getName() : cls.getName();
        this.manager.getOrCreateCache(OPENJPA_PREFIX, name).removeAll();
    }

    protected void clearInternal() {
        CacheManager cacheManager = this.manager.getCacheManager();
        for (String cacheName : cacheManager.getCacheNames()) {
            if (!cacheName.startsWith(OPENJPA_PREFIX)) continue;
            cacheManager.getCache(cacheName).clear();
        }
    }

    protected boolean pinInternal(Object oid) {
        throw new UnsupportedOperationException();
    }

    protected boolean unpinInternal(Object oid) {
        throw new UnsupportedOperationException();
    }

    public void writeLock() {
        this.lock.lock();
    }

    public void writeUnlock() {
        this.lock.unlock();
    }
}

