/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.jcache.extras.writer;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import javax.cache.Cache;
import javax.cache.configuration.Factory;
import javax.cache.integration.CacheWriter;
import javax.cache.integration.CacheWriterException;
import org.apache.commons.jcs.jcache.extras.closeable.Closeables;

public class CompositeCacheWriter<K, V>
implements CacheWriter<K, V>,
Closeable,
Factory<CacheWriter<K, V>> {
    private final CacheWriter<K, V>[] writers;

    public CompositeCacheWriter(CacheWriter<K, V> ... writers) {
        this.writers = writers;
    }

    public void write(Cache.Entry<? extends K, ? extends V> entry) throws CacheWriterException {
        CacheWriterException e = null;
        for (CacheWriter<K, V> writer : this.writers) {
            try {
                writer.write(entry);
            }
            catch (CacheWriterException ex) {
                if (e != null) continue;
                e = ex;
            }
        }
        if (e != null) {
            throw e;
        }
    }

    public void writeAll(Collection<Cache.Entry<? extends K, ? extends V>> entries) throws CacheWriterException {
        CacheWriterException e = null;
        for (CacheWriter<K, V> writer : this.writers) {
            try {
                writer.writeAll(entries);
            }
            catch (CacheWriterException ex) {
                if (e != null) continue;
                e = ex;
            }
        }
        if (e != null) {
            throw e;
        }
    }

    public void delete(Object key) throws CacheWriterException {
        CacheWriterException e = null;
        for (CacheWriter<K, V> writer : this.writers) {
            try {
                writer.delete(key);
            }
            catch (CacheWriterException ex) {
                if (e != null) continue;
                e = ex;
            }
        }
        if (e != null) {
            throw e;
        }
    }

    public void deleteAll(Collection<?> keys) throws CacheWriterException {
        CacheWriterException e = null;
        for (CacheWriter<K, V> writer : this.writers) {
            try {
                writer.deleteAll(keys);
            }
            catch (CacheWriterException ex) {
                if (e != null) continue;
                e = ex;
            }
        }
        if (e != null) {
            throw e;
        }
    }

    public CacheWriter<K, V> create() {
        return this;
    }

    @Override
    public void close() throws IOException {
        Closeables.close(this.writers);
    }
}

