/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.jcache.extras.loader;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.cache.configuration.Factory;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheLoaderException;
import org.apache.commons.jcs.jcache.extras.closeable.Closeables;

public class CompositeCacheLoader<K, V>
implements CacheLoader<K, V>,
Closeable,
Factory<CacheLoader<K, V>> {
    private final CacheLoader<K, V>[] delegates;

    public CompositeCacheLoader(CacheLoader<K, V> ... delegates) {
        this.delegates = delegates;
    }

    public V load(K key) throws CacheLoaderException {
        for (CacheLoader<K, V> delegate : this.delegates) {
            Object v = delegate.load(key);
            if (v == null) continue;
            return (V)v;
        }
        return null;
    }

    public Map<K, V> loadAll(Iterable<? extends K> keys) throws CacheLoaderException {
        ArrayList<K> list = new ArrayList<K>();
        for (K k : keys) {
            list.add(k);
        }
        HashMap result = new HashMap();
        for (CacheLoader<K, V> delegate : this.delegates) {
            Map v = delegate.loadAll(list);
            if (v == null) continue;
            result.putAll(v);
            list.removeAll(v.keySet());
            if (!list.isEmpty()) continue;
            return v;
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        Closeables.close(this.delegates);
    }

    public CacheLoader<K, V> create() {
        return this;
    }
}

