/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.jcache.extras.cdi;

import java.util.Properties;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.spi.CachingProvider;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessBean;
import org.apache.commons.jcs.jcache.extras.cdi.CacheManagerBean;
import org.apache.commons.jcs.jcache.extras.cdi.CacheProviderBean;

public class ExtraJCacheExtension
implements Extension {
    private static final boolean ACTIVATED = "true".equals(System.getProperty("org.apache.jcs.extra.cdi", "true"));
    private boolean cacheManagerFound = false;
    private boolean cacheProviderFound = false;

    public <A> void processBean(@Observes ProcessBean<A> processBeanEvent) {
        if (!ACTIVATED) {
            return;
        }
        if (this.cacheManagerFound && this.cacheProviderFound) {
            return;
        }
        Bean bean = processBeanEvent.getBean();
        if (CacheManagerBean.class.isInstance(bean) || CacheProviderBean.class.isInstance(bean)) {
            return;
        }
        if (!this.cacheManagerFound) {
            this.cacheManagerFound = bean.getTypes().contains(CacheManager.class);
        }
        if (!this.cacheProviderFound) {
            this.cacheProviderFound = bean.getTypes().contains(CachingProvider.class);
        }
    }

    public void addJCacheBeans(@Observes AfterBeanDiscovery afterBeanDiscovery) {
        if (!ACTIVATED) {
            return;
        }
        if (this.cacheManagerFound && this.cacheProviderFound) {
            return;
        }
        CachingProvider cachingProvider = Caching.getCachingProvider();
        if (!this.cacheManagerFound) {
            CacheManager cacheManager = cachingProvider.getCacheManager(cachingProvider.getDefaultURI(), cachingProvider.getDefaultClassLoader(), new Properties());
            afterBeanDiscovery.addBean((Bean)new CacheManagerBean(cacheManager));
        }
        if (!this.cacheProviderFound) {
            afterBeanDiscovery.addBean((Bean)new CacheProviderBean(cachingProvider));
        }
    }
}

