/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.dcx;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.imaging.AbstractImageParser;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.common.BinaryOutputStream;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.common.LittleEndianBinaryOutputStream;
import org.apache.commons.imaging.formats.pcx.PcxImageParser;
import org.apache.commons.imaging.formats.pcx.PcxImagingParameters;

public class DcxImageParser
extends AbstractImageParser<PcxImagingParameters> {
    private static final String DEFAULT_EXTENSION = ImageFormats.DCX.getDefaultExtension();
    private static final String[] ACCEPTED_EXTENSIONS = ImageFormats.DCX.getExtensions();

    public DcxImageParser() {
        super(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public boolean dumpImageFile(PrintWriter pw, ByteSource byteSource) throws ImagingException, IOException {
        this.readDcxHeader(byteSource).dump(pw);
        return true;
    }

    @Override
    protected String[] getAcceptedExtensions() {
        return ACCEPTED_EXTENSIONS;
    }

    @Override
    protected ImageFormat[] getAcceptedTypes() {
        return new ImageFormat[]{ImageFormats.DCX};
    }

    @Override
    public List<BufferedImage> getAllBufferedImages(ByteSource byteSource) throws ImagingException, IOException {
        DcxHeader dcxHeader = this.readDcxHeader(byteSource);
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        PcxImageParser pcxImageParser = new PcxImageParser();
        for (long element : dcxHeader.pageTable) {
            try (InputStream stream = byteSource.getInputStream(element);){
                images.add(pcxImageParser.getBufferedImage(ByteSource.inputStream(stream, null), new PcxImagingParameters()));
            }
        }
        return images;
    }

    @Override
    public final BufferedImage getBufferedImage(ByteSource byteSource, PcxImagingParameters params) throws ImagingException, IOException {
        List<BufferedImage> list = this.getAllBufferedImages(byteSource);
        return list.isEmpty() ? null : list.get(0);
    }

    @Override
    public String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }

    @Override
    public PcxImagingParameters getDefaultParameters() {
        return new PcxImagingParameters();
    }

    @Override
    public byte[] getIccProfileBytes(ByteSource byteSource, PcxImagingParameters params) throws ImagingException, IOException {
        return null;
    }

    @Override
    public ImageInfo getImageInfo(ByteSource byteSource, PcxImagingParameters params) throws ImagingException, IOException {
        return null;
    }

    @Override
    public Dimension getImageSize(ByteSource byteSource, PcxImagingParameters params) throws ImagingException, IOException {
        return null;
    }

    @Override
    public ImageMetadata getMetadata(ByteSource byteSource, PcxImagingParameters params) throws ImagingException, IOException {
        return null;
    }

    @Override
    public String getName() {
        return "Dcx-Custom";
    }

    private DcxHeader readDcxHeader(ByteSource byteSource) throws ImagingException, IOException {
        try (InputStream is = byteSource.getInputStream();){
            long pageOffset;
            int id = BinaryFunctions.read4Bytes("Id", is, "Not a Valid DCX File", this.getByteOrder());
            int size = 1024;
            ArrayList pageTable = Allocator.arrayList(1024);
            for (int i = 0; i < 1024 && (pageOffset = 0xFFFFFFFFL & (long)BinaryFunctions.read4Bytes("PageTable", is, "Not a Valid DCX File", this.getByteOrder())) != 0L; ++i) {
                pageTable.add(pageOffset);
            }
            if (id != 987654321) {
                throw new ImagingException("Not a Valid DCX File: file id incorrect");
            }
            if (pageTable.size() == 1024) {
                throw new ImagingException("DCX page table not terminated by zero entry");
            }
            long[] pages = pageTable.stream().mapToLong(Long::longValue).toArray();
            DcxHeader dcxHeader = new DcxHeader(id, pages);
            return dcxHeader;
        }
    }

    @Override
    public void writeImage(BufferedImage src, OutputStream os, PcxImagingParameters params) throws ImagingException, IOException {
        int headerSize = 4100;
        LittleEndianBinaryOutputStream bos = BinaryOutputStream.littleEndian(os);
        ((BinaryOutputStream)bos).write4Bytes(987654321);
        ((BinaryOutputStream)bos).write4Bytes(4100);
        for (int i = 0; i < 1023; ++i) {
            ((BinaryOutputStream)bos).write4Bytes(0);
        }
        new PcxImageParser().writeImage(src, (OutputStream)bos, params);
    }

    private static final class DcxHeader {
        public static final int DCX_ID = 987654321;
        public final int id;
        public final long[] pageTable;

        DcxHeader(int id, long[] pageTable) {
            this.id = id;
            this.pageTable = pageTable;
        }

        public void dump(PrintWriter pw) {
            pw.println("DcxHeader");
            pw.println("Id: 0x" + Integer.toHexString(this.id));
            pw.println("Pages: " + this.pageTable.length);
            pw.println();
        }
    }
}

