/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.color;

import org.apache.commons.imaging.color.ColorCieLab;
import org.apache.commons.imaging.color.ColorCieLch;
import org.apache.commons.imaging.color.ColorCieLuv;
import org.apache.commons.imaging.color.ColorCmy;
import org.apache.commons.imaging.color.ColorCmyk;
import org.apache.commons.imaging.color.ColorDin99Lab;
import org.apache.commons.imaging.color.ColorHsl;
import org.apache.commons.imaging.color.ColorHsv;
import org.apache.commons.imaging.color.ColorHunterLab;
import org.apache.commons.imaging.color.ColorXyz;

public final class ColorConversions {
    private static final double REF_X = 95.047;
    private static final double REF_Y = 100.0;
    private static final double REF_Z = 108.883;
    private static final double XYZ_m = 7.787037;
    private static final double XYZ_t0 = 0.008856;

    public static int convertCieLabToArgbTest(int cieL, int cieA, int cieB) {
        double varY = ((double)cieL * 100.0 / 255.0 + 16.0) / 116.0;
        double varX = (double)cieA / 500.0 + varY;
        double varZ = varY - (double)cieB / 200.0;
        varX = ColorConversions.unPivotXyz(varX);
        varY = ColorConversions.unPivotXyz(varY);
        varZ = ColorConversions.unPivotXyz(varZ);
        double x = 95.047 * varX;
        double y = 100.0 * varY;
        double z = 108.883 * varZ;
        double varX2 = x / 100.0;
        double varY2 = y / 100.0;
        double varZ2 = z / 100.0;
        double varR = varX2 * 3.2406 + varY2 * -1.5372 + varZ2 * -0.4986;
        double varG = varX2 * -0.9689 + varY2 * 1.8758 + varZ2 * 0.0415;
        double varB = varX2 * 0.0557 + varY2 * -0.204 + varZ2 * 1.057;
        varR = ColorConversions.pivotRgb(varR);
        varG = ColorConversions.pivotRgb(varG);
        varB = ColorConversions.pivotRgb(varB);
        double r = varR * 255.0;
        double g = varG * 255.0;
        double b = varB * 255.0;
        return ColorConversions.convertRgbToRgb(r, g, b);
    }

    public static ColorCieLch convertCieLabToCieLch(ColorCieLab cielab) {
        return ColorConversions.convertCieLabToCieLch(cielab.l, cielab.a, cielab.b);
    }

    public static ColorCieLch convertCieLabToCieLch(double l, double a, double b) {
        double atanba = Math.atan2(b, a);
        double h = atanba > 0.0 ? Math.toDegrees(atanba) : Math.toDegrees(atanba) + 360.0;
        double C = Math.sqrt(ColorConversions.square(a) + ColorConversions.square(b));
        return new ColorCieLch(l, C, h);
    }

    public static ColorDin99Lab convertCieLabToDin99bLab(ColorCieLab cie) {
        return ColorConversions.convertCieLabToDin99bLab(cie.l, cie.a, cie.b);
    }

    public static ColorDin99Lab convertCieLabToDin99bLab(double l, double a, double b) {
        double f;
        double e;
        double G;
        double fac1 = 100.0 / Math.log(2.58);
        double kE = 1.0;
        double kCH = 1.0;
        double ang = Math.toRadians(16.0);
        double l99 = 1.0 * fac1 * Math.log(1.0 + 0.0158 * l);
        double a99 = 0.0;
        double b99 = 0.0;
        if ((a != 0.0 || b != 0.0) && (G = Math.sqrt((e = a * Math.cos(ang) + b * Math.sin(ang)) * e + (f = 0.7 * (b * Math.cos(ang) - a * Math.sin(ang))) * f)) != 0.0) {
            double k = Math.log(1.0 + 0.045 * G) / (0.045 * G);
            a99 = k * e;
            b99 = k * f;
        }
        return new ColorDin99Lab(l99, a99, b99);
    }

    public static ColorDin99Lab convertCieLabToDin99oLab(ColorCieLab cie) {
        return ColorConversions.convertCieLabToDin99oLab(cie.l, cie.a, cie.b);
    }

    public static ColorDin99Lab convertCieLabToDin99oLab(double l, double a, double b) {
        double kE = 1.0;
        double kCH = 1.0;
        double fac1 = 100.0 / Math.log(1.39);
        double ang = Math.toRadians(26.0);
        double l99o = fac1 / 1.0 * Math.log(1.0 + 0.0039 * l);
        double a99o = 0.0;
        double b99o = 0.0;
        if (a != 0.0 || b != 0.0) {
            double eo = a * Math.cos(ang) + b * Math.sin(ang);
            double fo = 0.83 * (b * Math.cos(ang) - a * Math.sin(ang));
            double Go = Math.sqrt(eo * eo + fo * fo);
            double C99o = Math.log(1.0 + 0.075 * Go) / 0.0435;
            double heofo = Math.atan2(fo, eo);
            double h99o = heofo + ang;
            a99o = C99o * Math.cos(h99o);
            b99o = C99o * Math.sin(h99o);
        }
        return new ColorDin99Lab(l99o, a99o, b99o);
    }

    public static ColorXyz convertCieLabToXyz(ColorCieLab cielab) {
        return ColorConversions.convertCieLabToXyz(cielab.l, cielab.a, cielab.b);
    }

    public static ColorXyz convertCieLabToXyz(double l, double a, double b) {
        double varY = (l + 16.0) / 116.0;
        double varX = a / 500.0 + varY;
        double varZ = varY - b / 200.0;
        varY = ColorConversions.unPivotXyz(varY);
        varX = ColorConversions.unPivotXyz(varX);
        varZ = ColorConversions.unPivotXyz(varZ);
        double x = 95.047 * varX;
        double y = 100.0 * varY;
        double z = 108.883 * varZ;
        return new ColorXyz(x, y, z);
    }

    public static ColorCieLab convertCieLchToCieLab(ColorCieLch cielch) {
        return ColorConversions.convertCieLchToCieLab(cielch.l, cielch.c, cielch.h);
    }

    public static ColorCieLab convertCieLchToCieLab(double l, double c, double h) {
        double a = Math.cos(ColorConversions.degree2radian(h)) * c;
        double b = Math.sin(ColorConversions.degree2radian(h)) * c;
        return new ColorCieLab(l, a, b);
    }

    public static ColorXyz convertCieLuvToXyz(ColorCieLuv cielch) {
        return ColorConversions.convertCieLuvToXyz(cielch.l, cielch.u, cielch.v);
    }

    public static ColorXyz convertCieLuvToXyz(double l, double u, double v) {
        double varY = (l + 16.0) / 116.0;
        varY = ColorConversions.unPivotXyz(varY);
        double refU = 0.19783982482140777;
        double refV = 0.46833630293240974;
        double varU = u / (13.0 * l) + 0.19783982482140777;
        double varV = v / (13.0 * l) + 0.46833630293240974;
        double y = varY * 100.0;
        double x = -(9.0 * y * varU) / ((varU - 4.0) * varV - varU * varV);
        double z = (9.0 * y - 15.0 * varV * y - varV * x) / (3.0 * varV);
        return new ColorXyz(x, y, z);
    }

    public static ColorCmy convertCmykToCmy(ColorCmyk cmyk) {
        return ColorConversions.convertCmykToCmy(cmyk.c, cmyk.m, cmyk.y, cmyk.k);
    }

    public static ColorCmy convertCmykToCmy(double c, double m, double y, double k) {
        c = c * (1.0 - k) + k;
        m = m * (1.0 - k) + k;
        y = y * (1.0 - k) + k;
        return new ColorCmy(c, m, y);
    }

    public static int convertCmykToRgb(int c, int m, int y, int k) {
        double C = (double)c / 255.0;
        double M = (double)m / 255.0;
        double Y = (double)y / 255.0;
        double K = (double)k / 255.0;
        return ColorConversions.convertCmyToRgb(ColorConversions.convertCmykToCmy(C, M, Y, K));
    }

    public static int convertCmykToRgbAdobe(int sc, int sm, int sy, int sk) {
        int red = 255 - (sc + sk);
        int green = 255 - (sm + sk);
        int blue = 255 - (sy + sk);
        return ColorConversions.convertRgbToRgb(red, green, blue);
    }

    public static ColorCmyk convertCmyToCmyk(ColorCmy cmy) {
        double c = cmy.c;
        double m = cmy.m;
        double y = cmy.y;
        double varK = 1.0;
        if (c < varK) {
            varK = c;
        }
        if (m < varK) {
            varK = m;
        }
        if (y < varK) {
            varK = y;
        }
        if (varK == 1.0) {
            c = 0.0;
            m = 0.0;
            y = 0.0;
        } else {
            c = (c - varK) / (1.0 - varK);
            m = (m - varK) / (1.0 - varK);
            y = (y - varK) / (1.0 - varK);
        }
        return new ColorCmyk(c, m, y, varK);
    }

    public static int convertCmyToRgb(ColorCmy cmy) {
        double r = (1.0 - cmy.c) * 255.0;
        double g = (1.0 - cmy.m) * 255.0;
        double b = (1.0 - cmy.y) * 255.0;
        return ColorConversions.convertRgbToRgb(r, g, b);
    }

    public static ColorCieLab convertDin99bLabToCieLab(ColorDin99Lab dinb) {
        return ColorConversions.convertDin99bLabToCieLab(dinb.l99, dinb.a99, dinb.b99);
    }

    public static ColorCieLab convertDin99bLabToCieLab(double L99b, double a99b, double b99b) {
        double kE = 1.0;
        double kCH = 1.0;
        double fac1 = 100.0 / Math.log(2.58);
        double ang = Math.toRadians(16.0);
        double hef = Math.atan2(b99b, a99b);
        double c = Math.sqrt(a99b * a99b + b99b * b99b);
        double g = (Math.exp(0.045 * c * 1.0 * 1.0) - 1.0) / 0.045;
        double e = g * Math.cos(hef);
        double f = g * Math.sin(hef) / 0.7;
        double l = (Math.exp(L99b * 1.0 / fac1) - 1.0) / 0.0158;
        double a = e * Math.cos(ang) - f * Math.sin(ang);
        double b = e * Math.sin(ang) + f * Math.cos(ang);
        return new ColorCieLab(l, a, b);
    }

    public static ColorCieLab convertDin99oLabToCieLab(ColorDin99Lab dino) {
        return ColorConversions.convertDin99oLabToCieLab(dino.l99, dino.a99, dino.b99);
    }

    public static ColorCieLab convertDin99oLabToCieLab(double l99o, double a99o, double b99o) {
        double kE = 1.0;
        double kCH = 1.0;
        double fac1 = 100.0 / Math.log(1.39);
        double ang = Math.toRadians(26.0);
        double l = (Math.exp(l99o * 1.0 / fac1) - 1.0) / 0.0039;
        double h99ef = Math.atan2(b99o, a99o);
        double heofo = h99ef - ang;
        double c99 = Math.sqrt(a99o * a99o + b99o * b99o);
        double g = (Math.exp(0.0435 * c99) - 1.0) / 0.075;
        double e = g * Math.cos(heofo);
        double f = g * Math.sin(heofo);
        double a = e * Math.cos(ang) - f / 0.83 * Math.sin(ang);
        double b = e * Math.sin(ang) + f / 0.83 * Math.cos(ang);
        return new ColorCieLab(l, a, b);
    }

    public static int convertHslToRgb(ColorHsl hsl) {
        return ColorConversions.convertHslToRgb(hsl.h, hsl.s, hsl.l);
    }

    public static int convertHslToRgb(double h, double s, double l) {
        double b;
        double g;
        double r;
        if (s == 0.0) {
            r = l * 255.0;
            g = l * 255.0;
            b = l * 255.0;
        } else {
            double var2 = l < 0.5 ? l * (1.0 + s) : l + s - s * l;
            double var1 = 2.0 * l - var2;
            r = 255.0 * ColorConversions.convertHueToRgb(var1, var2, h + 0.3333333333333333);
            g = 255.0 * ColorConversions.convertHueToRgb(var1, var2, h);
            b = 255.0 * ColorConversions.convertHueToRgb(var1, var2, h - 0.3333333333333333);
        }
        return ColorConversions.convertRgbToRgb(r, g, b);
    }

    public static int convertHsvToRgb(ColorHsv HSV) {
        return ColorConversions.convertHsvToRgb(HSV.h, HSV.s, HSV.v);
    }

    public static int convertHsvToRgb(double h, double s, double v) {
        double b;
        double g;
        double r;
        if (s == 0.0) {
            r = v * 255.0;
            g = v * 255.0;
            b = v * 255.0;
        } else {
            double varB;
            double varG;
            double varR;
            double varH = h * 6.0;
            if (varH == 6.0) {
                varH = 0.0;
            }
            double varI = Math.floor(varH);
            double var1 = v * (1.0 - s);
            double var2 = v * (1.0 - s * (varH - varI));
            double var3 = v * (1.0 - s * (1.0 - (varH - varI)));
            if (varI == 0.0) {
                varR = v;
                varG = var3;
                varB = var1;
            } else if (varI == 1.0) {
                varR = var2;
                varG = v;
                varB = var1;
            } else if (varI == 2.0) {
                varR = var1;
                varG = v;
                varB = var3;
            } else if (varI == 3.0) {
                varR = var1;
                varG = var2;
                varB = v;
            } else if (varI == 4.0) {
                varR = var3;
                varG = var1;
                varB = v;
            } else {
                varR = v;
                varG = var1;
                varB = var2;
            }
            r = varR * 255.0;
            g = varG * 255.0;
            b = varB * 255.0;
        }
        return ColorConversions.convertRgbToRgb(r, g, b);
    }

    private static double convertHueToRgb(double v1, double v2, double vH) {
        if (vH < 0.0) {
            vH += 1.0;
        }
        if (vH > 1.0) {
            vH -= 1.0;
        }
        if (6.0 * vH < 1.0) {
            return v1 + (v2 - v1) * 6.0 * vH;
        }
        if (2.0 * vH < 1.0) {
            return v2;
        }
        if (3.0 * vH < 2.0) {
            return v1 + (v2 - v1) * (0.6666666666666666 - vH) * 6.0;
        }
        return v1;
    }

    public static ColorXyz convertHunterLabToXyz(ColorHunterLab cielab) {
        return ColorConversions.convertHunterLabToXyz(cielab.l, cielab.a, cielab.b);
    }

    public static ColorXyz convertHunterLabToXyz(double l, double a, double b) {
        double varY = l / 10.0;
        double varX = a / 17.5 * l / 10.0;
        double varZ = b / 7.0 * l / 10.0;
        double y = Math.pow(varY, 2.0);
        double x = (varX + y) / 1.02;
        double z = -(varZ - y) / 0.847;
        return new ColorXyz(x, y, z);
    }

    public static ColorCmy convertRgbToCmy(int rgb) {
        int r = 0xFF & rgb >> 16;
        int g = 0xFF & rgb >> 8;
        int b = 0xFF & rgb >> 0;
        double c = 1.0 - (double)r / 255.0;
        double m = 1.0 - (double)g / 255.0;
        double y = 1.0 - (double)b / 255.0;
        return new ColorCmy(c, m, y);
    }

    public static ColorHsl convertRgbToHsl(int rgb) {
        double s;
        double h;
        double varMax;
        int r = 0xFF & rgb >> 16;
        int g = 0xFF & rgb >> 8;
        int b = 0xFF & rgb >> 0;
        double varR = (double)r / 255.0;
        double varG = (double)g / 255.0;
        double varB = (double)b / 255.0;
        double varMin = Math.min(varR, Math.min(varG, varB));
        boolean maxIsR = false;
        boolean maxIsG = false;
        if (varR >= varG && varR >= varB) {
            varMax = varR;
            maxIsR = true;
        } else if (varG > varB) {
            varMax = varG;
            maxIsG = true;
        } else {
            varMax = varB;
        }
        double delMax = varMax - varMin;
        double l = (varMax + varMin) / 2.0;
        if (delMax == 0.0) {
            h = 0.0;
            s = 0.0;
        } else {
            s = l < 0.5 ? delMax / (varMax + varMin) : delMax / (2.0 - varMax - varMin);
            double delR = ((varMax - varR) / 6.0 + delMax / 2.0) / delMax;
            double delG = ((varMax - varG) / 6.0 + delMax / 2.0) / delMax;
            double delB = ((varMax - varB) / 6.0 + delMax / 2.0) / delMax;
            h = maxIsR ? delB - delG : (maxIsG ? 0.3333333333333333 + delR - delB : 0.6666666666666666 + delG - delR);
            if (h < 0.0) {
                h += 1.0;
            }
            if (h > 1.0) {
                h -= 1.0;
            }
        }
        return new ColorHsl(h, s, l);
    }

    public static ColorHsv convertRgbToHsv(int rgb) {
        double s;
        double h;
        double varMax;
        int r = 0xFF & rgb >> 16;
        int g = 0xFF & rgb >> 8;
        int b = 0xFF & rgb >> 0;
        double varR = (double)r / 255.0;
        double varG = (double)g / 255.0;
        double varB = (double)b / 255.0;
        double varMin = Math.min(varR, Math.min(varG, varB));
        boolean maxIsR = false;
        boolean maxIsG = false;
        if (varR >= varG && varR >= varB) {
            varMax = varR;
            maxIsR = true;
        } else if (varG > varB) {
            varMax = varG;
            maxIsG = true;
        } else {
            varMax = varB;
        }
        double delMax = varMax - varMin;
        double v = varMax;
        if (delMax == 0.0) {
            h = 0.0;
            s = 0.0;
        } else {
            s = delMax / varMax;
            double delR = ((varMax - varR) / 6.0 + delMax / 2.0) / delMax;
            double delG = ((varMax - varG) / 6.0 + delMax / 2.0) / delMax;
            double delB = ((varMax - varB) / 6.0 + delMax / 2.0) / delMax;
            h = maxIsR ? delB - delG : (maxIsG ? 0.3333333333333333 + delR - delB : 0.6666666666666666 + delG - delR);
            if (h < 0.0) {
                h += 1.0;
            }
            if (h > 1.0) {
                h -= 1.0;
            }
        }
        return new ColorHsv(h, s, v);
    }

    private static int convertRgbToRgb(double r, double g, double b) {
        int red = (int)Math.round(r);
        int green = (int)Math.round(g);
        int blue = (int)Math.round(b);
        red = Math.min(255, Math.max(0, red));
        green = Math.min(255, Math.max(0, green));
        blue = Math.min(255, Math.max(0, blue));
        int alpha = 255;
        return 0xFF000000 | red << 16 | green << 8 | blue << 0;
    }

    private static int convertRgbToRgb(int red, int green, int blue) {
        red = Math.min(255, Math.max(0, red));
        green = Math.min(255, Math.max(0, green));
        blue = Math.min(255, Math.max(0, blue));
        int alpha = 255;
        return 0xFF000000 | red << 16 | green << 8 | blue << 0;
    }

    public static ColorXyz convertRgbToXyz(int rgb) {
        int r = 0xFF & rgb >> 16;
        int g = 0xFF & rgb >> 8;
        int b = 0xFF & rgb >> 0;
        double varR = (double)r / 255.0;
        double varG = (double)g / 255.0;
        double varB = (double)b / 255.0;
        varR = ColorConversions.unPivotRgb(varR);
        varG = ColorConversions.unPivotRgb(varG);
        varB = ColorConversions.unPivotRgb(varB);
        double X = (varR *= 100.0) * 0.4124564 + (varG *= 100.0) * 0.3575761 + (varB *= 100.0) * 0.1804375;
        double Y = varR * 0.2126729 + varG * 0.7151522 + varB * 0.072175;
        double Z = varR * 0.0193339 + varG * 0.119192 + varB * 0.9503041;
        return new ColorXyz(X, Y, Z);
    }

    public static ColorCieLuv convertXuzToCieLuv(double x, double y, double z) {
        double varU = 4.0 * x / (x + 15.0 * y + 3.0 * z);
        double varV = 9.0 * y / (x + 15.0 * y + 3.0 * z);
        double varY = y / 100.0;
        varY = ColorConversions.pivotXyz(varY);
        double refU = 0.19783982482140777;
        double refV = 0.46833630293240974;
        double l = 116.0 * varY - 16.0;
        double u = 13.0 * l * (varU - 0.19783982482140777);
        double v = 13.0 * l * (varV - 0.46833630293240974);
        return new ColorCieLuv(l, u, v);
    }

    public static ColorCieLab convertXyzToCieLab(ColorXyz xyz) {
        return ColorConversions.convertXyzToCieLab(xyz.x, xyz.y, xyz.z);
    }

    public static ColorCieLab convertXyzToCieLab(double x, double y, double z) {
        double varX = x / 95.047;
        double varY = y / 100.0;
        double varZ = z / 108.883;
        varX = ColorConversions.pivotXyz(varX);
        varY = ColorConversions.pivotXyz(varY);
        varZ = ColorConversions.pivotXyz(varZ);
        double l = Math.max(0.0, 116.0 * varY - 16.0);
        double a = 500.0 * (varX - varY);
        double b = 200.0 * (varY - varZ);
        return new ColorCieLab(l, a, b);
    }

    public static ColorCieLuv convertXyzToCieLuv(ColorXyz xyz) {
        return ColorConversions.convertXuzToCieLuv(xyz.x, xyz.y, xyz.z);
    }

    public static ColorHunterLab convertXyzToHunterLab(ColorXyz xyz) {
        return ColorConversions.convertXyzToHunterLab(xyz.x, xyz.y, xyz.z);
    }

    public static ColorHunterLab convertXyzToHunterLab(double x, double y, double z) {
        double l = 10.0 * Math.sqrt(y);
        double a = y == 0.0 ? 0.0 : 17.5 * ((1.02 * x - y) / Math.sqrt(y));
        double b = y == 0.0 ? 0.0 : 7.0 * ((y - 0.847 * z) / Math.sqrt(y));
        return new ColorHunterLab(l, a, b);
    }

    public static int convertXyzToRgb(ColorXyz xyz) {
        return ColorConversions.convertXyzToRgb(xyz.x, xyz.y, xyz.z);
    }

    public static int convertXyzToRgb(double x, double y, double z) {
        double varX = x / 100.0;
        double varY = y / 100.0;
        double varZ = z / 100.0;
        double varR = varX * 3.2404542 + varY * -1.5371385 + varZ * -0.4985314;
        double varG = varX * -0.969266 + varY * 1.8760108 + varZ * 0.041556;
        double varB = varX * 0.0556434 + varY * -0.2040259 + varZ * 1.0572252;
        varR = ColorConversions.pivotRgb(varR);
        varG = ColorConversions.pivotRgb(varG);
        varB = ColorConversions.pivotRgb(varB);
        double r = varR * 255.0;
        double g = varG * 255.0;
        double b = varB * 255.0;
        return ColorConversions.convertRgbToRgb(r, g, b);
    }

    public static double degree2radian(double degree) {
        return degree * Math.PI / 180.0;
    }

    private static double pivotRgb(double n) {
        n = n > 0.0031308 ? 1.055 * Math.pow(n, 0.4166666666666667) - 0.055 : 12.92 * n;
        return n;
    }

    private static double pivotXyz(double n) {
        n = n > 0.008856 ? Math.pow(n, 0.3333333333333333) : 7.787037 * n + 0.13793103448275862;
        return n;
    }

    public static double radian2degree(double radian) {
        return radian * 180.0 / Math.PI;
    }

    private static double square(double f) {
        return f * f;
    }

    private static double unPivotRgb(double n) {
        n = n > 0.04045 ? Math.pow((n + 0.055) / 1.055, 2.4) : (n /= 12.92);
        return n;
    }

    private static double unPivotXyz(double n) {
        double nCube = Math.pow(n, 3.0);
        n = nCube > 0.008856 ? nCube : (n - 0.13793103448275862) / 7.787037;
        return n;
    }

    private ColorConversions() {
    }
}

