/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.bmp;

import java.io.IOException;
import java.nio.ByteOrder;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.formats.bmp.AbstractPixelParserSimple;
import org.apache.commons.imaging.formats.bmp.BmpHeaderInfo;

final class PixelParserRgb
extends AbstractPixelParserSimple {
    private int byteCount;
    private int cachedBitCount;
    private int cachedByte;

    PixelParserRgb(BmpHeaderInfo bhi, byte[] colorTable, byte[] imageData) {
        super(bhi, colorTable, imageData);
    }

    @Override
    public int getNextRgb() throws ImagingException, IOException {
        switch (this.bhi.bitsPerPixel) {
            case 1: 
            case 4: {
                if (this.cachedBitCount < this.bhi.bitsPerPixel) {
                    if (this.cachedBitCount != 0) {
                        throw new ImagingException("Unexpected leftover bits: " + this.cachedBitCount + "/" + this.bhi.bitsPerPixel);
                    }
                    this.cachedBitCount += 8;
                    this.cachedByte = 0xFF & this.imageData[this.byteCount];
                    ++this.byteCount;
                }
                int cacheMask = (1 << this.bhi.bitsPerPixel) - 1;
                int sample = cacheMask & this.cachedByte >> 8 - this.bhi.bitsPerPixel;
                this.cachedByte = 0xFF & this.cachedByte << this.bhi.bitsPerPixel;
                this.cachedBitCount -= this.bhi.bitsPerPixel;
                return this.getColorTableRgb(sample);
            }
            case 8: {
                int sample = 0xFF & this.imageData[this.byteCount + 0];
                int rgb = this.getColorTableRgb(sample);
                ++this.byteCount;
                return rgb;
            }
            case 16: {
                int data = BinaryFunctions.read2Bytes("Pixel", this.is, "BMP Image Data", ByteOrder.LITTLE_ENDIAN);
                int blue = (0x1F & data >> 0) << 3;
                int green = (0x1F & data >> 5) << 3;
                int red = (0x1F & data >> 10) << 3;
                int alpha = 255;
                int rgb = 0xFF000000 | red << 16 | green << 8 | blue << 0;
                this.byteCount += 2;
                return rgb;
            }
            case 24: {
                int blue = 0xFF & this.imageData[this.byteCount + 0];
                int green = 0xFF & this.imageData[this.byteCount + 1];
                int red = 0xFF & this.imageData[this.byteCount + 2];
                int alpha = 255;
                int rgb = 0xFF000000 | red << 16 | green << 8 | blue << 0;
                this.byteCount += 3;
                return rgb;
            }
            case 32: {
                int blue = 0xFF & this.imageData[this.byteCount + 0];
                int green = 0xFF & this.imageData[this.byteCount + 1];
                int red = 0xFF & this.imageData[this.byteCount + 2];
                int alpha = 255;
                int rgb = 0xFF000000 | red << 16 | green << 8 | blue << 0;
                this.byteCount += 4;
                return rgb;
            }
        }
        throw new ImagingException("Unknown BitsPerPixel: " + this.bhi.bitsPerPixel);
    }

    @Override
    public void newline() throws ImagingException, IOException {
        this.cachedBitCount = 0;
        while (this.byteCount % 4 != 0) {
            BinaryFunctions.readByte("Pixel", this.is, "BMP Image Data");
            ++this.byteCount;
        }
    }
}

