/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv.issues;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.QuoteMode;
import org.junit.jupiter.api.Test;

public class JiraCsv213Test {
    private void createEndChannel(File csvFile) {
        CSVFormat csvFormat = CSVFormat.DEFAULT.builder().setDelimiter(';').setHeader(new String[0]).setSkipHeaderRecord(true).setRecordSeparator('\n').setQuoteMode(QuoteMode.ALL).get();
        try (BufferedReader reader = Files.newBufferedReader(csvFile.toPath(), StandardCharsets.UTF_8);
             CSVParser parser = csvFormat.parse((Reader)reader);){
            if (parser.iterator().hasNext()) {
                parser.iterator().next();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Error while adding end channel to CSV", e);
        }
    }

    @Test
    public void test() {
        this.createEndChannel(new File("src/test/resources/org/apache/commons/csv/CSV-213/999751170.patch.csv"));
    }
}

