/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class CSVFileParserTest {
    private static final File BASE_DIR = new File("src/test/resources/org/apache/commons/csv/CSVFileParser");

    public static Stream<File> generateData() {
        File[] files = BASE_DIR.listFiles((dir, name) -> name.startsWith("test") && name.endsWith(".txt"));
        return files != null ? Stream.of(files) : Stream.empty();
    }

    private String readTestData(BufferedReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null && line.startsWith("#")) {
        }
        return line;
    }

    @ParameterizedTest
    @MethodSource(value={"generateData"})
    public void testCSVFile(File testFile) throws Exception {
        try (FileReader fr = new FileReader(testFile);
             BufferedReader testDataReader = new BufferedReader(fr);){
            String line = this.readTestData(testDataReader);
            Assertions.assertNotNull((Object)"file must contain config line", (String)line);
            String[] split = line.split(" ");
            Assertions.assertTrue((split.length >= 1 ? 1 : 0) != 0, (String)(testFile.getName() + " require 1 param"));
            CSVFormat format = CSVFormat.newFormat((char)',').withQuote('\"');
            boolean checkComments = false;
            for (int i = 1; i < split.length; ++i) {
                String option = split[i];
                String[] optionParts = option.split("=", 2);
                if ("IgnoreEmpty".equalsIgnoreCase(optionParts[0])) {
                    format = format.withIgnoreEmptyLines(Boolean.parseBoolean(optionParts[1]));
                    continue;
                }
                if ("IgnoreSpaces".equalsIgnoreCase(optionParts[0])) {
                    format = format.withIgnoreSurroundingSpaces(Boolean.parseBoolean(optionParts[1]));
                    continue;
                }
                if ("CommentStart".equalsIgnoreCase(optionParts[0])) {
                    format = format.withCommentMarker(optionParts[1].charAt(0));
                    continue;
                }
                if ("CheckComments".equalsIgnoreCase(optionParts[0])) {
                    checkComments = true;
                    continue;
                }
                Assertions.fail((String)(testFile.getName() + " unexpected option: " + option));
            }
            line = this.readTestData(testDataReader);
            Assertions.assertEquals((Object)line, (Object)format.toString(), (String)(testFile.getName() + " Expected format "));
            try (CSVParser parser = CSVParser.parse((File)new File(BASE_DIR, split[0]), (Charset)Charset.defaultCharset(), (CSVFormat)format);){
                for (CSVRecord record : parser) {
                    String parsed = Arrays.toString(record.values());
                    String comment = record.getComment();
                    if (checkComments && comment != null) {
                        parsed = parsed + "#" + comment.replace("\n", "\\n");
                    }
                    int count = record.size();
                    Assertions.assertEquals((Object)this.readTestData(testDataReader), (Object)(count + ":" + parsed), (String)testFile.getName());
                }
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"generateData"})
    public void testCSVUrl(File testFile) throws Exception {
        try (FileReader fr = new FileReader(testFile);
             BufferedReader testData = new BufferedReader(fr);){
            String line = this.readTestData(testData);
            Assertions.assertNotNull((Object)"file must contain config line", (String)line);
            String[] split = line.split(" ");
            Assertions.assertTrue((split.length >= 1 ? 1 : 0) != 0, (String)(testFile.getName() + " require 1 param"));
            CSVFormat format = CSVFormat.newFormat((char)',').withQuote('\"');
            boolean checkComments = false;
            for (int i = 1; i < split.length; ++i) {
                String option = split[i];
                String[] optionParts = option.split("=", 2);
                if ("IgnoreEmpty".equalsIgnoreCase(optionParts[0])) {
                    format = format.withIgnoreEmptyLines(Boolean.parseBoolean(optionParts[1]));
                    continue;
                }
                if ("IgnoreSpaces".equalsIgnoreCase(optionParts[0])) {
                    format = format.withIgnoreSurroundingSpaces(Boolean.parseBoolean(optionParts[1]));
                    continue;
                }
                if ("CommentStart".equalsIgnoreCase(optionParts[0])) {
                    format = format.withCommentMarker(optionParts[1].charAt(0));
                    continue;
                }
                if ("CheckComments".equalsIgnoreCase(optionParts[0])) {
                    checkComments = true;
                    continue;
                }
                Assertions.fail((String)(testFile.getName() + " unexpected option: " + option));
            }
            line = this.readTestData(testData);
            Assertions.assertEquals((Object)line, (Object)format.toString(), (String)(testFile.getName() + " Expected format "));
            URL resource = ClassLoader.getSystemResource("org/apache/commons/csv/CSVFileParser/" + split[0]);
            try (CSVParser parser = CSVParser.parse((URL)resource, (Charset)StandardCharsets.UTF_8, (CSVFormat)format);){
                for (CSVRecord record : parser) {
                    String parsed = Arrays.toString(record.values());
                    String comment = record.getComment();
                    if (checkComments && comment != null) {
                        parsed = parsed + "#" + comment.replace("\n", "\\n");
                    }
                    int count = record.size();
                    Assertions.assertEquals((Object)this.readTestData(testData), (Object)(count + ":" + parsed), (String)testFile.getName());
                }
            }
        }
    }
}

