/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.unpack200.bytecode.forms;

import java.util.Arrays;
import org.apache.commons.compress.harmony.pack200.Pack200Exception;
import org.apache.commons.compress.harmony.unpack200.bytecode.ByteCode;
import org.apache.commons.compress.harmony.unpack200.bytecode.OperandManager;
import org.apache.commons.compress.harmony.unpack200.bytecode.forms.SwitchForm;

public class TableSwitchForm
extends SwitchForm {
    public TableSwitchForm(int opcode, String name) {
        super(opcode, name);
    }

    @Override
    public void setByteCodeOperands(ByteCode byteCode, OperandManager operandManager, int codeLength) throws Pack200Exception {
        int caseCount = operandManager.nextCaseCount();
        int defaultPc = operandManager.nextLabel();
        int caseValue = operandManager.nextCaseValues();
        Pack200Exception.checkIntArray(caseCount * 6);
        int[] casePcs = new int[Pack200Exception.checkIntArray(caseCount)];
        Arrays.setAll(casePcs, i -> operandManager.nextLabel());
        int[] labelsArray = new int[Pack200Exception.checkIntArray(caseCount + 1)];
        labelsArray[0] = defaultPc;
        System.arraycopy(casePcs, 0, labelsArray, 1, caseCount + 1 - 1);
        byteCode.setByteCodeTargets(labelsArray);
        int lowValue = caseValue;
        int highValue = lowValue + caseCount - 1;
        int padLength = 3 - codeLength % 4;
        int rewriteSize = 1 + padLength + 4 + 4 + 4 + 4 * casePcs.length;
        int[] newRewrite = new int[Pack200Exception.checkIntArray(rewriteSize)];
        int rewriteIndex = 0;
        newRewrite[rewriteIndex++] = byteCode.getOpcode();
        Arrays.fill(newRewrite, rewriteIndex, rewriteIndex + padLength, 0);
        rewriteIndex += padLength;
        newRewrite[rewriteIndex++] = -1;
        newRewrite[rewriteIndex++] = -1;
        newRewrite[rewriteIndex++] = -1;
        newRewrite[rewriteIndex++] = -1;
        int lowbyteIndex = rewriteIndex;
        this.setRewrite4Bytes(lowValue, lowbyteIndex, newRewrite);
        int highbyteIndex = rewriteIndex += 4;
        this.setRewrite4Bytes(highValue, highbyteIndex, newRewrite);
        Arrays.fill(newRewrite, rewriteIndex += 4, rewriteIndex + caseCount * 4, -1);
        byteCode.setRewrite(newRewrite);
    }
}

