/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.unpack200.bytecode.forms;

import java.util.Arrays;
import org.apache.commons.compress.harmony.pack200.Pack200Exception;
import org.apache.commons.compress.harmony.unpack200.bytecode.ByteCode;
import org.apache.commons.compress.harmony.unpack200.bytecode.OperandManager;
import org.apache.commons.compress.harmony.unpack200.bytecode.forms.SwitchForm;

public class LookupSwitchForm
extends SwitchForm {
    public LookupSwitchForm(int opcode, String name) {
        super(opcode, name);
    }

    @Override
    public void setByteCodeOperands(ByteCode byteCode, OperandManager operandManager, int codeLength) throws Pack200Exception {
        int caseCount = operandManager.nextCaseCount();
        int defaultPc = operandManager.nextLabel();
        Pack200Exception.checkIntArray(caseCount * 8);
        int[] caseValues = new int[Pack200Exception.checkIntArray(caseCount)];
        Arrays.setAll(caseValues, i -> operandManager.nextCaseValues());
        int[] casePcs = new int[Pack200Exception.checkIntArray(caseCount)];
        Arrays.setAll(casePcs, i -> operandManager.nextLabel());
        int[] labelsArray = new int[Pack200Exception.checkIntArray(caseCount + 1)];
        labelsArray[0] = defaultPc;
        System.arraycopy(casePcs, 0, labelsArray, 1, caseCount + 1 - 1);
        byteCode.setByteCodeTargets(labelsArray);
        int padLength = 3 - codeLength % 4;
        int rewriteSize = 1 + padLength + 4 + 4 + 4 * caseValues.length + 4 * casePcs.length;
        int[] newRewrite = new int[Pack200Exception.checkIntArray(rewriteSize)];
        int rewriteIndex = 0;
        newRewrite[rewriteIndex++] = byteCode.getOpcode();
        Arrays.fill(newRewrite, rewriteIndex, rewriteIndex + padLength, 0);
        rewriteIndex += padLength;
        newRewrite[rewriteIndex++] = -1;
        newRewrite[rewriteIndex++] = -1;
        newRewrite[rewriteIndex++] = -1;
        newRewrite[rewriteIndex++] = -1;
        int npairsIndex = rewriteIndex;
        this.setRewrite4Bytes(caseValues.length, npairsIndex, newRewrite);
        rewriteIndex += 4;
        for (int caseValue : caseValues) {
            this.setRewrite4Bytes(caseValue, rewriteIndex, newRewrite);
            rewriteIndex += 4;
            newRewrite[rewriteIndex++] = -1;
            newRewrite[rewriteIndex++] = -1;
            newRewrite[rewriteIndex++] = -1;
            newRewrite[rewriteIndex++] = -1;
        }
        byteCode.setRewrite(newRewrite);
    }
}

