/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.pack200;

import java.util.function.Function;
import org.apache.commons.compress.CompressException;
import org.apache.commons.compress.MemoryLimitException;

public class Pack200Exception
extends CompressException {
    private static final Function<Throwable, Pack200Exception> E_FUNCTION = Pack200Exception::new;
    private static final long serialVersionUID = 5168177401552611803L;

    public static int addExact(int x, long y) throws Pack200Exception {
        return Pack200Exception.addExact(x, y, E_FUNCTION);
    }

    public static int checkIntArray(int size) throws Pack200Exception {
        try {
            MemoryLimitException.checkBytes(4L * (long)size, Runtime.getRuntime().maxMemory());
        }
        catch (MemoryLimitException e) {
            throw new Pack200Exception(e);
        }
        return size;
    }

    public Pack200Exception(String message) {
        super(message);
    }

    public Pack200Exception(String message, Object ... args) {
        super(message, args);
    }

    public Pack200Exception(String message, Throwable cause) {
        super(message, cause);
    }

    public Pack200Exception(Throwable cause) {
        super(cause);
    }
}

