/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.lz4;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;
import org.apache.commons.codec.digest.XXHash32;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.lz4.BlockLZ4CompressorInputStream;
import org.apache.commons.compress.utils.ByteUtils;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.compress.utils.InputStreamStatistics;
import org.apache.commons.io.input.BoundedInputStream;

public class FramedLZ4CompressorInputStream
extends CompressorInputStream
implements InputStreamStatistics {
    static final byte[] LZ4_SIGNATURE = new byte[]{4, 34, 77, 24};
    private static final byte[] SKIPPABLE_FRAME_TRAILER = new byte[]{42, 77, 24};
    private static final byte SKIPPABLE_FRAME_PREFIX_BYTE_MASK = 80;
    static final int VERSION_MASK = 192;
    static final int SUPPORTED_VERSION = 64;
    static final int BLOCK_INDEPENDENCE_MASK = 32;
    static final int BLOCK_CHECKSUM_MASK = 16;
    static final int CONTENT_SIZE_MASK = 8;
    static final int CONTENT_CHECKSUM_MASK = 4;
    static final int BLOCK_MAX_SIZE_MASK = 112;
    static final int UNCOMPRESSED_FLAG_MASK = Integer.MIN_VALUE;
    private final byte[] oneByte = new byte[1];
    private final ByteUtils.ByteSupplier supplier = this::readOneByte;
    private final BoundedInputStream inputStream;
    private final boolean decompressConcatenated;
    private boolean expectBlockChecksum;
    private boolean expectBlockDependency;
    private boolean expectContentChecksum;
    private InputStream currentBlock;
    private boolean endReached;
    private boolean inUncompressed;
    private final XXHash32 contentHash = new XXHash32();
    private final XXHash32 blockHash = new XXHash32();
    private byte[] blockDependencyBuffer;

    private static boolean isSkippableFrameSignature(byte[] b) {
        if ((b[0] & 0x50) != 80) {
            return false;
        }
        for (int i = 1; i < 4; ++i) {
            if (b[i] == SKIPPABLE_FRAME_TRAILER[i - 1]) continue;
            return false;
        }
        return true;
    }

    public static boolean matches(byte[] signature, int length) {
        if (length < LZ4_SIGNATURE.length) {
            return false;
        }
        byte[] shortenedSig = signature;
        if (signature.length > LZ4_SIGNATURE.length) {
            shortenedSig = Arrays.copyOf(signature, LZ4_SIGNATURE.length);
        }
        return Arrays.equals(shortenedSig, LZ4_SIGNATURE);
    }

    public FramedLZ4CompressorInputStream(InputStream in) throws IOException {
        this(in, false);
    }

    public FramedLZ4CompressorInputStream(InputStream in, boolean decompressConcatenated) throws IOException {
        this.inputStream = ((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream(in)).get();
        this.decompressConcatenated = decompressConcatenated;
        this.init(true);
    }

    private void appendToBlockDependencyBuffer(byte[] b, int off, int len) {
        if ((len = Math.min(len, this.blockDependencyBuffer.length)) > 0) {
            int keep = this.blockDependencyBuffer.length - len;
            if (keep > 0) {
                System.arraycopy(this.blockDependencyBuffer, len, this.blockDependencyBuffer, 0, keep);
            }
            System.arraycopy(b, off, this.blockDependencyBuffer, keep, len);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            org.apache.commons.io.IOUtils.close((Closeable)this.currentBlock);
            this.currentBlock = null;
        }
        finally {
            this.inputStream.close();
        }
    }

    @Override
    public long getCompressedCount() {
        return this.inputStream.getCount();
    }

    private void init(boolean firstFrame) throws IOException {
        if (this.readSignature(firstFrame)) {
            this.readFrameDescriptor();
            this.nextBlock();
        }
    }

    private void maybeFinishCurrentBlock() throws IOException {
        if (this.currentBlock != null) {
            this.currentBlock.close();
            this.currentBlock = null;
            if (this.expectBlockChecksum) {
                this.verifyChecksum(this.blockHash, "block");
                this.blockHash.reset();
            }
        }
    }

    private void nextBlock() throws IOException {
        this.maybeFinishCurrentBlock();
        long len = ByteUtils.fromLittleEndian(this.supplier, 4);
        boolean uncompressed = (len & Integer.MIN_VALUE) != 0L;
        int realLen = (int)(len & Integer.MAX_VALUE);
        if (realLen == 0) {
            this.verifyContentChecksum();
            if (!this.decompressConcatenated) {
                this.endReached = true;
            } else {
                this.init(false);
            }
            return;
        }
        Object capped = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)this.inputStream)).setMaxCount((long)realLen)).setPropagateClose(false)).get();
        if (this.expectBlockChecksum) {
            capped = new CheckedInputStream((InputStream)capped, (Checksum)this.blockHash);
        }
        if (uncompressed) {
            this.inUncompressed = true;
            this.currentBlock = capped;
        } else {
            this.inUncompressed = false;
            BlockLZ4CompressorInputStream s = new BlockLZ4CompressorInputStream((InputStream)capped);
            if (this.expectBlockDependency) {
                s.prefill(this.blockDependencyBuffer);
            }
            this.currentBlock = s;
        }
    }

    @Override
    public int read() throws IOException {
        return this.read(this.oneByte, 0, 1) == -1 ? -1 : this.oneByte[0] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (this.endReached) {
            return -1;
        }
        int r = this.readOnce(b, off, len);
        if (r == -1) {
            this.nextBlock();
            if (!this.endReached) {
                r = this.readOnce(b, off, len);
            }
        }
        if (r != -1) {
            if (this.expectBlockDependency) {
                this.appendToBlockDependencyBuffer(b, off, r);
            }
            if (this.expectContentChecksum) {
                this.contentHash.update(b, off, r);
            }
        }
        return r;
    }

    private void readFrameDescriptor() throws IOException {
        int headerHash;
        int flags = this.readOneByte();
        if (flags == -1) {
            throw new CompressorException("Premature end of stream while reading frame flags");
        }
        this.contentHash.update(flags);
        if ((flags & 0xC0) != 64) {
            throw new CompressorException("Unsupported version %s", flags >> 6);
        }
        boolean bl = this.expectBlockDependency = (flags & 0x20) == 0;
        if (this.expectBlockDependency) {
            if (this.blockDependencyBuffer == null) {
                this.blockDependencyBuffer = new byte[65536];
            }
        } else {
            this.blockDependencyBuffer = null;
        }
        this.expectBlockChecksum = (flags & 0x10) != 0;
        boolean expectContentSize = (flags & 8) != 0;
        this.expectContentChecksum = (flags & 4) != 0;
        int bdByte = this.readOneByte();
        if (bdByte == -1) {
            throw new CompressorException("Premature end of stream while reading frame BD byte");
        }
        this.contentHash.update(bdByte);
        if (expectContentSize) {
            byte[] contentSize = new byte[8];
            int skipped = IOUtils.readFully((InputStream)this.inputStream, contentSize);
            this.count(skipped);
            if (8 != skipped) {
                throw new CompressorException("Premature end of stream while reading content size");
            }
            this.contentHash.update(contentSize, 0, contentSize.length);
        }
        if ((headerHash = this.readOneByte()) == -1) {
            throw new CompressorException("Premature end of stream while reading frame header checksum");
        }
        int expectedHash = (int)(this.contentHash.getValue() >> 8 & 0xFFL);
        this.contentHash.reset();
        if (headerHash != expectedHash) {
            throw new CompressorException("Frame header checksum mismatch");
        }
    }

    private int readOnce(byte[] b, int off, int len) throws IOException {
        if (this.inUncompressed) {
            int cnt = this.currentBlock.read(b, off, len);
            this.count(cnt);
            return cnt;
        }
        BlockLZ4CompressorInputStream l = (BlockLZ4CompressorInputStream)this.currentBlock;
        long before = l.getBytesRead();
        int cnt = this.currentBlock.read(b, off, len);
        this.count(l.getBytesRead() - before);
        return cnt;
    }

    private int readOneByte() throws IOException {
        int b = this.inputStream.read();
        if (b != -1) {
            this.count(1);
            return b & 0xFF;
        }
        return -1;
    }

    private boolean readSignature(boolean firstFrame) throws IOException {
        String garbageMessage = firstFrame ? "Not a LZ4 frame stream" : "LZ4 frame stream followed by garbage";
        byte[] b = new byte[4];
        int read = IOUtils.readFully((InputStream)this.inputStream, b);
        this.count(read);
        if (0 == read && !firstFrame) {
            this.endReached = true;
            return false;
        }
        if (4 != read) {
            throw new CompressorException(garbageMessage);
        }
        read = this.skipSkippableFrame(b);
        if (0 == read && !firstFrame) {
            this.endReached = true;
            return false;
        }
        if (4 != read || !FramedLZ4CompressorInputStream.matches(b, 4)) {
            throw new CompressorException(garbageMessage);
        }
        return true;
    }

    private int skipSkippableFrame(byte[] b) throws IOException {
        int read = 4;
        while (read == 4 && FramedLZ4CompressorInputStream.isSkippableFrameSignature(b)) {
            long len = ByteUtils.fromLittleEndian(this.supplier, 4);
            if (len < 0L) {
                throw new CompressorException("Found illegal skippable frame with negative size");
            }
            long skipped = org.apache.commons.io.IOUtils.skip((InputStream)this.inputStream, (long)len);
            this.count(skipped);
            if (len != skipped) {
                throw new CompressorException("Premature end of stream while skipping frame");
            }
            read = IOUtils.readFully((InputStream)this.inputStream, b);
            this.count(read);
        }
        return read;
    }

    private void verifyChecksum(XXHash32 hash, String kind) throws IOException {
        byte[] checksum = new byte[4];
        int read = IOUtils.readFully((InputStream)this.inputStream, checksum);
        this.count(read);
        if (4 != read) {
            throw new CompressorException("Premature end of stream while reading %s checksum", kind);
        }
        long expectedHash = hash.getValue();
        if (expectedHash != ByteUtils.fromLittleEndian(checksum)) {
            throw new CompressorException("%s checksum mismatch.", kind);
        }
    }

    private void verifyContentChecksum() throws IOException {
        if (this.expectContentChecksum) {
            this.verifyChecksum(this.contentHash, "content");
        }
        this.contentHash.reset();
    }
}

