/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.gzip;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.compress.compressors.FileNameUtil;

public class GzipUtils {
    private static final FileNameUtil FNU_INSTANCE = new FileNameUtil(GzipUtils.uncompressSuffix(), ".gz");
    static final Charset GZIP_ENCODING = StandardCharsets.ISO_8859_1;
    static final int ID1 = 31;
    static final int ID2 = 139;

    @Deprecated
    public static String getCompressedFilename(String fileName) {
        return FNU_INSTANCE.getCompressedFileName(fileName);
    }

    public static String getCompressedFileName(String fileName) {
        return FNU_INSTANCE.getCompressedFileName(fileName);
    }

    @Deprecated
    public static String getUncompressedFilename(String fileName) {
        return FNU_INSTANCE.getUncompressedFileName(fileName);
    }

    public static String getUncompressedFileName(String fileName) {
        return FNU_INSTANCE.getUncompressedFileName(fileName);
    }

    @Deprecated
    public static boolean isCompressedFilename(String fileName) {
        return FNU_INSTANCE.isCompressedFileName(fileName);
    }

    public static boolean isCompressedFileName(String fileName) {
        return FNU_INSTANCE.isCompressedFileName(fileName);
    }

    private static Map<String, String> uncompressSuffix() {
        LinkedHashMap<String, String> uncompressSuffix = new LinkedHashMap<String, String>();
        uncompressSuffix.put(".tgz", ".tar");
        uncompressSuffix.put(".taz", ".tar");
        uncompressSuffix.put(".svgz", ".svg");
        uncompressSuffix.put(".cpgz", ".cpio");
        uncompressSuffix.put(".wmz", ".wmf");
        uncompressSuffix.put(".emz", ".emf");
        uncompressSuffix.put(".gz", "");
        uncompressSuffix.put(".z", "");
        uncompressSuffix.put("-gz", "");
        uncompressSuffix.put("-z", "");
        uncompressSuffix.put("_z", "");
        return uncompressSuffix;
    }

    private GzipUtils() {
    }
}

