/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.tar;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveSparseEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveSparseZeroInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveStructSparse;
import org.apache.commons.compress.archivers.tar.TarUtils;
import org.apache.commons.compress.archivers.zip.ZipEncoding;
import org.apache.commons.compress.archivers.zip.ZipEncodingHelper;
import org.apache.commons.compress.utils.ArchiveUtils;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.build.AbstractStreamBuilder;
import org.apache.commons.io.input.BoundedInputStream;

public class TarArchiveInputStream
extends ArchiveInputStream<TarArchiveEntry> {
    private static final String VERSION_AIX = "0 ";
    private static final int SMALL_BUFFER_SIZE = 256;
    private final byte[] smallBuf = new byte[256];
    private final byte[] recordBuffer;
    private final int blockSize;
    private boolean atEof;
    private long entrySize;
    private long entryOffset;
    private List<InputStream> sparseInputStreams;
    private int currentSparseInputStreamIndex;
    private TarArchiveEntry currEntry;
    private final ZipEncoding zipEncoding;
    private final Map<String, String> globalPaxHeaders = new HashMap<String, String>();
    private final List<TarArchiveStructSparse> globalSparseHeaders = new ArrayList<TarArchiveStructSparse>();
    private final boolean lenient;

    public static Builder builder() {
        return new Builder();
    }

    public static boolean matches(byte[] signature, int length) {
        int versionOffset = 263;
        int versionLen = 2;
        if (length < 265) {
            return false;
        }
        int magicOffset = 257;
        int magicLen = 6;
        if (ArchiveUtils.matchAsciiBuffer("ustar\u0000", signature, 257, 6) && ArchiveUtils.matchAsciiBuffer("00", signature, 263, 2)) {
            return true;
        }
        if (ArchiveUtils.matchAsciiBuffer("ustar\u0000", signature, 257, 6) && ArchiveUtils.matchAsciiBuffer(VERSION_AIX, signature, 263, 2)) {
            return true;
        }
        if (ArchiveUtils.matchAsciiBuffer("ustar ", signature, 257, 6) && (ArchiveUtils.matchAsciiBuffer(" \u0000", signature, 263, 2) || ArchiveUtils.matchAsciiBuffer("0\u0000", signature, 263, 2))) {
            return true;
        }
        return ArchiveUtils.matchAsciiBuffer("ustar\u0000", signature, 257, 6) && ArchiveUtils.matchAsciiBuffer("\u0000\u0000", signature, 263, 2);
    }

    private TarArchiveInputStream(Builder builder) throws IOException {
        super(builder.getInputStream(), builder.getCharset());
        this.zipEncoding = ZipEncodingHelper.getZipEncoding(builder.getCharset());
        this.recordBuffer = new byte[builder.recordSize];
        this.blockSize = builder.blockSize;
        this.lenient = builder.lenient;
    }

    public TarArchiveInputStream(InputStream inputStream) {
        this(inputStream, 10240, 512);
    }

    @Deprecated
    public TarArchiveInputStream(InputStream inputStream, boolean lenient) {
        this(inputStream, 10240, 512, null, lenient);
    }

    @Deprecated
    public TarArchiveInputStream(InputStream inputStream, int blockSize) {
        this(inputStream, blockSize, 512);
    }

    @Deprecated
    public TarArchiveInputStream(InputStream inputStream, int blockSize, int recordSize) {
        this(inputStream, blockSize, recordSize, null);
    }

    @Deprecated
    public TarArchiveInputStream(InputStream inputStream, int blockSize, int recordSize, String encoding) {
        this(inputStream, blockSize, recordSize, encoding, false);
    }

    @Deprecated
    public TarArchiveInputStream(InputStream inputStream, int blockSize, int recordSize, String encoding, boolean lenient) {
        super(inputStream, encoding);
        this.zipEncoding = ZipEncodingHelper.getZipEncoding(encoding);
        this.recordBuffer = new byte[recordSize];
        this.blockSize = blockSize;
        this.lenient = lenient;
    }

    @Deprecated
    public TarArchiveInputStream(InputStream inputStream, int blockSize, String encoding) {
        this(inputStream, blockSize, 512, encoding);
    }

    @Deprecated
    public TarArchiveInputStream(InputStream inputStream, String encoding) {
        this(inputStream, 10240, 512, encoding);
    }

    @Override
    public int available() throws IOException {
        if (this.isDirectory()) {
            return 0;
        }
        long available = this.currEntry.getRealSize() - this.entryOffset;
        if (available > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)available;
    }

    private void buildSparseInputStreams() throws IOException {
        this.currentSparseInputStreamIndex = -1;
        this.sparseInputStreams = new ArrayList<InputStream>();
        List<TarArchiveStructSparse> sparseHeaders = this.currEntry.getOrderedSparseHeaders();
        TarArchiveSparseZeroInputStream zeroInputStream = new TarArchiveSparseZeroInputStream();
        long offset = 0L;
        for (TarArchiveStructSparse sparseHeader : sparseHeaders) {
            long zeroBlockSize = sparseHeader.getOffset() - offset;
            if (zeroBlockSize < 0L) {
                throw new ArchiveException("Corrupted struct sparse detected");
            }
            if (zeroBlockSize > 0L) {
                this.sparseInputStreams.add((InputStream)((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)zeroInputStream)).setMaxCount(sparseHeader.getOffset() - offset)).get());
            }
            if (sparseHeader.getNumbytes() > 0L) {
                this.sparseInputStreams.add((InputStream)((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream(this.in)).setMaxCount(sparseHeader.getNumbytes())).get());
            }
            offset = sparseHeader.getOffset() + sparseHeader.getNumbytes();
        }
        if (!this.sparseInputStreams.isEmpty()) {
            this.currentSparseInputStreamIndex = 0;
        }
    }

    @Override
    public boolean canReadEntryData(ArchiveEntry archiveEntry) {
        return archiveEntry instanceof TarArchiveEntry;
    }

    @Override
    public void close() throws IOException {
        if (this.sparseInputStreams != null) {
            for (InputStream inputStream : this.sparseInputStreams) {
                inputStream.close();
            }
        }
        this.in.close();
    }

    private void consumeRemainderOfLastBlock() throws IOException {
        long bytesReadOfLastBlock = this.getBytesRead() % (long)this.blockSize;
        if (bytesReadOfLastBlock > 0L) {
            this.count(IOUtils.skip(this.in, (long)this.blockSize - bytesReadOfLastBlock));
        }
    }

    private long getActuallySkipped(long available, long skipped, long expected) throws IOException {
        long actuallySkipped = skipped;
        if (this.in instanceof FileInputStream) {
            actuallySkipped = Math.min(skipped, available);
        }
        if (actuallySkipped != expected) {
            throw new ArchiveException("Truncated TAR archive");
        }
        return actuallySkipped;
    }

    public TarArchiveEntry getCurrentEntry() {
        return this.currEntry;
    }

    @Deprecated
    protected byte[] getLongNameData() throws IOException {
        ByteArrayOutputStream longName = new ByteArrayOutputStream();
        int length = 0;
        while ((length = this.read(this.smallBuf)) >= 0) {
            longName.write(this.smallBuf, 0, length);
        }
        this.getNextEntry();
        if (this.currEntry == null) {
            return null;
        }
        byte[] longNameData = longName.toByteArray();
        for (length = longNameData.length; length > 0 && longNameData[length - 1] == 0; --length) {
        }
        if (length != longNameData.length) {
            longNameData = Arrays.copyOf(longNameData, length);
        }
        return longNameData;
    }

    @Override
    public TarArchiveEntry getNextEntry() throws IOException {
        if (this.isAtEOF()) {
            return null;
        }
        HashMap<String, String> paxHeaders = new HashMap<String, String>();
        ArrayList<TarArchiveStructSparse> sparseHeaders = new ArrayList<TarArchiveStructSparse>();
        boolean lastWasSpecial = false;
        do {
            byte[] headerBuf;
            if (this.currEntry != null) {
                IOUtils.skip(this, Long.MAX_VALUE);
                this.skipRecordPadding();
            }
            if ((headerBuf = this.getRecord()) == null) {
                if (lastWasSpecial) {
                    throw new ArchiveException("Premature end of tar archive. Didn't find any file entry after GNU or PAX record.");
                }
                this.currEntry = null;
                return null;
            }
            this.currEntry = new TarArchiveEntry(this.globalPaxHeaders, headerBuf, this.zipEncoding, this.lenient);
            this.entryOffset = 0L;
            this.entrySize = this.currEntry.getSize();
            lastWasSpecial = TarUtils.isSpecialTarRecord(this.currEntry);
            if (!lastWasSpecial) continue;
            TarUtils.handleSpecialTarRecord(this, this.zipEncoding, this.currEntry, paxHeaders, sparseHeaders, this.globalPaxHeaders, this.globalSparseHeaders);
        } while (lastWasSpecial);
        TarUtils.applyPaxHeadersToEntry(this.currEntry, paxHeaders, sparseHeaders, this.globalPaxHeaders, this.globalSparseHeaders);
        if (this.currEntry.isSparse()) {
            if (this.currEntry.isOldGNUSparse()) {
                this.readOldGNUSparse();
            } else if (this.currEntry.isPaxGNU1XSparse()) {
                this.currEntry.setSparseHeaders(TarUtils.parsePAX1XSparseHeaders(this.in, this.getRecordSize()));
            }
            this.buildSparseInputStreams();
        }
        if (this.currEntry.isDirectory() && !this.currEntry.getName().endsWith("/")) {
            this.currEntry.setName(this.currEntry.getName() + "/");
        }
        this.entrySize = this.currEntry.getSize();
        return this.currEntry;
    }

    @Deprecated
    public TarArchiveEntry getNextTarEntry() throws IOException {
        return this.getNextEntry();
    }

    private byte[] getRecord() throws IOException {
        byte[] headerBuf = this.readRecord();
        this.setAtEOF(this.isEOFRecord(headerBuf));
        if (this.isAtEOF() && headerBuf != null) {
            this.tryToConsumeSecondEOFRecord();
            this.consumeRemainderOfLastBlock();
            headerBuf = null;
        }
        return headerBuf;
    }

    public int getRecordSize() {
        return this.recordBuffer.length;
    }

    protected final boolean isAtEOF() {
        return this.atEof;
    }

    private boolean isDirectory() {
        return this.currEntry != null && this.currEntry.isDirectory();
    }

    protected boolean isEOFRecord(byte[] record) {
        return record == null || ArchiveUtils.isArrayZero(record, this.getRecordSize());
    }

    @Override
    public synchronized void mark(int markLimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read(byte[] buf, int offset, int numToRead) throws IOException {
        if (numToRead == 0) {
            return 0;
        }
        int totalRead = 0;
        if (this.isAtEOF() || this.isDirectory()) {
            return -1;
        }
        if (this.currEntry == null) {
            throw new IllegalStateException("No current tar entry");
        }
        if (this.entryOffset >= this.currEntry.getRealSize()) {
            return -1;
        }
        numToRead = Math.min(numToRead, this.available());
        totalRead = this.currEntry.isSparse() ? this.readSparse(buf, offset, numToRead) : this.in.read(buf, offset, numToRead);
        if (totalRead == -1) {
            if (numToRead > 0) {
                throw new ArchiveException("Truncated TAR archive");
            }
            this.setAtEOF(true);
        } else {
            this.count(totalRead);
            this.entryOffset += (long)totalRead;
        }
        return totalRead;
    }

    private void readOldGNUSparse() throws IOException {
        if (this.currEntry.isExtended()) {
            TarArchiveSparseEntry entry;
            do {
                byte[] headerBuf;
                if ((headerBuf = this.getRecord()) == null) {
                    throw new ArchiveException("Premature end of tar archive. Didn't find extended_header after header with extended flag.");
                }
                entry = new TarArchiveSparseEntry(headerBuf);
                this.currEntry.getSparseHeaders().addAll(entry.getSparseHeaders());
            } while (entry.isExtended());
        }
        this.buildSparseInputStreams();
    }

    protected byte[] readRecord() throws IOException {
        int readCount = IOUtils.readFully(this.in, this.recordBuffer);
        this.count(readCount);
        if (readCount != this.getRecordSize()) {
            return null;
        }
        return this.recordBuffer;
    }

    private int readSparse(byte[] buf, int offset, int numToRead) throws IOException {
        if (this.sparseInputStreams == null || this.sparseInputStreams.isEmpty()) {
            return this.in.read(buf, offset, numToRead);
        }
        if (this.currentSparseInputStreamIndex >= this.sparseInputStreams.size()) {
            return -1;
        }
        InputStream currentInputStream = this.sparseInputStreams.get(this.currentSparseInputStreamIndex);
        int readLen = currentInputStream.read(buf, offset, numToRead);
        if (this.currentSparseInputStreamIndex == this.sparseInputStreams.size() - 1) {
            return readLen;
        }
        if (readLen == -1) {
            ++this.currentSparseInputStreamIndex;
            return this.readSparse(buf, offset, numToRead);
        }
        if (readLen < numToRead) {
            ++this.currentSparseInputStreamIndex;
            int readLenOfNext = this.readSparse(buf, offset + readLen, numToRead - readLen);
            if (readLenOfNext == -1) {
                return readLen;
            }
            return readLen + readLenOfNext;
        }
        return readLen;
    }

    @Override
    public synchronized void reset() {
    }

    protected final void setAtEOF(boolean atEof) {
        this.atEof = atEof;
    }

    protected final void setCurrentEntry(TarArchiveEntry currEntry) {
        this.currEntry = currEntry;
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped;
        if (n <= 0L || this.isDirectory()) {
            return 0L;
        }
        long availableOfInputStream = this.in.available();
        long available = this.currEntry.getRealSize() - this.entryOffset;
        long numToSkip = Math.min(n, available);
        if (!this.currEntry.isSparse()) {
            skipped = IOUtils.skip(this.in, numToSkip);
            skipped = this.getActuallySkipped(availableOfInputStream, skipped, numToSkip);
        } else {
            skipped = this.skipSparse(numToSkip);
        }
        this.count(skipped);
        this.entryOffset += skipped;
        return skipped;
    }

    private void skipRecordPadding() throws IOException {
        if (!this.isDirectory() && this.entrySize > 0L && this.entrySize % (long)this.getRecordSize() != 0L) {
            long available = this.in.available();
            long numRecords = this.entrySize / (long)this.getRecordSize() + 1L;
            long padding = numRecords * (long)this.getRecordSize() - this.entrySize;
            long skipped = IOUtils.skip(this.in, padding);
            skipped = this.getActuallySkipped(available, skipped, padding);
            this.count(skipped);
        }
    }

    private long skipSparse(long n) throws IOException {
        if (this.sparseInputStreams == null || this.sparseInputStreams.isEmpty()) {
            return this.in.skip(n);
        }
        long bytesSkipped = 0L;
        while (bytesSkipped < n && this.currentSparseInputStreamIndex < this.sparseInputStreams.size()) {
            InputStream currentInputStream = this.sparseInputStreams.get(this.currentSparseInputStreamIndex);
            if ((bytesSkipped += currentInputStream.skip(n - bytesSkipped)) >= n) continue;
            ++this.currentSparseInputStreamIndex;
        }
        return bytesSkipped;
    }

    private void tryToConsumeSecondEOFRecord() throws IOException {
        boolean shouldReset = true;
        boolean marked = this.in.markSupported();
        if (marked) {
            this.in.mark(this.getRecordSize());
        }
        try {
            shouldReset = !this.isEOFRecord(this.readRecord());
        }
        finally {
            if (shouldReset && marked) {
                this.pushedBackBytes(this.getRecordSize());
                this.in.reset();
            }
        }
    }

    public static class Builder
    extends AbstractStreamBuilder<TarArchiveInputStream, Builder> {
        private int blockSize = 10240;
        private int recordSize = 512;
        private boolean lenient;

        public TarArchiveInputStream get() throws IOException {
            return new TarArchiveInputStream(this);
        }

        public Builder setBlockSize(int blockSize) {
            this.blockSize = blockSize;
            return this;
        }

        public Builder setLenient(boolean lenient) {
            this.lenient = lenient;
            return this;
        }

        public Builder setRecordSize(int recordSize) {
            this.recordSize = recordSize;
            return this;
        }
    }
}

