/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.sevenz;

import java.util.BitSet;
import org.apache.commons.compress.MemoryLimitException;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;

final class SubStreamsInfo {
    final long[] unpackSizes;
    final BitSet hasCrc;
    final long[] crcs;

    SubStreamsInfo(long totalUnpackStreams, int maxMemoryLimitKiB) throws MemoryLimitException {
        int intExactCount = Math.toIntExact(totalUnpackStreams);
        MemoryLimitException.checkKiB(SevenZFile.kbToKiB(Math.multiplyExact((long)intExactCount, 3L)), maxMemoryLimitKiB);
        this.unpackSizes = new long[intExactCount];
        this.hasCrc = new BitSet(intExactCount);
        this.crcs = new long[intExactCount];
    }
}

