/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.sevenz;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;
import org.apache.commons.compress.MemoryLimitException;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.sevenz.AES256SHA256Decoder;
import org.apache.commons.compress.archivers.sevenz.Archive;
import org.apache.commons.compress.archivers.sevenz.BindPair;
import org.apache.commons.compress.archivers.sevenz.BoundedSeekableByteChannelInputStream;
import org.apache.commons.compress.archivers.sevenz.Coder;
import org.apache.commons.compress.archivers.sevenz.Coders;
import org.apache.commons.compress.archivers.sevenz.Folder;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFileOptions;
import org.apache.commons.compress.archivers.sevenz.SevenZMethod;
import org.apache.commons.compress.archivers.sevenz.SevenZMethodConfiguration;
import org.apache.commons.compress.archivers.sevenz.StartHeader;
import org.apache.commons.compress.archivers.sevenz.StreamMap;
import org.apache.commons.compress.archivers.sevenz.SubStreamsInfo;
import org.apache.commons.compress.utils.ByteUtils;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.compress.utils.InputStreamStatistics;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;
import org.apache.commons.io.build.AbstractOrigin;
import org.apache.commons.io.build.AbstractStreamBuilder;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.commons.io.input.ChecksumInputStream;
import org.apache.commons.lang3.ArrayUtils;

public class SevenZFile
implements Closeable {
    static final int SIGNATURE_HEADER_SIZE = 32;
    private static final String DEFAULT_FILE_NAME = "unknown archive";
    static final byte[] SIGNATURE = new byte[]{55, 122, -68, -81, 39, 28};
    public static int SOFT_MAX_ARRAY_LENGTH = 0x7FFFFFF7;
    private final String fileName;
    private SeekableByteChannel channel;
    private final Archive archive;
    private int currentEntryIndex = -1;
    private int currentFolderIndex = -1;
    private InputStream currentFolderInputStream;
    private byte[] password;
    private long compressedBytesReadFromCurrentEntry;
    private long uncompressedBytesReadFromCurrentEntry;
    private final ArrayList<InputStream> deferredBlockStreams = new ArrayList();
    private final int maxMemoryLimitKiB;
    private final boolean useDefaultNameForUnnamedEntries;
    private final boolean tryToRecoverBrokenArchives;

    public static Builder builder() {
        return new Builder();
    }

    private static long bytesToKiB(long bytes) {
        return bytes / 1024L;
    }

    private static ByteBuffer checkEndOfFile(ByteBuffer buf, int expectRemaining) throws EOFException {
        int remaining = buf.remaining();
        if (remaining < expectRemaining) {
            throw new EOFException(String.format("remaining %,d < expectRemaining %,d", remaining, expectRemaining));
        }
        return buf;
    }

    private static void get(ByteBuffer buf, byte[] to) throws EOFException {
        SevenZFile.checkEndOfFile(buf, to.length).get(to);
    }

    private static char getChar(ByteBuffer buf) throws EOFException {
        return SevenZFile.checkEndOfFile(buf, 2).getChar();
    }

    private static int getInt(ByteBuffer buf) throws EOFException {
        return SevenZFile.checkEndOfFile(buf, 4).getInt();
    }

    private static long getLong(ByteBuffer buf) throws EOFException {
        return SevenZFile.checkEndOfFile(buf, 8).getLong();
    }

    private static int getUnsignedByte(ByteBuffer buf) throws EOFException {
        if (!buf.hasRemaining()) {
            throw new EOFException();
        }
        return buf.get() & 0xFF;
    }

    private static int kbToKiB(int kilobytes) {
        return kilobytes * 1000 / 1024;
    }

    static long kbToKiB(long kilobytes) {
        return kilobytes * 1000L / 1024L;
    }

    public static boolean matches(byte[] buffer, int ignored) {
        return ArrayUtils.startsWith((byte[])buffer, (byte[])SIGNATURE);
    }

    private static SeekableByteChannel newByteChannel(File file) throws IOException {
        return Files.newByteChannel(file.toPath(), EnumSet.of(StandardOpenOption.READ), new FileAttribute[0]);
    }

    private static long readUint64(ByteBuffer in) throws IOException {
        long firstByte = SevenZFile.getUnsignedByte(in);
        int mask = 128;
        long value = 0L;
        for (int i = 0; i < 8; ++i) {
            if ((firstByte & (long)mask) == 0L) {
                return value | (firstByte & (long)(mask - 1)) << 8 * i;
            }
            long nextByte = SevenZFile.getUnsignedByte(in);
            value |= nextByte << 8 * i;
            mask >>>= 1;
        }
        return value;
    }

    private static int readUint64ToIntExact(ByteBuffer in) throws IOException {
        return ArchiveException.toIntExact(SevenZFile.readUint64(in));
    }

    private static long skipBytesFully(ByteBuffer input, long bytesToSkip) {
        if (bytesToSkip < 1L) {
            return 0L;
        }
        int current = input.position();
        int maxSkip = input.remaining();
        if ((long)maxSkip < bytesToSkip) {
            bytesToSkip = maxSkip;
        }
        input.position(current + (int)bytesToSkip);
        return bytesToSkip;
    }

    public static int toNonNegativeInt(String description, long value) throws IOException {
        if (value > Integer.MAX_VALUE || value < 0L) {
            throw new ArchiveException("Cannot handle %s %,d", description, value);
        }
        return (int)value;
    }

    @Deprecated
    public SevenZFile(File fileName) throws IOException {
        this(fileName, SevenZFileOptions.DEFAULT);
    }

    @Deprecated
    public SevenZFile(File file, byte[] password) throws IOException {
        this(SevenZFile.newByteChannel(file), file.getAbsolutePath(), password, true, SevenZFileOptions.DEFAULT);
    }

    @Deprecated
    public SevenZFile(File file, char[] password) throws IOException {
        this(file, password, SevenZFileOptions.DEFAULT);
    }

    @Deprecated
    public SevenZFile(File file, char[] password, SevenZFileOptions options) throws IOException {
        this(SevenZFile.newByteChannel(file), file.getAbsolutePath(), AES256SHA256Decoder.utf16Decode(password), true, options);
    }

    @Deprecated
    public SevenZFile(File file, SevenZFileOptions options) throws IOException {
        this(file, null, options);
    }

    @Deprecated
    public SevenZFile(SeekableByteChannel channel) throws IOException {
        this(channel, SevenZFileOptions.DEFAULT);
    }

    @Deprecated
    public SevenZFile(SeekableByteChannel channel, byte[] password) throws IOException {
        this(channel, DEFAULT_FILE_NAME, password);
    }

    @Deprecated
    public SevenZFile(SeekableByteChannel channel, char[] password) throws IOException {
        this(channel, password, SevenZFileOptions.DEFAULT);
    }

    @Deprecated
    public SevenZFile(SeekableByteChannel channel, char[] password, SevenZFileOptions options) throws IOException {
        this(channel, DEFAULT_FILE_NAME, password, options);
    }

    @Deprecated
    public SevenZFile(SeekableByteChannel channel, SevenZFileOptions options) throws IOException {
        this(channel, DEFAULT_FILE_NAME, null, options);
    }

    @Deprecated
    public SevenZFile(SeekableByteChannel channel, String fileName) throws IOException {
        this(channel, fileName, SevenZFileOptions.DEFAULT);
    }

    @Deprecated
    public SevenZFile(SeekableByteChannel channel, String fileName, byte[] password) throws IOException {
        this(channel, fileName, password, false, SevenZFileOptions.DEFAULT);
    }

    private SevenZFile(SeekableByteChannel channel, String fileName, byte[] password, boolean closeOnError, int maxMemoryLimitKiB, boolean useDefaultNameForUnnamedEntries, boolean tryToRecoverBrokenArchives) throws IOException {
        boolean succeeded = false;
        this.channel = channel;
        this.fileName = fileName;
        this.maxMemoryLimitKiB = maxMemoryLimitKiB;
        this.useDefaultNameForUnnamedEntries = useDefaultNameForUnnamedEntries;
        this.tryToRecoverBrokenArchives = tryToRecoverBrokenArchives;
        try {
            this.archive = this.readHeaders(password);
            this.password = (byte[])(password != null ? Arrays.copyOf(password, password.length) : null);
            succeeded = true;
        }
        catch (ArithmeticException | IllegalArgumentException e) {
            throw new ArchiveException(e);
        }
        finally {
            if (!succeeded && closeOnError) {
                this.channel.close();
            }
        }
    }

    @Deprecated
    private SevenZFile(SeekableByteChannel channel, String fileName, byte[] password, boolean closeOnError, SevenZFileOptions options) throws IOException {
        this(channel, fileName, password, closeOnError, options.getMaxMemoryLimitInKb(), options.getUseDefaultNameForUnnamedEntries(), options.getTryToRecoverBrokenArchives());
    }

    @Deprecated
    public SevenZFile(SeekableByteChannel channel, String fileName, char[] password) throws IOException {
        this(channel, fileName, password, SevenZFileOptions.DEFAULT);
    }

    @Deprecated
    public SevenZFile(SeekableByteChannel channel, String fileName, char[] password, SevenZFileOptions options) throws IOException {
        this(channel, fileName, AES256SHA256Decoder.utf16Decode(password), false, options);
    }

    @Deprecated
    public SevenZFile(SeekableByteChannel channel, String fileName, SevenZFileOptions options) throws IOException {
        this(channel, fileName, null, false, options);
    }

    private InputStream buildDecoderStack(Folder folder, long folderOffset, int firstPackStreamIndex, SevenZArchiveEntry entry) throws IOException {
        this.channel.position(folderOffset);
        InputStream inputStreamStack = new FilterInputStream(new BufferedInputStream(new BoundedSeekableByteChannelInputStream(this.channel, this.archive.packSizes[firstPackStreamIndex]))){

            private void count(int c) throws ArchiveException {
                SevenZFile.this.compressedBytesReadFromCurrentEntry = ArchiveException.addExact(SevenZFile.this.compressedBytesReadFromCurrentEntry, (long)c);
            }

            @Override
            public int read() throws IOException {
                int r = this.in.read();
                if (r >= 0) {
                    this.count(1);
                }
                return r;
            }

            @Override
            public int read(byte[] b) throws IOException {
                return this.read(b, 0, b.length);
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                if (len == 0) {
                    return 0;
                }
                int r = this.in.read(b, off, len);
                if (r >= 0) {
                    this.count(r);
                }
                return r;
            }
        };
        LinkedList<SevenZMethodConfiguration> methods = new LinkedList<SevenZMethodConfiguration>();
        for (Coder coder : folder.getOrderedCoders()) {
            if (coder.numInStreams != 1L || coder.numOutStreams != 1L) {
                throw new ArchiveException("Multi input/output stream coders are not yet supported");
            }
            SevenZMethod method = SevenZMethod.byId(coder.decompressionMethodId);
            inputStreamStack = Coders.addDecoder(this.fileName, inputStreamStack, folder.getUnpackSizeForCoder(coder), coder, this.password, this.maxMemoryLimitKiB);
            methods.addFirst(new SevenZMethodConfiguration(method, Coders.findByMethod(method).getOptionsFromCoder(coder, inputStreamStack)));
        }
        entry.setContentMethods(methods);
        if (folder.hasCrc) {
            return ((ChecksumInputStream.Builder)ChecksumInputStream.builder().setChecksum((Checksum)new CRC32()).setInputStream(inputStreamStack)).setCountThreshold(folder.getUnpackSize()).setExpectedChecksumValue(folder.crc).get();
        }
        return inputStreamStack;
    }

    private void buildDecodingStream(int entryIndex, boolean isRandomAccess) throws IOException {
        if (this.archive.streamMap == null) {
            throw new ArchiveException("Archive doesn't contain stream information to read entries");
        }
        int folderIndex = this.archive.streamMap.fileFolderIndex[entryIndex];
        if (folderIndex < 0) {
            this.deferredBlockStreams.clear();
            return;
        }
        SevenZArchiveEntry file = this.archive.files[entryIndex];
        boolean isInSameFolder = false;
        if (this.currentFolderIndex == folderIndex) {
            if (entryIndex > 0) {
                file.setContentMethods(this.archive.files[entryIndex - 1].getContentMethods());
            }
            if (isRandomAccess && file.getContentMethods() == null) {
                int folderFirstFileIndex = this.archive.streamMap.folderFirstFileIndex[folderIndex];
                SevenZArchiveEntry folderFirstFile = this.archive.files[folderFirstFileIndex];
                file.setContentMethods(folderFirstFile.getContentMethods());
            }
            isInSameFolder = true;
        } else {
            this.currentFolderIndex = folderIndex;
            this.reopenFolderInputStream(folderIndex, file);
        }
        boolean haveSkippedEntries = false;
        if (isRandomAccess) {
            haveSkippedEntries = this.skipEntriesWhenNeeded(entryIndex, isInSameFolder, folderIndex);
        }
        if (isRandomAccess && this.currentEntryIndex == entryIndex && !haveSkippedEntries) {
            return;
        }
        BoundedInputStream fileStream = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream(this.currentFolderInputStream)).setMaxCount(file.getSize())).setPropagateClose(false)).get();
        if (file.getHasCrc()) {
            fileStream = ((ChecksumInputStream.Builder)ChecksumInputStream.builder().setChecksum((Checksum)new CRC32()).setInputStream((InputStream)fileStream)).setExpectedChecksumValue(file.getCrcValue()).setCountThreshold(file.getSize()).get();
        }
        this.deferredBlockStreams.add((InputStream)fileStream);
    }

    private void calculateStreamMap(Archive archive) throws IOException {
        int nextFolderPackStreamIndex = 0;
        int numFolders = ArrayUtils.getLength((Object)archive.folders);
        int[] folderFirstPackStreamIndex = new int[this.checkIntArray(numFolders)];
        for (int i = 0; i < numFolders; ++i) {
            folderFirstPackStreamIndex[i] = nextFolderPackStreamIndex;
            nextFolderPackStreamIndex = ArchiveException.addExact(nextFolderPackStreamIndex, archive.folders[i].packedStreams.length);
        }
        long nextPackStreamOffset = 0L;
        int numPackSizes = archive.packSizes.length;
        long[] packStreamOffsets = new long[this.checkLongArray(numPackSizes)];
        for (int i = 0; i < numPackSizes; ++i) {
            packStreamOffsets[i] = nextPackStreamOffset;
            nextPackStreamOffset = ArchiveException.addExact(nextPackStreamOffset, archive.packSizes[i]);
        }
        int[] folderFirstFileIndex = new int[this.checkIntArray(numFolders)];
        int[] fileFolderIndex = new int[this.checkIntArray(archive.files.length)];
        int nextFolderIndex = 0;
        int nextFolderUnpackStreamIndex = 0;
        for (int i = 0; i < archive.files.length; ++i) {
            if (archive.files[i].isEmptyStream() && nextFolderUnpackStreamIndex == 0) {
                fileFolderIndex[i] = -1;
                continue;
            }
            if (nextFolderUnpackStreamIndex == 0) {
                while (nextFolderIndex < archive.folders.length) {
                    folderFirstFileIndex[nextFolderIndex] = i;
                    if (archive.folders[nextFolderIndex].numUnpackSubStreams > 0) break;
                    ++nextFolderIndex;
                }
                if (nextFolderIndex >= archive.folders.length) {
                    throw new ArchiveException("Too few folders in archive");
                }
            }
            fileFolderIndex[i] = nextFolderIndex;
            if (archive.files[i].isEmptyStream() || ++nextFolderUnpackStreamIndex < archive.folders[nextFolderIndex].numUnpackSubStreams) continue;
            ++nextFolderIndex;
            nextFolderUnpackStreamIndex = 0;
        }
        archive.streamMap = new StreamMap(folderFirstPackStreamIndex, packStreamOffsets, folderFirstFileIndex, fileFolderIndex);
    }

    int checkByteArray(int size) throws MemoryLimitException {
        MemoryLimitException.checkKiB(SevenZFile.bytesToKiB(size * 1), this.maxMemoryLimitKiB);
        return size;
    }

    int checkIntArray(int size) throws MemoryLimitException {
        MemoryLimitException.checkKiB(SevenZFile.bytesToKiB(size * 4), this.maxMemoryLimitKiB);
        return size;
    }

    int checkLongArray(int size) throws MemoryLimitException {
        MemoryLimitException.checkKiB(SevenZFile.bytesToKiB(size * 8), this.maxMemoryLimitKiB);
        return size;
    }

    int checkObjectArray(int size) throws MemoryLimitException {
        MemoryLimitException.checkKiB(SevenZFile.bytesToKiB(size * 4), this.maxMemoryLimitKiB);
        return size;
    }

    @Override
    public void close() throws IOException {
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            finally {
                this.channel = null;
                if (this.password != null) {
                    Arrays.fill(this.password, (byte)0);
                }
                this.password = null;
            }
        }
    }

    private void computeIfAbsent(Map<Integer, SevenZArchiveEntry> archiveEntries, int index) {
        archiveEntries.computeIfAbsent(index, i -> new SevenZArchiveEntry());
    }

    private InputStream getCurrentStream() throws IOException {
        if (this.archive.files[this.currentEntryIndex].getSize() == 0L) {
            return new ByteArrayInputStream(ByteUtils.EMPTY_BYTE_ARRAY);
        }
        if (this.deferredBlockStreams.isEmpty()) {
            throw new IllegalStateException("No current 7z entry (call getNextEntry() first).");
        }
        while (this.deferredBlockStreams.size() > 1) {
            try (InputStream stream = this.deferredBlockStreams.remove(0);){
                org.apache.commons.io.IOUtils.skip((InputStream)stream, (long)Long.MAX_VALUE, org.apache.commons.io.IOUtils::byteArray);
            }
            this.compressedBytesReadFromCurrentEntry = 0L;
        }
        return this.deferredBlockStreams.get(0);
    }

    public String getDefaultName() {
        if (DEFAULT_FILE_NAME.equals(this.fileName) || this.fileName == null) {
            return null;
        }
        String lastSegment = new File(this.fileName).getName();
        int dotPos = lastSegment.lastIndexOf(".");
        if (dotPos > 0) {
            return lastSegment.substring(0, dotPos);
        }
        return lastSegment + "~";
    }

    public Iterable<SevenZArchiveEntry> getEntries() {
        return new ArrayList<SevenZArchiveEntry>(Arrays.asList(this.archive.files));
    }

    public InputStream getInputStream(SevenZArchiveEntry entry) throws IOException {
        int entryIndex = -1;
        for (int i = 0; i < this.archive.files.length; ++i) {
            if (entry != this.archive.files[i]) continue;
            entryIndex = i;
            break;
        }
        if (entryIndex < 0) {
            throw new IllegalArgumentException("Can not find " + entry.getName() + " in " + this.fileName);
        }
        this.buildDecodingStream(entryIndex, true);
        this.currentEntryIndex = entryIndex;
        this.currentFolderIndex = this.archive.streamMap.fileFolderIndex[entryIndex];
        return this.getCurrentStream();
    }

    public SevenZArchiveEntry getNextEntry() throws IOException {
        if (this.currentEntryIndex >= this.archive.files.length - 1) {
            return null;
        }
        ++this.currentEntryIndex;
        SevenZArchiveEntry entry = this.archive.files[this.currentEntryIndex];
        if (entry.getName() == null && this.useDefaultNameForUnnamedEntries) {
            entry.setName(this.getDefaultName());
        }
        this.buildDecodingStream(this.currentEntryIndex, false);
        this.compressedBytesReadFromCurrentEntry = 0L;
        this.uncompressedBytesReadFromCurrentEntry = 0L;
        return entry;
    }

    public InputStreamStatistics getStatisticsForCurrentEntry() {
        return new InputStreamStatistics(){

            @Override
            public long getCompressedCount() {
                return SevenZFile.this.compressedBytesReadFromCurrentEntry;
            }

            @Override
            public long getUncompressedCount() {
                return SevenZFile.this.uncompressedBytesReadFromCurrentEntry;
            }
        };
    }

    private boolean hasCurrentEntryBeenRead() {
        boolean hasCurrentEntryBeenRead = false;
        if (!this.deferredBlockStreams.isEmpty()) {
            InputStream currentEntryInputStream = this.deferredBlockStreams.get(this.deferredBlockStreams.size() - 1);
            if (currentEntryInputStream instanceof ChecksumInputStream) {
                hasCurrentEntryBeenRead = ((ChecksumInputStream)currentEntryInputStream).getRemaining() != this.archive.files[this.currentEntryIndex].getSize();
            } else if (currentEntryInputStream instanceof BoundedInputStream) {
                hasCurrentEntryBeenRead = ((BoundedInputStream)currentEntryInputStream).getRemaining() != this.archive.files[this.currentEntryIndex].getSize();
            }
        }
        return hasCurrentEntryBeenRead;
    }

    private Archive initializeArchive(StartHeader startHeader, byte[] password, boolean verifyCrc) throws IOException {
        int nextHeaderSizeInt = SevenZFile.toNonNegativeInt("startHeader.nextHeaderSize", startHeader.nextHeaderSize);
        MemoryLimitException.checkKiB(SevenZFile.bytesToKiB(nextHeaderSizeInt), Math.min(SevenZFile.bytesToKiB(SOFT_MAX_ARRAY_LENGTH), (long)this.maxMemoryLimitKiB));
        this.channel.position(32L + startHeader.nextHeaderOffset);
        if (verifyCrc) {
            long position = this.channel.position();
            CheckedInputStream cis = new CheckedInputStream(Channels.newInputStream(this.channel), new CRC32());
            if (cis.skip(nextHeaderSizeInt) != (long)nextHeaderSizeInt) {
                throw new ArchiveException("Problem computing NextHeader CRC-32");
            }
            if (startHeader.nextHeaderCrc != cis.getChecksum().getValue()) {
                throw new ArchiveException("NextHeader CRC-32 mismatch");
            }
            this.channel.position(position);
        }
        Archive archive = new Archive();
        ByteBuffer buf = ByteBuffer.allocate(nextHeaderSizeInt).order(ByteOrder.LITTLE_ENDIAN);
        this.readFully(buf);
        int nid = SevenZFile.getUnsignedByte(buf);
        if (nid == 23) {
            buf = this.readEncodedHeader(buf, archive, password);
            archive = new Archive();
            nid = SevenZFile.getUnsignedByte(buf);
        }
        if (nid != 1) {
            throw new ArchiveException("Broken or unsupported archive: no Header");
        }
        this.readHeader(buf, archive);
        archive.subStreamsInfo = null;
        return archive;
    }

    public int read() throws IOException {
        int b = this.getCurrentStream().read();
        if (b >= 0) {
            ++this.uncompressedBytesReadFromCurrentEntry;
        }
        return b;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        int current = this.getCurrentStream().read(b, off, len);
        if (current > 0) {
            this.uncompressedBytesReadFromCurrentEntry = ArchiveException.addExact(this.uncompressedBytesReadFromCurrentEntry, (long)current);
        }
        return current;
    }

    private BitSet readAllOrBits(ByteBuffer header, int size) throws IOException {
        BitSet bits;
        int areAllDefined = SevenZFile.getUnsignedByte(header);
        if (areAllDefined != 0) {
            bits = new BitSet(size);
            for (int i = 0; i < size; ++i) {
                bits.set(i, true);
            }
        } else {
            bits = this.readBits(header, size);
        }
        return bits;
    }

    private void readArchiveProperties(ByteBuffer input) throws IOException {
        long nid = SevenZFile.readUint64(input);
        while (nid != 0L) {
            int propertySize = SevenZFile.readUint64ToIntExact(input);
            byte[] property = new byte[this.checkByteArray(propertySize)];
            SevenZFile.get(input, property);
            nid = SevenZFile.readUint64(input);
        }
    }

    private BitSet readBits(ByteBuffer header, int size) throws IOException {
        BitSet bits = new BitSet(size);
        int mask = 0;
        int cache = 0;
        for (int i = 0; i < size; ++i) {
            if (mask == 0) {
                mask = 128;
                cache = SevenZFile.getUnsignedByte(header);
            }
            bits.set(i, (cache & mask) != 0);
            mask >>>= 1;
        }
        return bits;
    }

    private ByteBuffer readEncodedHeader(ByteBuffer header, Archive archive, byte[] password) throws IOException {
        int unpackSize;
        byte[] nextHeader;
        int pos = header.position();
        ArchiveStatistics stats = new ArchiveStatistics();
        this.sanityCheckStreamsInfo(header, stats);
        stats.assertValidity(this.maxMemoryLimitKiB);
        header.position(pos);
        this.readStreamsInfo(header, archive);
        if (ArrayUtils.isEmpty((Object[])archive.folders)) {
            throw new ArchiveException("No folders, can't read encoded header");
        }
        if (ArrayUtils.isEmpty((long[])archive.packSizes)) {
            throw new ArchiveException("No packed streams, can't read encoded header");
        }
        Folder folder = archive.folders[0];
        boolean firstPackStreamIndex = false;
        long folderOffset = 32L + archive.packPos + 0L;
        this.channel.position(folderOffset);
        InputStream inputStreamStack = new BoundedSeekableByteChannelInputStream(this.channel, archive.packSizes[0]);
        for (Coder coder : folder.getOrderedCoders()) {
            if (coder.numInStreams != 1L || coder.numOutStreams != 1L) {
                throw new ArchiveException("Multi input/output stream coders are not yet supported");
            }
            inputStreamStack = Coders.addDecoder(this.fileName, inputStreamStack, folder.getUnpackSizeForCoder(coder), coder, password, this.maxMemoryLimitKiB);
        }
        if (folder.hasCrc) {
            inputStreamStack = ((ChecksumInputStream.Builder)ChecksumInputStream.builder().setChecksum((Checksum)new CRC32()).setInputStream(inputStreamStack)).setCountThreshold(folder.getUnpackSize()).setExpectedChecksumValue(folder.crc).get();
        }
        if ((nextHeader = IOUtils.readRange(inputStreamStack, unpackSize = SevenZFile.toNonNegativeInt("unpackSize", folder.getUnpackSize()))).length < unpackSize) {
            throw new ArchiveException("Premature end of stream");
        }
        ((InputStream)inputStreamStack).close();
        return ByteBuffer.wrap(nextHeader).order(ByteOrder.LITTLE_ENDIAN);
    }

    private void readFilesInfo(ByteBuffer header, Archive archive) throws IOException {
        int propertyType;
        int numFilesInt = SevenZFile.readUint64ToIntExact(header);
        LinkedHashMap<Integer, SevenZArchiveEntry> fileMap = new LinkedHashMap<Integer, SevenZArchiveEntry>();
        BitSet isEmptyStream = null;
        BitSet isEmptyFile = null;
        BitSet isAnti = null;
        block11: while ((propertyType = SevenZFile.getUnsignedByte(header)) != 0) {
            long size = SevenZFile.readUint64(header);
            switch (propertyType) {
                case 14: {
                    isEmptyStream = this.readBits(header, numFilesInt);
                    break;
                }
                case 15: {
                    isEmptyFile = this.readBits(header, ArchiveException.requireNonNull(isEmptyStream, () -> "isEmptyStream for " + archive).cardinality());
                    break;
                }
                case 16: {
                    isAnti = this.readBits(header, ArchiveException.requireNonNull(isEmptyStream, () -> "isEmptyStream for " + archive).cardinality());
                    break;
                }
                case 17: {
                    SevenZFile.getUnsignedByte(header);
                    MemoryLimitException.checkKiB(SevenZFile.bytesToKiB(size - 1L), this.maxMemoryLimitKiB);
                    byte[] names = new byte[this.checkByteArray(ArchiveException.toIntExact(size - 1L))];
                    int namesLength = names.length;
                    SevenZFile.get(header, names);
                    int nextFile = 0;
                    int nextName = 0;
                    for (int i = 0; i < namesLength; i += 2) {
                        if (names[i] != 0 || names[i + 1] != 0) continue;
                        this.computeIfAbsent(fileMap, nextFile);
                        ((SevenZArchiveEntry)fileMap.get(nextFile)).setName(new String(names, nextName, i - nextName, StandardCharsets.UTF_16LE));
                        nextName = i + 2;
                        ++nextFile;
                    }
                    if (nextName == namesLength && nextFile == numFilesInt) continue block11;
                    throw new ArchiveException("Error parsing file names");
                }
                case 18: {
                    int i;
                    BitSet timesDefined = this.readAllOrBits(header, numFilesInt);
                    SevenZFile.getUnsignedByte(header);
                    for (i = 0; i < numFilesInt; ++i) {
                        this.computeIfAbsent(fileMap, i);
                        SevenZArchiveEntry entryAtIndex = (SevenZArchiveEntry)fileMap.get(i);
                        entryAtIndex.setHasCreationDate(timesDefined.get(i));
                        if (!entryAtIndex.getHasCreationDate()) continue;
                        entryAtIndex.setCreationDate(SevenZFile.getLong(header));
                    }
                    continue block11;
                }
                case 19: {
                    int i;
                    BitSet timesDefined = this.readAllOrBits(header, numFilesInt);
                    SevenZFile.getUnsignedByte(header);
                    for (i = 0; i < numFilesInt; ++i) {
                        this.computeIfAbsent(fileMap, i);
                        SevenZArchiveEntry entryAtIndex = (SevenZArchiveEntry)fileMap.get(i);
                        entryAtIndex.setHasAccessDate(timesDefined.get(i));
                        if (!entryAtIndex.getHasAccessDate()) continue;
                        entryAtIndex.setAccessDate(SevenZFile.getLong(header));
                    }
                    continue block11;
                }
                case 20: {
                    int i;
                    BitSet timesDefined = this.readAllOrBits(header, numFilesInt);
                    SevenZFile.getUnsignedByte(header);
                    for (i = 0; i < numFilesInt; ++i) {
                        this.computeIfAbsent(fileMap, i);
                        SevenZArchiveEntry entryAtIndex = (SevenZArchiveEntry)fileMap.get(i);
                        entryAtIndex.setHasLastModifiedDate(timesDefined.get(i));
                        if (!entryAtIndex.getHasLastModifiedDate()) continue;
                        entryAtIndex.setLastModifiedDate(SevenZFile.getLong(header));
                    }
                    continue block11;
                }
                case 21: {
                    int i;
                    BitSet attributesDefined = this.readAllOrBits(header, numFilesInt);
                    SevenZFile.getUnsignedByte(header);
                    for (i = 0; i < numFilesInt; ++i) {
                        this.computeIfAbsent(fileMap, i);
                        SevenZArchiveEntry entryAtIndex = (SevenZArchiveEntry)fileMap.get(i);
                        entryAtIndex.setHasWindowsAttributes(attributesDefined.get(i));
                        if (!entryAtIndex.getHasWindowsAttributes()) continue;
                        entryAtIndex.setWindowsAttributes(SevenZFile.getInt(header));
                    }
                    continue block11;
                }
                case 25: {
                    SevenZFile.skipBytesFully(header, size);
                    break;
                }
                default: {
                    SevenZFile.skipBytesFully(header, size);
                }
            }
        }
        int nonEmptyFileCounter = 0;
        int emptyFileCounter = 0;
        for (int i = 0; i < numFilesInt; ++i) {
            SevenZArchiveEntry entryAtIndex = (SevenZArchiveEntry)fileMap.get(i);
            if (entryAtIndex == null) continue;
            entryAtIndex.setHasStream(isEmptyStream == null || !isEmptyStream.get(i));
            if (entryAtIndex.hasStream()) {
                if (archive.subStreamsInfo == null) {
                    throw new ArchiveException("Archive contains file with streams but no subStreamsInfo");
                }
                entryAtIndex.setDirectory(false);
                entryAtIndex.setAntiItem(false);
                entryAtIndex.setHasCrc(archive.subStreamsInfo.hasCrc.get(nonEmptyFileCounter));
                entryAtIndex.setCrcValue(archive.subStreamsInfo.crcs[nonEmptyFileCounter]);
                entryAtIndex.setSize(archive.subStreamsInfo.unpackSizes[nonEmptyFileCounter]);
                if (entryAtIndex.getSize() < 0L) {
                    throw new ArchiveException("Broken archive, entry with negative size");
                }
                ++nonEmptyFileCounter;
                continue;
            }
            entryAtIndex.setDirectory(isEmptyFile == null || !isEmptyFile.get(emptyFileCounter));
            entryAtIndex.setAntiItem(isAnti != null && isAnti.get(emptyFileCounter));
            entryAtIndex.setHasCrc(false);
            entryAtIndex.setSize(0L);
            ++emptyFileCounter;
        }
        archive.files = (SevenZArchiveEntry[])fileMap.values().stream().filter(Objects::nonNull).toArray(SevenZArchiveEntry[]::new);
        this.calculateStreamMap(archive);
    }

    private Folder readFolder(ByteBuffer header) throws IOException {
        Folder folder = new Folder();
        int numCoders = SevenZFile.readUint64ToIntExact(header);
        Coder[] coders = new Coder[this.checkObjectArray(numCoders)];
        long totalInStreams = 0L;
        long totalOutStreams = 0L;
        for (int i = 0; i < coders.length; ++i) {
            long numOutStreams;
            long numInStreams;
            int bits = SevenZFile.getUnsignedByte(header);
            int idSize = bits & 0xF;
            boolean isSimple = (bits & 0x10) == 0;
            boolean hasAttributes = (bits & 0x20) != 0;
            boolean moreAlternativeMethods = (bits & 0x80) != 0;
            byte[] decompressionMethodId = new byte[idSize];
            SevenZFile.get(header, decompressionMethodId);
            if (isSimple) {
                numInStreams = 1L;
                numOutStreams = 1L;
            } else {
                numInStreams = SevenZFile.readUint64(header);
                numOutStreams = SevenZFile.readUint64(header);
            }
            totalInStreams = ArchiveException.addExact(totalInStreams, numInStreams);
            totalOutStreams = ArchiveException.addExact(totalOutStreams, numOutStreams);
            byte[] properties = null;
            if (hasAttributes) {
                long propertiesSize = SevenZFile.readUint64(header);
                properties = new byte[this.checkByteArray(ArchiveException.toIntExact(propertiesSize))];
                SevenZFile.get(header, properties);
            }
            if (moreAlternativeMethods) {
                throw new ArchiveException("Alternative methods are unsupported, please report. The reference implementation doesn't support them either.");
            }
            coders[i] = new Coder(decompressionMethodId, numInStreams, numOutStreams, properties);
        }
        folder.coders = coders;
        folder.totalInputStreams = totalInStreams;
        folder.totalOutputStreams = totalOutStreams;
        long numBindPairs = totalOutStreams - 1L;
        BindPair[] bindPairs = new BindPair[this.checkObjectArray(ArchiveException.toIntExact(numBindPairs))];
        for (int i = 0; i < bindPairs.length; ++i) {
            bindPairs[i] = new BindPair(SevenZFile.readUint64(header), SevenZFile.readUint64(header));
        }
        folder.bindPairs = bindPairs;
        long numPackedStreams = totalInStreams - numBindPairs;
        int numPackedStreamsInt = ArchiveException.toIntExact(numPackedStreams);
        long[] packedStreams = new long[this.checkObjectArray(numPackedStreamsInt)];
        if (numPackedStreams == 1L) {
            long i;
            for (i = 0L; i < totalInStreams && folder.findBindPairForInStream(i) >= 0; ++i) {
            }
            packedStreams[0] = i;
        } else {
            for (int i = 0; i < numPackedStreamsInt; ++i) {
                packedStreams[i] = SevenZFile.readUint64(header);
            }
        }
        folder.packedStreams = packedStreams;
        return folder;
    }

    private void readFully(ByteBuffer buf) throws IOException {
        buf.rewind();
        IOUtils.readFully(this.channel, buf);
        buf.flip();
    }

    private void readHeader(ByteBuffer header, Archive archive) throws IOException {
        int pos = header.position();
        ArchiveStatistics stats = this.sanityCheckAndCollectStatistics(header);
        stats.assertValidity(this.maxMemoryLimitKiB);
        header.position(pos);
        int nid = SevenZFile.getUnsignedByte(header);
        if (nid == 2) {
            this.readArchiveProperties(header);
            nid = SevenZFile.getUnsignedByte(header);
        }
        if (nid == 3) {
            throw new ArchiveException("Additional streams unsupported");
        }
        if (nid == 4) {
            this.readStreamsInfo(header, archive);
            nid = SevenZFile.getUnsignedByte(header);
        }
        if (nid == 5) {
            this.readFilesInfo(header, archive);
            nid = SevenZFile.getUnsignedByte(header);
        }
    }

    private Archive readHeaders(byte[] password) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(12).order(ByteOrder.LITTLE_ENDIAN);
        this.readFully(buf);
        byte[] signature = new byte[6];
        buf.get(signature);
        if (!Arrays.equals(signature, SIGNATURE)) {
            throw new ArchiveException("Bad 7z signature");
        }
        byte archiveVersionMajor = buf.get();
        byte archiveVersionMinor = buf.get();
        if (archiveVersionMajor != 0) {
            throw new ArchiveException("Unsupported 7z version (%d,%d)", archiveVersionMajor, archiveVersionMinor);
        }
        boolean headerLooksValid = false;
        long startHeaderCrc = 0xFFFFFFFFL & (long)buf.getInt();
        if (startHeaderCrc == 0L) {
            long currentPosition = this.channel.position();
            ByteBuffer peekBuf = ByteBuffer.allocate(20);
            this.readFully(peekBuf);
            this.channel.position(currentPosition);
            while (peekBuf.hasRemaining()) {
                if (peekBuf.get() == 0) continue;
                headerLooksValid = true;
                break;
            }
        } else {
            headerLooksValid = true;
        }
        if (headerLooksValid) {
            return this.initializeArchive(this.readStartHeader(startHeaderCrc), password, true);
        }
        if (this.tryToRecoverBrokenArchives) {
            return this.tryToLocateEndHeader(password);
        }
        throw new ArchiveException("Archive seems to be invalid. You may want to retry and enable the tryToRecoverBrokenArchives if the archive could be a multi volume archive that has been closed prematurely.");
    }

    private void readPackInfo(ByteBuffer header, Archive archive) throws IOException {
        int i;
        archive.packPos = SevenZFile.readUint64(header);
        int numPackStreamsInt = SevenZFile.readUint64ToIntExact(header);
        int nid = SevenZFile.getUnsignedByte(header);
        if (nid == 9) {
            archive.packSizes = new long[this.checkLongArray(numPackStreamsInt)];
            for (i = 0; i < archive.packSizes.length; ++i) {
                archive.packSizes[i] = SevenZFile.readUint64(header);
            }
            nid = SevenZFile.getUnsignedByte(header);
        }
        if (nid == 10) {
            archive.packCrcsDefined = this.readAllOrBits(header, numPackStreamsInt);
            archive.packCrcs = new long[this.checkLongArray(numPackStreamsInt)];
            for (i = 0; i < numPackStreamsInt; ++i) {
                if (!archive.packCrcsDefined.get(i)) continue;
                archive.packCrcs[i] = 0xFFFFFFFFL & (long)SevenZFile.getInt(header);
            }
            SevenZFile.getUnsignedByte(header);
        }
    }

    private StartHeader readStartHeader(long startHeaderCrc) throws IOException {
        try (DataInputStream dataInputStream = new DataInputStream((InputStream)((ChecksumInputStream.Builder)ChecksumInputStream.builder().setChecksum((Checksum)new CRC32()).setInputStream((InputStream)new BoundedSeekableByteChannelInputStream(this.channel, 20L))).setCountThreshold(20L).setExpectedChecksumValue(startHeaderCrc).get());){
            long nextHeaderOffset = Long.reverseBytes(dataInputStream.readLong());
            if (nextHeaderOffset < 0L || nextHeaderOffset + 32L > this.channel.size()) {
                throw new ArchiveException("nextHeaderOffset is out of bounds");
            }
            long nextHeaderSize = Long.reverseBytes(dataInputStream.readLong());
            long nextHeaderEnd = nextHeaderOffset + nextHeaderSize;
            if (nextHeaderEnd < nextHeaderOffset || nextHeaderEnd + 32L > this.channel.size()) {
                throw new ArchiveException("nextHeaderSize is out of bounds");
            }
            long nextHeaderCrc = 0xFFFFFFFFL & (long)Integer.reverseBytes(dataInputStream.readInt());
            StartHeader startHeader = new StartHeader(nextHeaderOffset, nextHeaderSize, nextHeaderCrc);
            return startHeader;
        }
    }

    private void readStreamsInfo(ByteBuffer header, Archive archive) throws IOException {
        int nid = SevenZFile.getUnsignedByte(header);
        if (nid == 6) {
            this.readPackInfo(header, archive);
            nid = SevenZFile.getUnsignedByte(header);
        }
        if (nid == 7) {
            this.readUnpackInfo(header, archive);
            nid = SevenZFile.getUnsignedByte(header);
        } else {
            archive.folders = Folder.EMPTY_FOLDER_ARRAY;
        }
        if (nid == 8) {
            this.readSubStreamsInfo(header, archive);
            nid = SevenZFile.getUnsignedByte(header);
        }
    }

    private void readSubStreamsInfo(ByteBuffer header, Archive archive) throws IOException {
        for (Folder folder : archive.folders) {
            folder.numUnpackSubStreams = 1;
        }
        long unpackStreamsCount = archive.folders.length;
        int nid = SevenZFile.getUnsignedByte(header);
        if (nid == 13) {
            unpackStreamsCount = 0L;
            for (Folder folder : archive.folders) {
                long numStreams = SevenZFile.readUint64(header);
                folder.numUnpackSubStreams = (int)numStreams;
                unpackStreamsCount = ArchiveException.addExact(unpackStreamsCount, numStreams);
            }
            nid = SevenZFile.getUnsignedByte(header);
        }
        SubStreamsInfo subStreamsInfo = new SubStreamsInfo(unpackStreamsCount, this.maxMemoryLimitKiB);
        int nextUnpackStream = 0;
        for (Folder folder : archive.folders) {
            if (folder.numUnpackSubStreams == 0) continue;
            long sum = 0L;
            if (nid == 9) {
                for (int i = 0; i < folder.numUnpackSubStreams - 1; ++i) {
                    long size = SevenZFile.readUint64(header);
                    subStreamsInfo.unpackSizes[nextUnpackStream++] = size;
                    sum = ArchiveException.addExact(sum, size);
                }
            }
            if (sum > folder.getUnpackSize()) {
                throw new ArchiveException("Sum of unpack sizes of folder exceeds total unpack size");
            }
            subStreamsInfo.unpackSizes[nextUnpackStream++] = folder.getUnpackSize() - sum;
        }
        if (nid == 9) {
            nid = SevenZFile.getUnsignedByte(header);
        }
        int numDigests = 0;
        for (Folder folder : archive.folders) {
            if (folder.numUnpackSubStreams == 1 && folder.hasCrc) continue;
            numDigests = ArchiveException.addExact(numDigests, folder.numUnpackSubStreams);
        }
        if (nid == 10) {
            BitSet hasMissingCrc = this.readAllOrBits(header, numDigests);
            long[] missingCrcs = new long[this.checkLongArray(numDigests)];
            for (int i = 0; i < numDigests; ++i) {
                if (!hasMissingCrc.get(i)) continue;
                missingCrcs[i] = 0xFFFFFFFFL & (long)SevenZFile.getInt(header);
            }
            int nextCrc = 0;
            int nextMissingCrc = 0;
            for (Folder folder : archive.folders) {
                if (folder.numUnpackSubStreams == 1 && folder.hasCrc) {
                    subStreamsInfo.hasCrc.set(nextCrc, true);
                    subStreamsInfo.crcs[nextCrc] = folder.crc;
                    ++nextCrc;
                    continue;
                }
                for (int i = 0; i < folder.numUnpackSubStreams; ++i) {
                    subStreamsInfo.hasCrc.set(nextCrc, hasMissingCrc.get(nextMissingCrc));
                    subStreamsInfo.crcs[nextCrc] = missingCrcs[nextMissingCrc];
                    ++nextCrc;
                    ++nextMissingCrc;
                }
            }
            nid = SevenZFile.getUnsignedByte(header);
        }
        archive.subStreamsInfo = subStreamsInfo;
    }

    private void readUnpackInfo(ByteBuffer header, Archive archive) throws IOException {
        int nid = SevenZFile.getUnsignedByte(header);
        int numFoldersInt = SevenZFile.readUint64ToIntExact(header);
        Folder[] folders = new Folder[this.checkObjectArray(numFoldersInt)];
        archive.folders = folders;
        SevenZFile.getUnsignedByte(header);
        for (int i = 0; i < numFoldersInt; ++i) {
            folders[i] = this.readFolder(header);
        }
        nid = SevenZFile.getUnsignedByte(header);
        for (Folder folder : folders) {
            folder.unpackSizes = new long[this.checkLongArray(SevenZFile.toNonNegativeInt("totalOutputStreams", folder.totalOutputStreams))];
            int i = 0;
            while ((long)i < folder.totalOutputStreams) {
                folder.unpackSizes[i] = SevenZFile.readUint64(header);
                ++i;
            }
        }
        nid = SevenZFile.getUnsignedByte(header);
        if (nid == 10) {
            BitSet crcsDefined = this.readAllOrBits(header, numFoldersInt);
            for (int i = 0; i < numFoldersInt; ++i) {
                if (crcsDefined.get(i)) {
                    folders[i].hasCrc = true;
                    folders[i].crc = 0xFFFFFFFFL & (long)SevenZFile.getInt(header);
                    continue;
                }
                folders[i].hasCrc = false;
            }
            nid = SevenZFile.getUnsignedByte(header);
        }
    }

    private void reopenFolderInputStream(int folderIndex, SevenZArchiveEntry file) throws IOException {
        this.deferredBlockStreams.clear();
        if (this.currentFolderInputStream != null) {
            this.currentFolderInputStream.close();
            this.currentFolderInputStream = null;
        }
        Folder folder = this.archive.folders[folderIndex];
        int firstPackStreamIndex = this.archive.streamMap.folderFirstPackStreamIndex[folderIndex];
        long folderOffset = 32L + this.archive.packPos + this.archive.streamMap.packStreamOffsets[firstPackStreamIndex];
        this.currentFolderInputStream = this.buildDecoderStack(folder, folderOffset, firstPackStreamIndex, file);
    }

    private ArchiveStatistics sanityCheckAndCollectStatistics(ByteBuffer header) throws IOException {
        ArchiveStatistics stats = new ArchiveStatistics();
        int nid = SevenZFile.getUnsignedByte(header);
        if (nid == 2) {
            this.sanityCheckArchiveProperties(header);
            nid = SevenZFile.getUnsignedByte(header);
        }
        if (nid == 3) {
            throw new ArchiveException("Additional streams unsupported");
        }
        if (nid == 4) {
            this.sanityCheckStreamsInfo(header, stats);
            nid = SevenZFile.getUnsignedByte(header);
        }
        if (nid == 5) {
            this.sanityCheckFilesInfo(header, stats);
            nid = SevenZFile.getUnsignedByte(header);
        }
        if (nid != 0) {
            throw new ArchiveException("Badly terminated header, found %s", nid);
        }
        return stats;
    }

    private void sanityCheckArchiveProperties(ByteBuffer header) throws IOException {
        long nid = SevenZFile.readUint64(header);
        while (nid != 0L) {
            int propertySize = SevenZFile.toNonNegativeInt("propertySize", SevenZFile.readUint64(header));
            if (SevenZFile.skipBytesFully(header, propertySize) < (long)propertySize) {
                throw new ArchiveException("Invalid property size");
            }
            nid = SevenZFile.readUint64(header);
        }
    }

    private void sanityCheckFilesInfo(ByteBuffer header, ArchiveStatistics stats) throws IOException {
        int propertyType;
        stats.numberOfEntries = SevenZFile.toNonNegativeInt("numFiles", SevenZFile.readUint64(header));
        int emptyStreams = -1;
        block12: while ((propertyType = SevenZFile.getUnsignedByte(header)) != 0) {
            long size = SevenZFile.readUint64(header);
            switch (propertyType) {
                case 14: {
                    emptyStreams = this.readBits(header, stats.numberOfEntries).cardinality();
                    continue block12;
                }
                case 15: {
                    if (emptyStreams == -1) {
                        throw new ArchiveException("Header format error: kEmptyStream must appear before kEmptyFile");
                    }
                    this.readBits(header, emptyStreams);
                    continue block12;
                }
                case 16: {
                    if (emptyStreams == -1) {
                        throw new ArchiveException("Header format error: kEmptyStream must appear before kAnti");
                    }
                    this.readBits(header, emptyStreams);
                    continue block12;
                }
                case 17: {
                    int external = SevenZFile.getUnsignedByte(header);
                    if (external != 0) {
                        throw new ArchiveException("Not implemented");
                    }
                    int namesLength = SevenZFile.toNonNegativeInt("file names length", size - 1L);
                    if ((namesLength & 1) != 0) {
                        throw new ArchiveException("File names length invalid");
                    }
                    int filesSeen = 0;
                    for (int i = 0; i < namesLength; i += 2) {
                        char c = SevenZFile.getChar(header);
                        if (c != '\u0000') continue;
                        ++filesSeen;
                    }
                    if (filesSeen == stats.numberOfEntries) continue block12;
                    throw new ArchiveException("Invalid number of file names (%,d instead of %,d)", filesSeen, stats.numberOfEntries);
                }
                case 18: {
                    int timesDefined = this.readAllOrBits(header, stats.numberOfEntries).cardinality();
                    int external = SevenZFile.getUnsignedByte(header);
                    if (external != 0) {
                        throw new ArchiveException("Not implemented");
                    }
                    if (SevenZFile.skipBytesFully(header, 8 * timesDefined) >= (long)(8 * timesDefined)) continue block12;
                    throw new ArchiveException("Invalid creation dates size");
                }
                case 19: {
                    int timesDefined = this.readAllOrBits(header, stats.numberOfEntries).cardinality();
                    int external = SevenZFile.getUnsignedByte(header);
                    if (external != 0) {
                        throw new ArchiveException("Not implemented");
                    }
                    if (SevenZFile.skipBytesFully(header, 8 * timesDefined) >= (long)(8 * timesDefined)) continue block12;
                    throw new ArchiveException("Invalid access dates size");
                }
                case 20: {
                    int timesDefined = this.readAllOrBits(header, stats.numberOfEntries).cardinality();
                    int external = SevenZFile.getUnsignedByte(header);
                    if (external != 0) {
                        throw new ArchiveException("Not implemented");
                    }
                    if (SevenZFile.skipBytesFully(header, 8 * timesDefined) >= (long)(8 * timesDefined)) continue block12;
                    throw new ArchiveException("Invalid modification dates size");
                }
                case 21: {
                    int attributesDefined = this.readAllOrBits(header, stats.numberOfEntries).cardinality();
                    int external = SevenZFile.getUnsignedByte(header);
                    if (external != 0) {
                        throw new ArchiveException("Not implemented");
                    }
                    if (SevenZFile.skipBytesFully(header, 4 * attributesDefined) >= (long)(4 * attributesDefined)) continue block12;
                    throw new ArchiveException("Invalid windows attributes size");
                }
                case 24: {
                    throw new ArchiveException("kStartPos is unsupported, please report");
                }
                case 25: {
                    if (SevenZFile.skipBytesFully(header, size) >= size) continue block12;
                    throw new ArchiveException("Incomplete kDummy property");
                }
            }
            if (SevenZFile.skipBytesFully(header, size) >= size) continue;
            throw new ArchiveException("Incomplete property of type " + propertyType);
        }
        stats.numberOfEntriesWithStream = stats.numberOfEntries - Math.max(emptyStreams, 0);
    }

    private long sanityCheckFolder(ByteBuffer header, ArchiveStatistics stats) throws IOException {
        int numCoders = SevenZFile.toNonNegativeInt("numCoders", SevenZFile.readUint64(header));
        if (numCoders == 0) {
            throw new ArchiveException("Folder without coders");
        }
        stats.numberOfCoders = ArchiveException.addExact(stats.numberOfCoders, (long)numCoders);
        long totalOutStreams = 0L;
        long totalInStreams = 0L;
        for (int i = 0; i < numCoders; ++i) {
            int propertiesSize;
            boolean moreAlternativeMethods;
            int bits = SevenZFile.getUnsignedByte(header);
            int idSize = bits & 0xF;
            SevenZFile.get(header, new byte[idSize]);
            boolean isSimple = (bits & 0x10) == 0;
            boolean hasAttributes = (bits & 0x20) != 0;
            boolean bl = moreAlternativeMethods = (bits & 0x80) != 0;
            if (moreAlternativeMethods) {
                throw new ArchiveException("Alternative methods are unsupported, please report. The reference implementation doesn't support them either.");
            }
            if (isSimple) {
                ++totalInStreams;
                ++totalOutStreams;
            } else {
                totalInStreams = ArchiveException.addExact(totalInStreams, (long)SevenZFile.toNonNegativeInt("numInStreams", SevenZFile.readUint64(header)));
                totalOutStreams = ArchiveException.addExact(totalOutStreams, (long)SevenZFile.toNonNegativeInt("numOutStreams", SevenZFile.readUint64(header)));
            }
            if (!hasAttributes || SevenZFile.skipBytesFully(header, propertiesSize = SevenZFile.toNonNegativeInt("propertiesSize", SevenZFile.readUint64(header))) >= (long)propertiesSize) continue;
            throw new ArchiveException("Invalid propertiesSize in folder");
        }
        SevenZFile.toNonNegativeInt("totalInStreams", totalInStreams);
        SevenZFile.toNonNegativeInt("totalOutStreams", totalOutStreams);
        stats.numberOfOutStreams = ArchiveException.addExact(stats.numberOfOutStreams, totalOutStreams);
        stats.numberOfInStreams = ArchiveException.addExact(stats.numberOfInStreams, totalInStreams);
        if (totalOutStreams == 0L) {
            throw new ArchiveException("Total output streams can't be 0");
        }
        int numBindPairs = SevenZFile.toNonNegativeInt("numBindPairs", totalOutStreams - 1L);
        if (totalInStreams < (long)numBindPairs) {
            throw new ArchiveException("Total input streams can't be less than the number of bind pairs");
        }
        BitSet inStreamsBound = new BitSet((int)totalInStreams);
        for (int i = 0; i < numBindPairs; ++i) {
            int inIndex = SevenZFile.toNonNegativeInt("inIndex", SevenZFile.readUint64(header));
            if (totalInStreams <= (long)inIndex) {
                throw new ArchiveException("inIndex is bigger than number of inStreams");
            }
            inStreamsBound.set(inIndex);
            int outIndex = SevenZFile.toNonNegativeInt("outIndex", SevenZFile.readUint64(header));
            if (totalOutStreams > (long)outIndex) continue;
            throw new ArchiveException("outIndex is bigger than number of outStreams");
        }
        int numPackedStreams = SevenZFile.toNonNegativeInt("numPackedStreams", totalInStreams - (long)numBindPairs);
        if (numPackedStreams == 1) {
            if (inStreamsBound.nextClearBit(0) == -1) {
                throw new ArchiveException("Couldn't find stream's bind pair index");
            }
        } else {
            for (int i = 0; i < numPackedStreams; ++i) {
                int packedStreamIndex = SevenZFile.toNonNegativeInt("packedStreamIndex", SevenZFile.readUint64(header));
                if ((long)packedStreamIndex < totalInStreams) continue;
                throw new ArchiveException("packedStreamIndex is bigger than number of totalInStreams");
            }
        }
        return totalOutStreams;
    }

    private void sanityCheckPackInfo(ByteBuffer header, ArchiveStatistics stats) throws IOException {
        long packPos = SevenZFile.readUint64(header);
        if (packPos < 0L || 32L + packPos > this.channel.size() || 32L + packPos < 0L) {
            throw new ArchiveException("packPos (%,d) is out of range", packPos);
        }
        long numPackStreams = SevenZFile.readUint64(header);
        stats.numberOfPackedStreams = SevenZFile.toNonNegativeInt("numPackStreams", numPackStreams);
        int nid = SevenZFile.getUnsignedByte(header);
        if (nid == 9) {
            long totalPackSizes = 0L;
            for (int i = 0; i < stats.numberOfPackedStreams; ++i) {
                long packSize = SevenZFile.readUint64(header);
                totalPackSizes = ArchiveException.addExact(totalPackSizes, packSize);
                long endOfPackStreams = 32L + packPos + totalPackSizes;
                if (packSize >= 0L && endOfPackStreams <= this.channel.size() && endOfPackStreams >= packPos) continue;
                throw new ArchiveException("packSize (%,d) is out of range", packSize);
            }
            nid = SevenZFile.getUnsignedByte(header);
        }
        if (nid == 10) {
            int crcsDefined = this.readAllOrBits(header, stats.numberOfPackedStreams).cardinality();
            if (SevenZFile.skipBytesFully(header, 4 * crcsDefined) < (long)(4 * crcsDefined)) {
                throw new ArchiveException("Invalid number of CRCs in PackInfo");
            }
            nid = SevenZFile.getUnsignedByte(header);
        }
        if (nid != 0) {
            throw new ArchiveException("Badly terminated PackInfo (%s)", nid);
        }
    }

    private void sanityCheckStreamsInfo(ByteBuffer header, ArchiveStatistics stats) throws IOException {
        int nid = SevenZFile.getUnsignedByte(header);
        if (nid == 6) {
            this.sanityCheckPackInfo(header, stats);
            nid = SevenZFile.getUnsignedByte(header);
        }
        if (nid == 7) {
            this.sanityCheckUnpackInfo(header, stats);
            nid = SevenZFile.getUnsignedByte(header);
        }
        if (nid == 8) {
            this.sanityCheckSubStreamsInfo(header, stats);
            nid = SevenZFile.getUnsignedByte(header);
        }
        if (nid != 0) {
            throw new ArchiveException("Badly terminated StreamsInfo");
        }
    }

    private void sanityCheckSubStreamsInfo(ByteBuffer header, ArchiveStatistics stats) throws IOException {
        int nid = SevenZFile.getUnsignedByte(header);
        LinkedList<Integer> numUnpackSubStreamsPerFolder = new LinkedList<Integer>();
        if (nid == 13) {
            for (int i = 0; i < stats.numberOfFolders; ++i) {
                numUnpackSubStreamsPerFolder.add(SevenZFile.toNonNegativeInt("numStreams", SevenZFile.readUint64(header)));
            }
            stats.numberOfUnpackSubStreams = numUnpackSubStreamsPerFolder.stream().mapToLong(Integer::longValue).sum();
            nid = SevenZFile.getUnsignedByte(header);
        } else {
            stats.numberOfUnpackSubStreams = stats.numberOfFolders;
        }
        SevenZFile.toNonNegativeInt("totalUnpackStreams", stats.numberOfUnpackSubStreams);
        if (nid == 9) {
            Iterator i = numUnpackSubStreamsPerFolder.iterator();
            while (i.hasNext()) {
                int numUnpackSubStreams = (Integer)i.next();
                if (numUnpackSubStreams == 0) continue;
                for (int i2 = 0; i2 < numUnpackSubStreams - 1; ++i2) {
                    long size = SevenZFile.readUint64(header);
                    if (size >= 0L) continue;
                    throw new ArchiveException("Negative unpackSize");
                }
            }
            nid = SevenZFile.getUnsignedByte(header);
        }
        int numDigests = 0;
        if (numUnpackSubStreamsPerFolder.isEmpty()) {
            numDigests = stats.folderHasCrc == null ? stats.numberOfFolders : stats.numberOfFolders - stats.folderHasCrc.cardinality();
        } else {
            int folderIdx = 0;
            Iterator iterator = numUnpackSubStreamsPerFolder.iterator();
            while (iterator.hasNext()) {
                int numUnpackSubStreams = (Integer)iterator.next();
                if (numUnpackSubStreams == 1 && stats.folderHasCrc != null && stats.folderHasCrc.get(folderIdx++)) continue;
                numDigests = ArchiveException.addExact(numDigests, numUnpackSubStreams);
            }
        }
        if (nid == 10) {
            SevenZFile.toNonNegativeInt("numDigests", numDigests);
            int missingCrcs = this.readAllOrBits(header, numDigests).cardinality();
            if (SevenZFile.skipBytesFully(header, 4 * missingCrcs) < (long)(4 * missingCrcs)) {
                throw new ArchiveException("Invalid number of missing CRCs in SubStreamInfo");
            }
            nid = SevenZFile.getUnsignedByte(header);
        }
        if (nid != 0) {
            throw new ArchiveException("Badly terminated SubStreamsInfo");
        }
    }

    private void sanityCheckUnpackInfo(ByteBuffer header, ArchiveStatistics stats) throws IOException {
        int nid = SevenZFile.getUnsignedByte(header);
        if (nid != 11) {
            throw new ArchiveException("Expected NID.kFolder, got %s", nid);
        }
        long numFolders = SevenZFile.readUint64(header);
        stats.numberOfFolders = SevenZFile.toNonNegativeInt("numFolders", numFolders);
        int external = SevenZFile.getUnsignedByte(header);
        if (external != 0) {
            throw new ArchiveException("External unsupported");
        }
        LinkedList<Long> numberOfOutputStreamsPerFolder = new LinkedList<Long>();
        for (int i = 0; i < stats.numberOfFolders; ++i) {
            numberOfOutputStreamsPerFolder.add(this.sanityCheckFolder(header, stats));
        }
        long totalNumberOfBindPairs = stats.numberOfOutStreams - (long)stats.numberOfFolders;
        long packedStreamsRequiredByFolders = stats.numberOfInStreams - totalNumberOfBindPairs;
        if (packedStreamsRequiredByFolders < (long)stats.numberOfPackedStreams) {
            throw new ArchiveException("Archive doesn't contain enough packed streams");
        }
        nid = SevenZFile.getUnsignedByte(header);
        if (nid != 12) {
            throw new ArchiveException("Expected kCodersUnpackSize, got %s", nid);
        }
        Iterator iterator = numberOfOutputStreamsPerFolder.iterator();
        while (iterator.hasNext()) {
            long numberOfOutputStreams = (Long)iterator.next();
            for (long i = 0L; i < numberOfOutputStreams; ++i) {
                long unpackSize = SevenZFile.readUint64(header);
                if (unpackSize >= 0L) continue;
                throw new IllegalArgumentException("Negative unpackSize");
            }
        }
        nid = SevenZFile.getUnsignedByte(header);
        if (nid == 10) {
            stats.folderHasCrc = this.readAllOrBits(header, stats.numberOfFolders);
            int crcsDefined = stats.folderHasCrc.cardinality();
            if (SevenZFile.skipBytesFully(header, 4 * crcsDefined) < (long)(4 * crcsDefined)) {
                throw new ArchiveException("Invalid number of CRCs in UnpackInfo");
            }
            nid = SevenZFile.getUnsignedByte(header);
        }
        if (nid != 0) {
            throw new ArchiveException("Badly terminated UnpackInfo");
        }
    }

    private boolean skipEntriesWhenNeeded(int entryIndex, boolean isInSameFolder, int folderIndex) throws IOException {
        SevenZArchiveEntry file = this.archive.files[entryIndex];
        if (this.currentEntryIndex == entryIndex && !this.hasCurrentEntryBeenRead()) {
            return false;
        }
        int filesToSkipStartIndex = this.archive.streamMap.folderFirstFileIndex[this.currentFolderIndex];
        if (isInSameFolder) {
            if (this.currentEntryIndex < entryIndex) {
                filesToSkipStartIndex = this.currentEntryIndex + 1;
            } else {
                this.reopenFolderInputStream(folderIndex, file);
            }
        }
        for (int i = filesToSkipStartIndex; i < entryIndex; ++i) {
            SevenZArchiveEntry fileToSkip = this.archive.files[i];
            BoundedInputStream fileStreamToSkip = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream(this.currentFolderInputStream)).setMaxCount(fileToSkip.getSize())).setPropagateClose(false)).get();
            if (fileToSkip.getHasCrc()) {
                fileStreamToSkip = ((ChecksumInputStream.Builder)ChecksumInputStream.builder().setChecksum((Checksum)new CRC32()).setInputStream((InputStream)fileStreamToSkip)).setCountThreshold(fileToSkip.getSize()).setExpectedChecksumValue(fileToSkip.getCrcValue()).get();
            }
            this.deferredBlockStreams.add((InputStream)fileStreamToSkip);
            fileToSkip.setContentMethods(file.getContentMethods());
        }
        return true;
    }

    public String toString() {
        return this.archive.toString();
    }

    private Archive tryToLocateEndHeader(byte[] password) throws IOException {
        ByteBuffer nidBuf = ByteBuffer.allocate(1);
        long searchLimit = 0x100000L;
        long previousDataSize = this.channel.position() + 20L;
        long minPos = this.channel.position() + 0x100000L > this.channel.size() ? this.channel.position() : this.channel.size() - 0x100000L;
        long pos = this.channel.size() - 1L;
        while (pos > minPos) {
            this.channel.position(--pos);
            nidBuf.rewind();
            if (this.channel.read(nidBuf) < 1) {
                throw new EOFException();
            }
            byte nid = nidBuf.array()[0];
            if (nid != 23 && nid != 1) continue;
            try {
                long nextHeaderOffset = pos - previousDataSize;
                long nextHeaderSize = this.channel.size() - pos;
                StartHeader startHeader = new StartHeader(nextHeaderOffset, nextHeaderSize, 0L);
                Archive result = this.initializeArchive(startHeader, password, false);
                if (result.packSizes.length <= 0 || result.files.length <= 0) continue;
                return result;
            }
            catch (Exception exception) {
            }
        }
        throw new ArchiveException("Start header corrupt and unable to guess end header");
    }

    public static class Builder
    extends AbstractStreamBuilder<SevenZFile, Builder> {
        static final int MEMORY_LIMIT_KIB = Integer.MAX_VALUE;
        static final boolean USE_DEFAULTNAME_FOR_UNNAMED_ENTRIES = false;
        static final boolean TRY_TO_RECOVER_BROKEN_ARCHIVES = false;
        private SeekableByteChannel seekableByteChannel;
        private String defaultName = "unknown archive";
        private byte[] password;
        private int maxMemoryLimitKiB = Integer.MAX_VALUE;
        private boolean useDefaultNameForUnnamedEntries = false;
        private boolean tryToRecoverBrokenArchives = false;

        public SevenZFile get() throws IOException {
            String actualDescription;
            SeekableByteChannel actualChannel;
            if (this.seekableByteChannel != null) {
                actualChannel = this.seekableByteChannel;
                actualDescription = this.defaultName;
            } else if (this.checkOrigin() instanceof AbstractOrigin.ByteArrayOrigin) {
                actualChannel = new SeekableInMemoryByteChannel(this.checkOrigin().getByteArray());
                actualDescription = this.defaultName;
            } else {
                Object[] openOptions = this.getOpenOptions();
                if (ArrayUtils.isEmpty((Object[])openOptions)) {
                    openOptions = new OpenOption[]{StandardOpenOption.READ};
                }
                Path path = this.getPath();
                actualChannel = Files.newByteChannel(path, (OpenOption[])openOptions);
                actualDescription = path.toAbsolutePath().toString();
            }
            boolean closeOnError = this.seekableByteChannel != null;
            return new SevenZFile(actualChannel, actualDescription, this.password, closeOnError, this.maxMemoryLimitKiB, this.useDefaultNameForUnnamedEntries, this.tryToRecoverBrokenArchives);
        }

        public Builder setDefaultName(String defaultName) {
            this.defaultName = defaultName;
            return this;
        }

        public Builder setMaxMemoryLimitKb(int maxMemoryLimitKb) {
            this.maxMemoryLimitKiB = SevenZFile.kbToKiB(maxMemoryLimitKb);
            return this;
        }

        public Builder setMaxMemoryLimitKiB(int maxMemoryLimitKiB) {
            this.maxMemoryLimitKiB = maxMemoryLimitKiB;
            return this;
        }

        public Builder setPassword(byte[] password) {
            this.password = password != null ? (byte[])password.clone() : null;
            return this;
        }

        public Builder setPassword(char[] password) {
            this.password = password != null ? AES256SHA256Decoder.utf16Decode((char[])password.clone()) : null;
            return this;
        }

        public Builder setPassword(String password) {
            this.password = password != null ? AES256SHA256Decoder.utf16Decode(password.toCharArray()) : null;
            return this;
        }

        public Builder setSeekableByteChannel(SeekableByteChannel seekableByteChannel) {
            this.seekableByteChannel = seekableByteChannel;
            return this;
        }

        public Builder setTryToRecoverBrokenArchives(boolean tryToRecoverBrokenArchives) {
            this.tryToRecoverBrokenArchives = tryToRecoverBrokenArchives;
            return this;
        }

        public Builder setUseDefaultNameForUnnamedEntries(boolean useDefaultNameForUnnamedEntries) {
            this.useDefaultNameForUnnamedEntries = useDefaultNameForUnnamedEntries;
            return this;
        }
    }

    private static final class ArchiveStatistics {
        private int numberOfPackedStreams;
        private long numberOfCoders;
        private long numberOfOutStreams;
        private long numberOfInStreams;
        private long numberOfUnpackSubStreams;
        private int numberOfFolders;
        private BitSet folderHasCrc;
        private int numberOfEntries;
        private int numberOfEntriesWithStream;

        private ArchiveStatistics() {
        }

        void assertValidity(int maxMemoryLimitKiB) throws IOException {
            if (this.numberOfEntriesWithStream > 0 && this.numberOfFolders == 0) {
                throw new ArchiveException("Archive with entries but no folders");
            }
            if ((long)this.numberOfEntriesWithStream > this.numberOfUnpackSubStreams) {
                throw new ArchiveException("Archive doesn't contain enough substreams for entries");
            }
            MemoryLimitException.checkKiB(SevenZFile.bytesToKiB(this.estimateSizeBytes()), maxMemoryLimitKiB);
        }

        private long bindPairSize() {
            return 16L;
        }

        private long coderSize() {
            return 22L;
        }

        private long entrySize() {
            return 100L;
        }

        long estimateSizeBytes() {
            long lowerBound = 16L * (long)this.numberOfPackedStreams + (long)(this.numberOfPackedStreams / 8) + (long)this.numberOfFolders * this.folderSize() + this.numberOfCoders * this.coderSize() + (this.numberOfOutStreams - (long)this.numberOfFolders) * this.bindPairSize() + 8L * (this.numberOfInStreams - this.numberOfOutStreams + (long)this.numberOfFolders) + 8L * this.numberOfOutStreams + (long)this.numberOfEntries * this.entrySize() + this.streamMapSize();
            return 2L * lowerBound;
        }

        private long folderSize() {
            return 30L;
        }

        private long streamMapSize() {
            return 8 * this.numberOfFolders + 8 * this.numberOfPackedStreams + 4 * this.numberOfEntries;
        }

        public String toString() {
            return String.format("Archive with %,d entries in %,d folders, estimated size %,d KiB.", this.numberOfEntries, this.numberOfFolders, SevenZFile.kbToKiB(this.estimateSizeBytes()));
        }
    }
}

