/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.sevenz;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.sevenz.BindPair;
import org.apache.commons.compress.archivers.sevenz.Coder;
import org.apache.commons.lang3.ArrayUtils;

final class Folder {
    static final Folder[] EMPTY_FOLDER_ARRAY = new Folder[0];
    Coder[] coders;
    long totalInputStreams;
    long totalOutputStreams;
    BindPair[] bindPairs;
    long[] packedStreams;
    long[] unpackSizes;
    boolean hasCrc;
    long crc;
    int numUnpackSubStreams;

    Folder() {
    }

    int findBindPairForInStream(long index) {
        if (this.bindPairs != null) {
            for (int i = 0; i < this.bindPairs.length; ++i) {
                if (this.bindPairs[i].inIndex != index) continue;
                return i;
            }
        }
        return -1;
    }

    int findBindPairForOutStream(long index) {
        if (this.bindPairs != null) {
            for (int i = 0; i < this.bindPairs.length; ++i) {
                if (this.bindPairs[i].outIndex != index) continue;
                return i;
            }
        }
        return -1;
    }

    Iterable<Coder> getOrderedCoders() throws IOException {
        if (ArrayUtils.isEmpty((long[])this.packedStreams) || ArrayUtils.isEmpty((Object[])this.coders)) {
            return Collections.emptyList();
        }
        LinkedList<Coder> list = new LinkedList<Coder>();
        long current = this.packedStreams[0];
        while (current >= 0L && current < (long)this.coders.length) {
            Coder curCoder = this.coders[ArchiveException.toIntExact(current)];
            if (list.contains(curCoder)) {
                throw new ArchiveException("Folder uses the same coder more than once in coder chain");
            }
            list.addLast(curCoder);
            int pair = this.findBindPairForOutStream(current);
            current = pair != -1 ? this.bindPairs[pair].inIndex : -1L;
        }
        return list;
    }

    long getUnpackSize() throws ArchiveException {
        if (this.totalOutputStreams == 0L) {
            return 0L;
        }
        for (long i = this.totalOutputStreams - 1L; i >= 0L; --i) {
            if (this.findBindPairForOutStream(i) >= 0) continue;
            return this.unpackSizes[ArchiveException.toIntExact(i)];
        }
        return 0L;
    }

    long getUnpackSizeForCoder(Coder coder) {
        if (this.coders != null) {
            for (int i = 0; i < this.coders.length; ++i) {
                if (this.coders[i] != coder) continue;
                return this.unpackSizes[i];
            }
        }
        return 0L;
    }

    public String toString() {
        return "Folder with " + this.coders.length + " coders, " + this.totalInputStreams + " input streams, " + this.totalOutputStreams + " output streams, " + this.bindPairs.length + " bind pairs, " + this.packedStreams.length + " packed streams, " + this.unpackSizes.length + " unpack sizes, " + (this.hasCrc ? "with CRC " + this.crc : "without CRC") + " and " + this.numUnpackSubStreams + " unpack streams";
    }
}

