/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.ar;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import org.apache.commons.compress.utils.ArchiveUtils;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.compress.utils.ParsingUtils;
import org.apache.commons.lang3.ArrayUtils;

public class ArArchiveInputStream
extends ArchiveInputStream<ArArchiveEntry> {
    private static final int NAME_OFFSET = 0;
    private static final int NAME_LEN = 16;
    private static final int LAST_MODIFIED_OFFSET = 16;
    private static final int LAST_MODIFIED_LEN = 12;
    private static final int USER_ID_OFFSET = 28;
    private static final int USER_ID_LEN = 6;
    private static final int GROUP_ID_OFFSET = 34;
    private static final int GROUP_ID_LEN = 6;
    private static final int FILE_MODE_OFFSET = 40;
    private static final int FILE_MODE_LEN = 8;
    private static final int LENGTH_OFFSET = 48;
    private static final int LENGTH_LEN = 10;
    static final String BSD_LONGNAME_PREFIX = "#1/";
    private static final int BSD_LONGNAME_PREFIX_LEN = "#1/".length();
    private static final Pattern BSD_LONGNAME_PATTERN = Pattern.compile("^#1/\\d+");
    private static final String GNU_STRING_TABLE_NAME = "//";
    private static final Pattern GNU_LONGNAME_PATTERN = Pattern.compile("^/\\d+");
    private boolean closed;
    private ArArchiveEntry currentEntry;
    private byte[] namebuffer;
    private long entryOffset = -1L;
    private final byte[] metaData = new byte[58];

    private static boolean isBSDLongName(String name) {
        return name != null && BSD_LONGNAME_PATTERN.matcher(name).matches();
    }

    private static boolean isGNUStringTable(ArArchiveEntry entry) {
        return GNU_STRING_TABLE_NAME.equals(entry.getName());
    }

    public static boolean matches(byte[] buffer, int ignored) {
        return ArrayUtils.startsWith((byte[])buffer, (byte[])ArArchiveEntry.HEADER_BYTES);
    }

    public ArArchiveInputStream(InputStream inputStream) {
        super(inputStream, StandardCharsets.US_ASCII.name());
    }

    private int asInt(byte[] byteArray, int offset, int len, boolean treatBlankAsZero) throws IOException {
        return this.asInt(byteArray, offset, len, 10, treatBlankAsZero);
    }

    private int asInt(byte[] byteArray, int offset, int len, int base) throws IOException {
        return this.asInt(byteArray, offset, len, base, false);
    }

    private int asInt(byte[] byteArray, int offset, int len, int base, boolean treatBlankAsZero) throws IOException {
        String string = ArchiveUtils.toAsciiString(byteArray, offset, len).trim();
        if (string.isEmpty() && treatBlankAsZero) {
            return 0;
        }
        return ParsingUtils.parseIntValue(string, base);
    }

    private long asLong(byte[] byteArray, int offset, int len) throws IOException {
        return ParsingUtils.parseLongValue(ArchiveUtils.toAsciiString(byteArray, offset, len).trim());
    }

    private void checkTrailer() throws IOException {
        byte[] expectedTrailer = ArchiveUtils.toAsciiBytes("`\n");
        byte[] actualTrailer = IOUtils.readRange(this.in, expectedTrailer.length);
        if (actualTrailer.length < expectedTrailer.length) {
            throw new EOFException(String.format("Premature end of ar archive: invalid or incomplete trailer for entry '%s'.", ArchiveUtils.toAsciiString(this.metaData, 0, 16).trim()));
        }
        this.count(actualTrailer.length);
        if (!Arrays.equals(expectedTrailer, actualTrailer)) {
            throw new ArchiveException("Invalid ar archive entry trailer: " + ArchiveUtils.toAsciiString(actualTrailer));
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.in.close();
        }
        this.currentEntry = null;
    }

    private String getBSDLongName(String bsdLongName) throws IOException {
        int nameLen = ParsingUtils.parseIntValue(bsdLongName.substring(BSD_LONGNAME_PREFIX_LEN));
        byte[] name = IOUtils.readRange(this.in, nameLen);
        int read = name.length;
        this.count(read);
        if (read != nameLen) {
            throw new EOFException(bsdLongName);
        }
        return ArchiveUtils.toAsciiString(name);
    }

    private String getExtendedName(int offset) throws IOException {
        if (this.namebuffer == null) {
            throw new ArchiveException("Cannot process GNU long file name as no GNU string table was found");
        }
        if (offset >= this.namebuffer.length) {
            throw new ArchiveException("GNU long file name offset out of range: " + offset);
        }
        for (int i = offset; i < this.namebuffer.length; ++i) {
            byte c = this.namebuffer[i];
            if (c != 10 && c != 0) continue;
            if (i > offset && this.namebuffer[i - 1] == 47) {
                --i;
            }
            if (i <= offset) break;
            return ArchiveUtils.toAsciiString(this.namebuffer, offset, i - offset);
        }
        throw new ArchiveException("Failed to read GNU long file name at offset " + offset);
    }

    @Deprecated
    public ArArchiveEntry getNextArEntry() throws IOException {
        return this.getNextEntry();
    }

    @Override
    public ArArchiveEntry getNextEntry() throws IOException {
        this.skipGlobalSignature();
        boolean foundGNUStringTable = false;
        do {
            byte[] headerBuf;
            if (this.currentEntry != null) {
                IOUtils.skip(this, Long.MAX_VALUE);
                this.skipRecordPadding();
            }
            if ((headerBuf = this.getRecord()) == null) {
                if (foundGNUStringTable) {
                    throw new EOFException("Premature end of ar archive: no regular entry after GNU string table.");
                }
                this.currentEntry = null;
                return null;
            }
            this.checkTrailer();
            this.currentEntry = this.parseEntry(headerBuf);
            this.entryOffset = this.getBytesRead();
            foundGNUStringTable = ArArchiveInputStream.isGNUStringTable(this.currentEntry);
            if (!foundGNUStringTable) continue;
            this.namebuffer = this.readGNUStringTable(this.currentEntry);
        } while (foundGNUStringTable);
        String name = this.currentEntry.getName();
        long len = this.currentEntry.getLength();
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        } else if (this.isGNULongName(name)) {
            int off = ParsingUtils.parseIntValue(name.substring(1));
            name = this.getExtendedName(off);
        } else if (ArArchiveInputStream.isBSDLongName(name)) {
            int nameLen = (name = this.getBSDLongName(name)).length();
            if ((long)nameLen > len) {
                throw new ArchiveException("Invalid BSD long name: file name length (" + nameLen + ") exceeds entry length (" + len + ")");
            }
            len -= (long)nameLen;
            this.entryOffset += (long)nameLen;
        }
        this.currentEntry = new ArArchiveEntry(name, len, this.currentEntry.getUserId(), this.currentEntry.getGroupId(), this.currentEntry.getMode(), this.currentEntry.getLastModified());
        return this.currentEntry;
    }

    private byte[] getRecord() throws IOException {
        int read = IOUtils.readFully(this.in, this.metaData);
        this.count(read);
        if (read == 0) {
            return null;
        }
        if (read < this.metaData.length) {
            throw new EOFException(String.format("Premature end of ar archive: incomplete entry header (expected %d bytes, got %d).", this.metaData.length, read));
        }
        return this.metaData;
    }

    private boolean isGNULongName(String name) {
        return name != null && GNU_LONGNAME_PATTERN.matcher(name).matches();
    }

    private ArArchiveEntry parseEntry(byte[] headerBuf) throws IOException {
        try {
            String name = ArchiveUtils.toAsciiString(headerBuf, 0, 16).trim();
            long length = this.asLong(headerBuf, 48, 10);
            if (GNU_STRING_TABLE_NAME.equals(name)) {
                return new ArArchiveEntry(name, length);
            }
            int userId = this.asInt(this.metaData, 28, 6, true);
            int groupId = this.asInt(this.metaData, 34, 6, true);
            int mode = this.asInt(this.metaData, 40, 8, 8);
            long lastModified = this.asLong(this.metaData, 16, 12);
            return new ArArchiveEntry(name, length, userId, groupId, mode, lastModified);
        }
        catch (IllegalArgumentException e) {
            throw new ArchiveException("Broken archive, entry with negative size", (Throwable)e);
        }
        catch (IOException e) {
            throw new ArchiveException("Failed to parse ar entry.", (Throwable)e);
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (this.currentEntry == null) {
            throw new IllegalStateException("No current ar entry");
        }
        long entryEnd = this.entryOffset + this.currentEntry.getLength();
        long offset = this.getBytesRead();
        if (len < 0 || offset >= entryEnd) {
            return -1;
        }
        int toRead = ArchiveException.toIntExact(Math.min((long)len, entryEnd - offset));
        int ret = this.in.read(b, off, toRead);
        if (ret < 0) {
            throw new EOFException(String.format("Premature end of ar archive: entry '%s' is truncated or incomplete.", this.currentEntry.getName()));
        }
        this.count(ret);
        return ret;
    }

    private byte[] readGNUStringTable(ArArchiveEntry entry) throws IOException {
        if (entry.getLength() > Integer.MAX_VALUE) {
            throw new ArchiveException("Invalid GNU string table entry size: " + entry.getLength());
        }
        int size = (int)entry.getLength();
        byte[] namebuffer = IOUtils.readRange(this.in, size);
        int read = namebuffer.length;
        if (read < size) {
            throw new EOFException("Premature end of ar archive: truncated or incomplete GNU string table.");
        }
        this.count(read);
        return namebuffer;
    }

    private void skipGlobalSignature() throws IOException {
        long offset = this.getBytesRead();
        if (offset == 0L) {
            byte[] expectedMagic = ArArchiveEntry.HEADER_BYTES;
            byte[] actualMagic = IOUtils.readRange(this.in, expectedMagic.length);
            this.count(actualMagic.length);
            if (expectedMagic.length != actualMagic.length) {
                throw new EOFException(String.format("Premature end of ar archive: incomplete global header (expected %d bytes, got %d).", expectedMagic.length, actualMagic.length));
            }
            if (!Arrays.equals(expectedMagic, actualMagic)) {
                throw new ArchiveException("Invalid global ar archive header: " + ArchiveUtils.toAsciiString(actualMagic));
            }
        }
    }

    private void skipRecordPadding() throws IOException {
        long offset = this.getBytesRead();
        if (offset % 2L != 0L) {
            int c = this.in.read();
            if (c < 0) {
                throw new EOFException(String.format("Premature end of ar archive: missing padding for entry '%s'.", this.currentEntry.getName()));
            }
            this.count(1);
        }
    }
}

