/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers;

import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.compress.CompressException;

public class ArchiveException
extends CompressException {
    private static final Function<Throwable, ArchiveException> E_FUNCTION = ArchiveException::new;
    private static final long serialVersionUID = 2772690708123267100L;

    public static int addExact(int x, int y) throws ArchiveException {
        try {
            return Math.addExact(x, y);
        }
        catch (ArithmeticException e) {
            throw new ArchiveException(e);
        }
    }

    public static int addExact(int x, long y) throws ArchiveException {
        return ArchiveException.addExact(x, y, E_FUNCTION);
    }

    public static long addExact(long x, long y) throws ArchiveException {
        try {
            return Math.addExact(x, y);
        }
        catch (ArithmeticException e) {
            throw new ArchiveException(e);
        }
    }

    public static <T> T requireNonNull(T obj, Supplier<String> messageSupplier) throws ArchiveException {
        return CompressException.requireNonNull(ArchiveException.class, obj, messageSupplier);
    }

    public static int toIntExact(long value) throws ArchiveException {
        try {
            return Math.toIntExact(value);
        }
        catch (ArithmeticException e) {
            throw new ArchiveException(e);
        }
    }

    public ArchiveException() {
    }

    public ArchiveException(String message) {
        super(message);
    }

    @Deprecated
    public ArchiveException(String message, Exception cause) {
        super(message, cause);
    }

    public ArchiveException(String message, Object ... args) {
        super(message, args);
    }

    public ArchiveException(String message, Throwable cause) {
        super(message, cause);
    }

    public ArchiveException(Throwable cause) {
        super(cause);
    }
}

