/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress;

import org.apache.commons.compress.CompressException;

public class MemoryLimitException
extends CompressException {
    private static final String MAXIMUM = "maximum";
    private static final String BYTES = "bytes";
    private static final String KIB = "KiB";
    private static final long serialVersionUID = 1L;
    private final long memoryNeededKiB;
    private final long memoryLimitKiB;

    private static String buildMessage(long memoryNeeded, long memoryLimit, String scale, String boundary) {
        return String.format("%,d %s of memory requested; %s set is %,d %s. If the file is not corrupt, consider increasing the memory limit.", memoryNeeded, scale, boundary, memoryLimit, scale);
    }

    private static long check(long request, long max, long memory, String memoryType, String scale) throws MemoryLimitException {
        MemoryLimitException.check(request, max, scale, MAXIMUM);
        MemoryLimitException.check(request, memory, scale, memoryType);
        return request;
    }

    private static void check(long request, long max, String scale, String boundary) throws MemoryLimitException {
        if (request > max) {
            throw new MemoryLimitException(request, max, scale, boundary);
        }
    }

    public static int checkBytes(int request, long max) throws MemoryLimitException {
        MemoryLimitException.check(request, max, Runtime.getRuntime().maxMemory(), "max memory", BYTES);
        return request;
    }

    public static long checkBytes(long request, long max) throws MemoryLimitException {
        MemoryLimitException.check(request, max, Runtime.getRuntime().maxMemory(), "max memory", BYTES);
        return request;
    }

    public static long checkKiB(long request, long max) throws MemoryLimitException {
        return MemoryLimitException.check(request, max, Runtime.getRuntime().maxMemory() / 1024L, "max memory", KIB);
    }

    public MemoryLimitException(long memoryNeededKiB, int memoryLimitKiB) {
        super(MemoryLimitException.buildMessage(memoryNeededKiB, memoryLimitKiB, KIB, MAXIMUM));
        this.memoryNeededKiB = memoryNeededKiB;
        this.memoryLimitKiB = memoryLimitKiB;
    }

    @Deprecated
    public MemoryLimitException(long memoryNeededKiB, int memoryLimitKiB, Exception cause) {
        super(MemoryLimitException.buildMessage(memoryNeededKiB, memoryLimitKiB, KIB, MAXIMUM), cause);
        this.memoryNeededKiB = memoryNeededKiB;
        this.memoryLimitKiB = memoryLimitKiB;
    }

    public MemoryLimitException(long memoryNeededKiB, int memoryLimitKiB, Throwable cause) {
        super(MemoryLimitException.buildMessage(memoryNeededKiB, memoryLimitKiB, KIB, MAXIMUM), cause);
        this.memoryNeededKiB = memoryNeededKiB;
        this.memoryLimitKiB = memoryLimitKiB;
    }

    public MemoryLimitException(long memoryNeededKiB, long memoryLimitKiB) {
        super(MemoryLimitException.buildMessage(memoryNeededKiB, memoryLimitKiB, KIB, MAXIMUM));
        this.memoryNeededKiB = memoryNeededKiB;
        this.memoryLimitKiB = memoryLimitKiB;
    }

    private MemoryLimitException(long memoryNeededKiB, long memoryLimitKiB, String scale, String boundary) {
        super(MemoryLimitException.buildMessage(memoryNeededKiB, memoryLimitKiB, scale, boundary));
        this.memoryNeededKiB = memoryNeededKiB;
        this.memoryLimitKiB = memoryLimitKiB;
    }

    public int getMemoryLimitInKb() {
        return Math.toIntExact(this.memoryLimitKiB);
    }

    public long getMemoryLimitInKiBLong() {
        return this.memoryLimitKiB;
    }

    public long getMemoryNeededInKb() {
        return this.memoryNeededKiB;
    }
}

