/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress;

import java.io.IOException;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.function.Suppliers;

public class CompressException
extends IOException {
    private static final long serialVersionUID = 1L;

    public static <E extends CompressException> int addExact(int x, long y, Function<Throwable, E> eFunction) throws E {
        try {
            return Math.addExact(x, Math.toIntExact(y));
        }
        catch (ArithmeticException e) {
            throw (CompressException)eFunction.apply(e);
        }
    }

    protected static <T, E extends Throwable> T requireNonNull(Class<? super E> cls, T obj, Supplier<String> messageSupplier) throws E {
        if (obj == null) {
            try {
                cls.getConstructor(String.class).newInstance(Suppliers.get(messageSupplier));
            }
            catch (ReflectiveOperationException | SecurityException e) {
                new CompressException((String)Suppliers.get(messageSupplier), e);
            }
        }
        return obj;
    }

    public CompressException() {
    }

    public CompressException(String message) {
        super(message);
    }

    public CompressException(String message, Object ... args) {
        super(String.format(message, args));
    }

    public CompressException(String message, Throwable cause) {
        super(message, cause);
    }

    public CompressException(Throwable cause) {
        super(cause);
    }
}

