/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.gzip;

import java.nio.charset.Charset;
import java.time.Instant;
import org.apache.commons.compress.compressors.gzip.ExtraField;
import org.apache.commons.compress.compressors.gzip.GzipUtils;
import org.apache.commons.io.Charsets;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class GzipParameters {
    private static final int OS_FAT = 0;
    private static final int OS_AMIGA = 1;
    private static final int OS_VMS = 2;
    private static final int OS_UNIX = 3;
    private static final int OS_VM_CMS = 4;
    private static final int OS_ATARI_TOS = 5;
    private static final int OS_HPFS = 6;
    private static final int OS_MACINTOSH = 7;
    private static final int OS_Z_SYSTEM = 8;
    private static final int OS_CPM = 9;
    private static final int OS_TOPS_20 = 10;
    private static final int OS_NTFS = 11;
    private static final int OS_QDOS = 12;
    private static final int OS_ACORN_RISCOS = 13;
    private static final int OS_UNKNOWN = 255;
    private int compressionLevel = -1;
    private Instant modificationInstant = Instant.EPOCH;
    private ExtraField extraField;
    private String fileName;
    private Charset fileNameCharset = GzipUtils.GZIP_ENCODING;
    private String comment;
    private OS operatingSystem = OS.UNKNOWN;
    private int bufferSize = 512;
    private int deflateStrategy = 0;
    private boolean headerCRC;

    public int getBufferSize() {
        return this.bufferSize;
    }

    public String getComment() {
        return this.comment;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public int getDeflateStrategy() {
        return this.deflateStrategy;
    }

    public ExtraField getExtraField() {
        return this.extraField;
    }

    @Deprecated
    public String getFilename() {
        return this.fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Charset getFileNameCharset() {
        return this.fileNameCharset;
    }

    public boolean getHeaderCRC() {
        return this.headerCRC;
    }

    public Instant getModificationInstant() {
        return this.modificationInstant;
    }

    public long getModificationTime() {
        return this.modificationInstant.getEpochSecond();
    }

    public int getOperatingSystem() {
        return this.operatingSystem.type;
    }

    public OS getOS() {
        return this.operatingSystem;
    }

    private String requireNonNulByte(String text) {
        if (StringUtils.isNotEmpty((CharSequence)text) && ArrayUtils.contains((byte[])text.getBytes(this.fileNameCharset), (byte)0)) {
            throw new IllegalArgumentException("String encoded in Charset '" + this.fileNameCharset + "' contains the nul byte 0 which is not supported in gzip.");
        }
        return text;
    }

    public void setBufferSize(int bufferSize) {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("invalid buffer size: " + bufferSize);
        }
        this.bufferSize = bufferSize;
    }

    public void setComment(String comment) {
        this.comment = this.requireNonNulByte(comment);
    }

    public void setCompressionLevel(int compressionLevel) {
        if (compressionLevel < -1 || compressionLevel > 9) {
            throw new IllegalArgumentException("Invalid gzip compression level: " + compressionLevel);
        }
        this.compressionLevel = compressionLevel;
    }

    public void setDeflateStrategy(int deflateStrategy) {
        this.deflateStrategy = deflateStrategy;
    }

    public void setExtraField(ExtraField extra) {
        this.extraField = extra;
    }

    @Deprecated
    public void setFilename(String fileName) {
        this.setFileName(fileName);
    }

    public void setFileName(String fileName) {
        this.fileName = this.requireNonNulByte(fileName);
    }

    public void setFileNameCharset(Charset charset) {
        this.fileNameCharset = Charsets.toCharset((Charset)charset, (Charset)GzipUtils.GZIP_ENCODING);
    }

    public void setHeaderCRC(boolean headerCRC) {
        this.headerCRC = headerCRC;
    }

    public void setModificationInstant(Instant modificationTime) {
        this.modificationInstant = modificationTime != null ? modificationTime : Instant.EPOCH;
    }

    public void setModificationTime(long modificationTimeSeconds) {
        this.modificationInstant = Instant.ofEpochSecond(modificationTimeSeconds);
    }

    public void setOperatingSystem(int operatingSystem) {
        this.operatingSystem = OS.from(operatingSystem);
    }

    public void setOS(OS os) {
        this.operatingSystem = os != null ? os : OS.UNKNOWN;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GzipParameters [compressionLevel=").append(this.compressionLevel).append(", modificationTime=").append(this.modificationInstant).append(", fileName=").append(this.fileName).append(", comment=").append(this.comment).append(", operatingSystem=").append((Object)this.operatingSystem).append(", bufferSize=").append(this.bufferSize).append(", deflateStrategy=").append(this.deflateStrategy).append("]");
        return builder.toString();
    }

    public static enum OS {
        FAT(0),
        AMIGA(1),
        VMS(2),
        UNIX(3),
        VM_CMS(4),
        ATARI_TOS(5),
        HPFS(6),
        MACINTOSH(7),
        Z_SYSTEM(8),
        CPM(9),
        TOPS_20(10),
        NTFS(11),
        QDOS(12),
        ACORN_RISCOS(13),
        UNKNOWN(255);

        private final int type;

        public static OS from(int code) {
            switch (code) {
                case 13: {
                    return ACORN_RISCOS;
                }
                case 1: {
                    return AMIGA;
                }
                case 5: {
                    return ATARI_TOS;
                }
                case 9: {
                    return CPM;
                }
                case 0: {
                    return FAT;
                }
                case 6: {
                    return HPFS;
                }
                case 7: {
                    return MACINTOSH;
                }
                case 11: {
                    return NTFS;
                }
                case 12: {
                    return QDOS;
                }
                case 10: {
                    return TOPS_20;
                }
                case 3: {
                    return UNIX;
                }
                case 255: {
                    return UNKNOWN;
                }
                case 4: {
                    return VM_CMS;
                }
                case 2: {
                    return VMS;
                }
                case 8: {
                    return Z_SYSTEM;
                }
            }
            return UNKNOWN;
        }

        private OS(int type) {
            this.type = type;
        }

        public int type() {
            return this.type;
        }
    }
}

