/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Objects;
import java.util.function.IntPredicate;
import java.util.function.LongPredicate;
import org.apache.commons.collections4.bloomfilter.BitMapExtractor;
import org.apache.commons.collections4.bloomfilter.IndexUtils;

@FunctionalInterface
public interface IndexExtractor {
    public static IndexExtractor fromBitMapExtractor(BitMapExtractor bitMapExtractor) {
        Objects.requireNonNull(bitMapExtractor, "bitMapExtractor");
        return consumer -> {
            LongPredicate longPredicate = new LongPredicate(){
                int wordIdx;

                @Override
                public boolean test(long word) {
                    int i = this.wordIdx;
                    while (word != 0L) {
                        if ((word & 1L) == 1L && !consumer.test(i)) {
                            return false;
                        }
                        word >>>= 1;
                        ++i;
                    }
                    this.wordIdx += 64;
                    return true;
                }
            };
            return bitMapExtractor.processBitMaps(longPredicate::test);
        };
    }

    public static IndexExtractor fromIndexArray(final int ... values) {
        return new IndexExtractor(){

            @Override
            public int[] asIndexArray() {
                return (int[])values.clone();
            }

            @Override
            public boolean processIndices(IntPredicate predicate) {
                for (int value : values) {
                    if (predicate.test(value)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    default public int[] asIndexArray() {
        final class Indices {
            private int[] data = new int[32];
            private int size;

            Indices() {
            }

            boolean add(int index) {
                this.data = IndexUtils.ensureCapacityForAdd(this.data, this.size);
                this.data[this.size++] = index;
                return true;
            }

            int[] toArray() {
                return this.size == this.data.length ? this.data : Arrays.copyOf(this.data, this.size);
            }
        }
        Indices indices = new Indices();
        this.processIndices(indices::add);
        return indices.toArray();
    }

    public boolean processIndices(IntPredicate var1);

    default public IndexExtractor uniqueIndices() {
        final BitSet bitSet = new BitSet();
        this.processIndices(i -> {
            bitSet.set(i);
            return true;
        });
        return new IndexExtractor(){

            @Override
            public boolean processIndices(IntPredicate predicate) {
                int idx = bitSet.nextSetBit(0);
                while (idx >= 0) {
                    if (!predicate.test(idx)) {
                        return false;
                    }
                    idx = bitSet.nextSetBit(idx + 1);
                }
                return true;
            }

            @Override
            public IndexExtractor uniqueIndices() {
                return this;
            }
        };
    }
}

