/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.multimap;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.Bag;
import org.apache.commons.collections4.Factory;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.bag.HashBag;
import org.apache.commons.collections4.functors.InstantiateFactory;
import org.apache.commons.collections4.iterators.EmptyIterator;
import org.apache.commons.collections4.iterators.IteratorChain;
import org.apache.commons.collections4.iterators.LazyIteratorChain;
import org.apache.commons.collections4.iterators.TransformIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractMultiValuedMap<K, V>
implements MultiValuedMap<K, V>,
Serializable {
    private static final long serialVersionUID = 7994988366330224277L;
    private final Factory<? extends Collection<V>> collectionFactory;
    private transient Collection<V> valuesView;
    private transient EntryValues entryValuesView;
    private transient KeysBag keysBagView;
    private final Map<K, Collection<V>> map;

    protected <C extends Collection<V>> AbstractMultiValuedMap(Map<K, ? super C> map, Class<C> collectionClazz) {
        if (map == null) {
            throw new IllegalArgumentException("Map must not be null");
        }
        this.map = map;
        this.collectionFactory = new InstantiateFactory<C>(collectionClazz);
    }

    protected Map<K, Collection<V>> getMap() {
        return this.map;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getMap().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        Set<Map.Entry<K, Collection<V>>> pairs = this.getMap().entrySet();
        if (pairs != null) {
            for (Map.Entry<K, Collection<V>> entry : pairs) {
                if (!entry.getValue().contains(value)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsMapping(Object key, Object value) {
        Collection<V> col = this.get(key);
        if (col == null) {
            return false;
        }
        return col.contains(value);
    }

    @Override
    public Collection<Map.Entry<K, V>> entries() {
        return this.entryValuesView != null ? this.entryValuesView : (this.entryValuesView = new EntryValues());
    }

    @Override
    public Collection<V> get(Object key) {
        return this.getMap().get(key);
    }

    @Override
    public Collection<V> remove(Object key) {
        return this.getMap().remove(key);
    }

    @Override
    public boolean removeMapping(K key, V item) {
        boolean result = false;
        Collection<V> col = this.get(key);
        if (col == null) {
            return false;
        }
        result = col.remove(item);
        if (!result) {
            return false;
        }
        if (col.isEmpty()) {
            this.remove(key);
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.getMap().isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.getMap().keySet();
    }

    @Override
    public int size() {
        int size = 0;
        for (Collection<V> col : this.getMap().values()) {
            size += col.size();
        }
        return size;
    }

    @Override
    public Collection<V> values() {
        Values vs = this.valuesView;
        return vs != null ? vs : (this.valuesView = new Values());
    }

    @Override
    public void clear() {
        this.getMap().clear();
    }

    @Override
    public V put(K key, V value) {
        boolean result = false;
        Collection<V> coll = this.get(key);
        if (coll == null) {
            coll = this.createCollection();
            coll.add(value);
            if (coll.size() > 0) {
                this.getMap().put(key, coll);
                result = true;
            }
        } else {
            result = coll.add(value);
        }
        return (V)(result ? value : null);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        if (map != null) {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public void putAll(MultiValuedMap<? extends K, ? extends V> map) {
        if (map != null) {
            for (K key : map.keySet()) {
                this.putAll(key, map.get(key));
            }
        }
    }

    @Override
    public Bag<K> keys() {
        return this.keysBagView != null ? this.keysBagView : (this.keysBagView = new KeysBag());
    }

    @Override
    public boolean putAll(K key, Iterable<? extends V> values) {
        if (values == null || values.iterator() == null || !values.iterator().hasNext()) {
            return false;
        }
        Iterator<V> it = values.iterator();
        boolean result = false;
        Collection<V> coll = this.get(key);
        if (coll == null) {
            coll = this.createCollection();
            while (it.hasNext()) {
                coll.add(it.next());
            }
            if (coll.size() > 0) {
                this.getMap().put(key, coll);
                result = true;
            }
        } else {
            while (it.hasNext()) {
                boolean tmpResult = coll.add(it.next());
                if (result || !tmpResult) continue;
                result = true;
            }
        }
        return result;
    }

    public Iterator<V> iterator(Object key) {
        if (!this.containsKey(key)) {
            return EmptyIterator.emptyIterator();
        }
        return new ValuesIterator(key);
    }

    public int size(Object key) {
        Collection<V> coll = this.get(key);
        if (coll == null) {
            return 0;
        }
        return coll.size();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiValuedMap)) {
            return false;
        }
        MultiValuedMap other = (MultiValuedMap)obj;
        if (other.size() != this.size()) {
            return false;
        }
        for (K key : this.keySet()) {
            Collection<V> col = this.get(key);
            Collection otherCol = other.get(key);
            if (otherCol == null) {
                return false;
            }
            if (col.size() != otherCol.size()) {
                return false;
            }
            for (V value : col) {
                if (otherCol.contains(value)) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return ((Object)this.getMap()).hashCode();
    }

    public String toString() {
        return this.getMap().toString();
    }

    protected Collection<V> createCollection() {
        return this.collectionFactory.create();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValuesIterator
    implements Iterator<V> {
        private final Object key;
        private final Collection<V> values;
        private final Iterator<V> iterator;

        public ValuesIterator(Object key) {
            this.key = key;
            this.values = AbstractMultiValuedMap.this.get(key);
            this.iterator = this.values.iterator();
        }

        @Override
        public void remove() {
            this.iterator.remove();
            if (this.values.isEmpty()) {
                AbstractMultiValuedMap.this.remove(this.key);
            }
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public V next() {
            return this.iterator.next();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            IteratorChain chain = new IteratorChain();
            for (Object k : AbstractMultiValuedMap.this.keySet()) {
                chain.addIterator(new ValuesIterator(k));
            }
            return chain;
        }

        @Override
        public int size() {
            return AbstractMultiValuedMap.this.size();
        }

        @Override
        public void clear() {
            AbstractMultiValuedMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryValues
    extends AbstractCollection<Map.Entry<K, V>> {
        private EntryValues() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new LazyIteratorChain<Map.Entry<K, V>>(){
                final Collection<K> keysCol;
                final Iterator<K> keyIterator;
                {
                    this.keysCol = new ArrayList(AbstractMultiValuedMap.this.getMap().keySet());
                    this.keyIterator = this.keysCol.iterator();
                }

                @Override
                protected Iterator<? extends Map.Entry<K, V>> nextIterator(int count) {
                    if (!this.keyIterator.hasNext()) {
                        return null;
                    }
                    final Object key = this.keyIterator.next();
                    Transformer entryTransformer = new Transformer<V, Map.Entry<K, V>>(){

                        @Override
                        public Map.Entry<K, V> transform(final V input) {
                            return new Map.Entry<K, V>(){

                                @Override
                                public K getKey() {
                                    return key;
                                }

                                @Override
                                public V getValue() {
                                    return input;
                                }

                                @Override
                                public V setValue(V value) {
                                    throw new UnsupportedOperationException();
                                }
                            };
                        }
                    };
                    return new TransformIterator(new ValuesIterator(key), entryTransformer);
                }
            };
        }

        @Override
        public int size() {
            return AbstractMultiValuedMap.this.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeysBag
    implements Bag<K> {
        private KeysBag() {
        }

        @Override
        public boolean addAll(Collection<? extends K> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            return AbstractMultiValuedMap.this.getMap().containsKey(o);
        }

        @Override
        public boolean isEmpty() {
            return AbstractMultiValuedMap.this.getMap().isEmpty();
        }

        @Override
        public Object[] toArray() {
            Object[] result = new Object[this.size()];
            int i = 0;
            for (Object current : AbstractMultiValuedMap.this.getMap().keySet()) {
                for (int index = this.getCount(current); index > 0; --index) {
                    result[i++] = current;
                }
            }
            return result;
        }

        @Override
        public <T> T[] toArray(T[] array) {
            int size = this.size();
            if (array.length < size) {
                Object[] unchecked = (Object[])Array.newInstance(array.getClass().getComponentType(), size);
                array = unchecked;
            }
            int i = 0;
            for (Object current : AbstractMultiValuedMap.this.getMap().keySet()) {
                for (int index = this.getCount(current); index > 0; --index) {
                    Object unchecked = current;
                    array[i++] = unchecked;
                }
            }
            while (i < array.length) {
                array[i++] = null;
            }
            return array;
        }

        @Override
        public int getCount(Object object) {
            int count = 0;
            Collection col = AbstractMultiValuedMap.this.getMap().get(object);
            if (col != null) {
                count = col.size();
            }
            return count;
        }

        @Override
        public boolean add(K object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(K object, int nCopies) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object object, int nCopies) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<K> uniqueSet() {
            return AbstractMultiValuedMap.this.keySet();
        }

        @Override
        public int size() {
            return AbstractMultiValuedMap.this.size();
        }

        @Override
        public boolean containsAll(Collection<?> coll) {
            if (coll instanceof Bag) {
                return this.containsAll((Bag)coll);
            }
            return this.containsAll(new HashBag(coll));
        }

        @Override
        private boolean containsAll(Bag<?> other) {
            for (Object current : other.uniqueSet()) {
                if (this.getCount(current) >= other.getCount(current)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean removeAll(Collection<?> coll) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> coll) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<K> iterator() {
            return new LazyIteratorChain<K>(){
                final Iterator<K> keyIterator;
                {
                    this.keyIterator = AbstractMultiValuedMap.this.getMap().keySet().iterator();
                }

                @Override
                protected Iterator<? extends K> nextIterator(int count) {
                    if (!this.keyIterator.hasNext()) {
                        return null;
                    }
                    final Object key = this.keyIterator.next();
                    final Iterator colIterator = AbstractMultiValuedMap.this.getMap().get(key).iterator();
                    Iterator nextIt = new Iterator<K>(){

                        @Override
                        public boolean hasNext() {
                            return colIterator.hasNext();
                        }

                        @Override
                        public K next() {
                            colIterator.next();
                            return key;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                    return nextIt;
                }
            };
        }
    }
}

