/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.rest.jaxrs.container;

import com.sun.jersey.api.core.DefaultResourceConfig;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.spi.container.WebApplication;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public class CocoonJAXRSServlet
extends ServletContainer {
    private static final long serialVersionUID = -8658985429213333769L;
    private static final Logger LOG = LoggerFactory.getLogger(CocoonJAXRSServlet.class);
    private boolean lazyInit;
    private ResourceConfig rc;
    private List<Object> restResourcesList;
    private Map<Object, Object> restResourcesMap;
    private WebApplication wa;

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.lazyInit) {
            this.lazyInitiate();
        }
        super.service(request, response);
    }

    public void setRestResourcesMap(Map<Object, Object> restResourcesMap) {
        this.restResourcesMap = restResourcesMap;
    }

    public void setRestResourcesList(List<Object> restResourcesList) {
        this.restResourcesList = restResourcesList;
    }

    protected ResourceConfig getDefaultResourceConfig(Map<String, Object> props, ServletConfig servletConfig) throws ServletException {
        DefaultResourceConfig rc = new DefaultResourceConfig();
        rc.setPropertiesAndFeatures(props);
        return rc;
    }

    protected void initiate(ResourceConfig rc, WebApplication wa) {
        this.rc = rc;
        this.wa = wa;
    }

    private synchronized void lazyInitiate() {
        if (this.lazyInit) {
            return;
        }
        ArrayList<Object> restResources = new ArrayList<Object>();
        if (this.restResourcesMap != null) {
            restResources.addAll(this.restResourcesMap.values());
        }
        if (this.restResourcesList != null) {
            restResources.addAll(this.restResourcesList);
        }
        for (Object e : restResources) {
            Class type = ClassUtils.getUserClass(e);
            if (ResourceConfig.isProviderClass((Class)type)) {
                LOG.info("Registering Spring bean of type " + type.getName() + " as a provider class");
                this.rc.getSingletons().add(e);
                continue;
            }
            if (!ResourceConfig.isRootResourceClass((Class)type)) continue;
            LOG.info("Registering Spring bean of type " + type.getName() + " as a root resource class");
            this.rc.getSingletons().add(e);
        }
        this.wa.initiate(this.rc);
        this.lazyInit = true;
    }
}

