/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.rest.controller.response;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.cocoon.pipeline.util.URLConnectionUtils;
import org.apache.cocoon.rest.controller.response.RestResponse;
import org.apache.cocoon.rest.controller.response.RestResponseMetaData;
import org.apache.cocoon.servlet.controller.ControllerContextHelper;
import org.apache.commons.io.IOUtils;

public class URLResponse
implements RestResponse {
    private Map<String, Object> data;
    private URLConnection servletConnection;
    private URL url;

    public URLResponse(String url) throws MalformedURLException {
        this.url = new URL(new URL("servlet:"), url);
        this.data = Collections.emptyMap();
    }

    public URLResponse(String url, Map<String, Object> data) throws MalformedURLException {
        this.url = new URL(new URL("servlet:"), url);
        this.data = data;
    }

    public URLResponse(URL url) {
        this.url = url;
        this.data = Collections.emptyMap();
    }

    public URLResponse(URL url, Map<String, Object> data) {
        this.url = url;
        this.data = data;
    }

    @Override
    public void execute(OutputStream outputStream) throws Exception {
        IOUtils.copy((InputStream)this.servletConnection.getInputStream(), (OutputStream)outputStream);
    }

    public Map<String, Object> getData() {
        if (this.data == null) {
            this.data = new HashMap<String, Object>();
        }
        return this.data;
    }

    public URL getUrl() {
        return this.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestResponseMetaData setup(Map<String, Object> inputParameters) throws Exception {
        this.servletConnection = null;
        try {
            ControllerContextHelper.storeContext(this.data, inputParameters);
            this.servletConnection = this.url.openConnection();
            RestResponseMetaData restResponseMetaData = new RestResponseMetaData();
            if (this.servletConnection instanceof HttpURLConnection) {
                HttpURLConnection httpURLConnection = (HttpURLConnection)this.servletConnection;
                restResponseMetaData.setStatusCode(httpURLConnection.getResponseCode());
            }
            restResponseMetaData.setContentType(this.servletConnection.getContentType());
            RestResponseMetaData restResponseMetaData2 = restResponseMetaData;
            return restResponseMetaData2;
        }
        finally {
            URLConnectionUtils.closeQuietly((URLConnection)this.servletConnection);
        }
    }
}

