/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.rest.controller.response;

import java.io.OutputStream;
import java.util.Map;
import org.apache.cocoon.rest.controller.response.RestResponse;
import org.apache.cocoon.rest.controller.response.RestResponseMetaData;
import org.apache.commons.io.IOUtils;

public class TextResponse
implements RestResponse {
    private String data;
    private String contentType;
    private int statusCode = 200;
    private String charset;

    public TextResponse(String data, String contentType) {
        this.data = data;
        this.contentType = contentType;
    }

    public TextResponse(String data, String contentType, int statusCode) {
        this.data = data;
        this.contentType = contentType;
        this.statusCode = statusCode;
    }

    @Override
    public RestResponseMetaData setup(Map<String, Object> inputParameters) throws Exception {
        RestResponseMetaData restResponseMetaData = new RestResponseMetaData();
        restResponseMetaData.setStatusCode(this.statusCode);
        restResponseMetaData.setContentType(this.contentType);
        return restResponseMetaData;
    }

    @Override
    public void execute(OutputStream outputStream) throws Exception {
        if (this.charset == null) {
            IOUtils.write((String)this.data, (OutputStream)outputStream);
        } else {
            IOUtils.write((String)this.data, (OutputStream)outputStream, (String)this.charset);
        }
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }
}

