/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.rest.controller.response;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.cocoon.rest.controller.response.RestResponse;
import org.apache.cocoon.rest.controller.response.RestResponseMetaData;
import org.apache.commons.io.IOUtils;

public class BinaryResponse
implements RestResponse {
    private String contentType;
    private int statusCode = 200;
    private InputStream stream;

    public BinaryResponse(InputStream stream, String contentType) {
        this.stream = stream;
        this.contentType = contentType;
    }

    public BinaryResponse(InputStream stream, String contentType, int statusCode) {
        this.stream = stream;
        this.contentType = contentType;
        this.statusCode = statusCode;
    }

    @Override
    public void execute(OutputStream outputStream) throws Exception {
        IOUtils.copy((InputStream)this.stream, (OutputStream)outputStream);
    }

    @Override
    public RestResponseMetaData setup(Map<String, Object> inputParameters) throws Exception {
        RestResponseMetaData restResponseMetaData = new RestResponseMetaData();
        restResponseMetaData.setStatusCode(this.statusCode);
        restResponseMetaData.setContentType(this.contentType);
        return restResponseMetaData;
    }
}

