/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.rest.controller;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cocoon.callstack.CallStack;
import org.apache.cocoon.configuration.Settings;
import org.apache.cocoon.controller.Controller;
import org.apache.cocoon.pipeline.caching.CacheKey;
import org.apache.cocoon.rest.controller.IllegalFieldAnnotationException;
import org.apache.cocoon.rest.controller.MethodDelegator;
import org.apache.cocoon.rest.controller.NonPrototypeControllerException;
import org.apache.cocoon.rest.controller.UnknownControllerException;
import org.apache.cocoon.rest.controller.annotation.BaseURL;
import org.apache.cocoon.rest.controller.annotation.Inject;
import org.apache.cocoon.rest.controller.annotation.RequestHeader;
import org.apache.cocoon.rest.controller.annotation.RequestParameter;
import org.apache.cocoon.rest.controller.annotation.SitemapParameter;
import org.apache.cocoon.rest.controller.method.ConditionalGet;
import org.apache.cocoon.rest.controller.response.RestResponse;
import org.apache.cocoon.rest.controller.response.RestResponseMetaData;
import org.apache.cocoon.rest.controller.util.AnnotationCollector;
import org.apache.cocoon.servlet.collector.ResponseHeaderCollector;
import org.apache.cocoon.servlet.util.HttpContextHelper;
import org.apache.cocoon.servlet.util.SettingsHelper;
import org.apache.cocoon.sitemap.util.ExceptionHandler;
import org.apache.cocoon.sitemap.util.SpringProxyHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringRESTController
implements Controller,
ApplicationContextAware {
    private static final String REST_RESPONSE_KEY = SpringRESTController.class.getName() + "/rest-response";
    private static final String CACHE_KEY_KEY = SpringRESTController.class.getName() + "/cache-key";
    private AnnotationCollector annotationCollector;
    private ApplicationContext applicationContext;
    private MethodDelegator methodDelegator;

    private static void storeCacheKey(CacheKey cacheKey) {
        CallStack.getCurrentFrame().setAttribute(CACHE_KEY_KEY, (Object)cacheKey);
    }

    private static CacheKey readCacheKey() {
        return (CacheKey)CallStack.getCurrentFrame().getAttribute(CACHE_KEY_KEY);
    }

    private static void storeRestResponse(RestResponse restResponse) {
        CallStack.getCurrentFrame().setAttribute(REST_RESPONSE_KEY, (Object)restResponse);
    }

    private static RestResponse readRestResponse() {
        return (RestResponse)CallStack.getCurrentFrame().getAttribute(REST_RESPONSE_KEY);
    }

    public CacheKey getCacheKey() {
        return SpringRESTController.readCacheKey();
    }

    public void setup(String controllerName, Map<String, Object> inputParameters, Map<String, ? extends Object> configuration) {
        this.validateControllerBean(controllerName);
        try {
            Object controller = this.getController(controllerName, inputParameters, configuration);
            HttpServletRequest request = HttpContextHelper.getRequest(inputParameters);
            RestResponse restResponse = this.methodDelegator.delegate(request, controller);
            if (controller instanceof ConditionalGet) {
                SpringRESTController.storeCacheKey(((ConditionalGet)controller).constructCacheKey());
            }
            RestResponseMetaData restResponseMetaData = restResponse.setup(inputParameters);
            ResponseHeaderCollector.setStatusCode((int)restResponseMetaData.getStatusCode());
            ResponseHeaderCollector.setMimeType((String)restResponseMetaData.getContentType());
            SpringRESTController.storeRestResponse(restResponse);
        }
        catch (Exception e) {
            throw ExceptionHandler.getInvocationException((Throwable)e);
        }
    }

    private void validateControllerBean(String controllerName) {
        if (!this.applicationContext.containsBean(controllerName)) {
            throw new UnknownControllerException("Requested REST controller '" + controllerName + "' is not defined within the Spring application context.");
        }
        if (!this.applicationContext.isPrototype(controllerName)) {
            throw new NonPrototypeControllerException("Requested REST controller '" + controllerName + "' is not defined within the 'prototype' scope.");
        }
    }

    public void execute(OutputStream outputStream) {
        try {
            SpringRESTController.readRestResponse().execute(outputStream);
        }
        catch (Exception e) {
            throw ExceptionHandler.getInvocationException((Throwable)e);
        }
    }

    public void setAnnotationCollector(AnnotationCollector annotationCollector) {
        this.annotationCollector = annotationCollector;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setMethodDelegator(MethodDelegator methodDelegator) {
        this.methodDelegator = methodDelegator;
    }

    private Object getController(String controllerName, Map<String, Object> inputParameters, Map<String, ? extends Object> configuration) throws IllegalAccessException, IOException {
        Object controller = this.applicationContext.getBean(controllerName);
        Object unpackedController = SpringProxyHelper.unpackProxy((Object)controller);
        Map<Class<? extends Annotation>, List<Field>> annotatedFields = this.annotationCollector.getAnnotatedFields(unpackedController.getClass());
        SpringRESTController.populateInjectFields(inputParameters, unpackedController, annotatedFields);
        SpringRESTController.populateRequestFields(inputParameters, unpackedController, annotatedFields);
        SpringRESTController.populateRequestHeaderFields(inputParameters, unpackedController, annotatedFields);
        SpringRESTController.populateSitemapParameterFields(configuration, unpackedController, annotatedFields);
        SpringRESTController.populateBaseURLFields(configuration, unpackedController, annotatedFields);
        return controller;
    }

    private static boolean isBlank(String string) {
        if (string == null) {
            return true;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static void populateBaseURLFields(Map<String, ? extends Object> configuration, Object controller, Map<Class<? extends Annotation>, List<Field>> annotatedFields) throws IllegalAccessException {
        List<Field> baseURLFields = annotatedFields.get(BaseURL.class);
        if (baseURLFields == null || baseURLFields.isEmpty()) {
            return;
        }
        for (Field field : baseURLFields) {
            SpringRESTController.populateBaseURLField(configuration, controller, field);
        }
    }

    private static void populateBaseURLField(Map<String, ? extends Object> configuration, Object controller, Field field) throws IllegalAccessException {
        field.setAccessible(true);
        Class<?> fieldType = field.getType();
        if (fieldType == URL.class) {
            field.set(controller, configuration.get("baseUrl"));
        } else {
            SpringRESTController.throwIllegalFieldAnnotationException(BaseURL.class, field, URL.class);
        }
    }

    private static void populateInjectFields(Map<String, ? extends Object> parameters, Object controller, Map<Class<? extends Annotation>, List<Field>> annotatedFields) throws IllegalAccessException, IOException {
        List<Field> injectFields = annotatedFields.get(Inject.class);
        if (injectFields == null || injectFields.isEmpty()) {
            return;
        }
        for (Field field : injectFields) {
            SpringRESTController.populateInjectField(parameters, controller, field);
        }
    }

    private static void populateInjectField(Map<String, ? extends Object> parameters, Object controller, Field field) throws IllegalAccessException, IOException {
        field.setAccessible(true);
        Class<?> fieldType = field.getType();
        if (fieldType == HttpServletRequest.class) {
            HttpServletRequest request = HttpContextHelper.getRequest(parameters);
            field.set(controller, request);
        } else if (fieldType == HttpServletResponse.class) {
            HttpServletResponse response = HttpContextHelper.getResponse(parameters);
            field.set(controller, response);
        } else if (fieldType == Logger.class) {
            field.set(controller, LoggerFactory.getLogger(controller.getClass()));
        } else if (fieldType == ServletInputStream.class || fieldType == InputStream.class) {
            HttpServletRequest request = HttpContextHelper.getRequest(parameters);
            field.set(controller, request.getInputStream());
        } else if (fieldType == ServletOutputStream.class || fieldType == OutputStream.class) {
            HttpServletResponse response = HttpContextHelper.getResponse(parameters);
            field.set(controller, response.getOutputStream());
        } else if (fieldType == ServletContext.class) {
            ServletContext servletContext = HttpContextHelper.getServletContext(parameters);
            field.set(controller, servletContext);
        } else if (fieldType == Settings.class) {
            Settings settings = SettingsHelper.getSettings(parameters);
            field.set(controller, settings);
        } else {
            SpringRESTController.throwIllegalFieldAnnotationException(Inject.class, field, HttpServletRequest.class, HttpServletResponse.class, Logger.class, ServletInputStream.class, InputStream.class, ServletOutputStream.class, OutputStream.class, ServletContext.class, Settings.class);
        }
    }

    private static void populateRequestFields(Map<String, ? extends Object> parameters, Object controller, Map<Class<? extends Annotation>, List<Field>> annotatedFields) throws IllegalAccessException {
        List<Field> requestFields = annotatedFields.get(RequestParameter.class);
        if (requestFields == null || requestFields.isEmpty()) {
            return;
        }
        for (Field field : requestFields) {
            SpringRESTController.populateRequestField(parameters, controller, field);
        }
    }

    private static void populateRequestField(Map<String, ? extends Object> parameters, Object controller, Field field) throws IllegalAccessException {
        Class<?> fieldType;
        field.setAccessible(true);
        HttpServletRequest request = HttpContextHelper.getRequest(parameters);
        String requestParameterName = field.getAnnotation(RequestParameter.class).value();
        if (SpringRESTController.isBlank(requestParameterName)) {
            requestParameterName = field.getName();
        }
        if ((fieldType = field.getType()) == String.class) {
            String parameter = request.getParameter(requestParameterName);
            if (parameter != null) {
                field.set(controller, parameter);
            }
        } else if (fieldType == Integer.TYPE) {
            String parameter = request.getParameter(requestParameterName);
            if (parameter != null) {
                field.set(controller, Integer.parseInt(parameter));
            }
        } else if (fieldType == Boolean.TYPE) {
            String parameter = request.getParameter(requestParameterName);
            if (parameter != null) {
                field.set(controller, Boolean.parseBoolean(parameter));
            }
        } else if (fieldType == String[].class) {
            String[] parameterValues = request.getParameterValues(requestParameterName);
            if (parameterValues != null) {
                field.set(controller, parameterValues);
            }
        } else {
            SpringRESTController.throwIllegalFieldAnnotationException(RequestParameter.class, field, String.class, Integer.TYPE, Boolean.TYPE, String[].class);
        }
    }

    private static void populateRequestHeaderFields(Map<String, ? extends Object> parameters, Object controller, Map<Class<? extends Annotation>, List<Field>> annotatedFields) throws IllegalAccessException {
        List<Field> requestHeaderFields = annotatedFields.get(RequestHeader.class);
        if (requestHeaderFields == null || requestHeaderFields.isEmpty()) {
            return;
        }
        for (Field field : requestHeaderFields) {
            SpringRESTController.populateRequestHeaderField(parameters, controller, field);
        }
    }

    private static void populateRequestHeaderField(Map<String, ? extends Object> parameters, Object controller, Field field) throws IllegalAccessException {
        Class<?> fieldType;
        field.setAccessible(true);
        HttpServletRequest request = HttpContextHelper.getRequest(parameters);
        String name = field.getAnnotation(RequestHeader.class).value();
        if (SpringRESTController.isBlank(name)) {
            name = field.getName();
        }
        if ((fieldType = field.getType()) == String.class) {
            String header = request.getHeader(name);
            if (header != null) {
                field.set(controller, header);
            }
        } else {
            SpringRESTController.throwIllegalFieldAnnotationException(RequestHeader.class, field, String.class);
        }
    }

    private static void populateSitemapParameterFields(Map<String, ? extends Object> configuration, Object controller, Map<Class<? extends Annotation>, List<Field>> annotatedFields) throws IllegalAccessException {
        List<Field> sitemapParameterFields = annotatedFields.get(SitemapParameter.class);
        if (sitemapParameterFields == null || sitemapParameterFields.isEmpty()) {
            return;
        }
        for (Field field : sitemapParameterFields) {
            SpringRESTController.populateSitemapParameterField(configuration, controller, field);
        }
    }

    private static void populateSitemapParameterField(Map<String, ? extends Object> configuration, Object controller, Field field) throws IllegalAccessException {
        field.setAccessible(true);
        String name = field.getAnnotation(SitemapParameter.class).value();
        if (SpringRESTController.isBlank(name)) {
            name = field.getName();
        }
        field.set(controller, configuration.get(name));
    }

    private static void throwIllegalFieldAnnotationException(Class<? extends Annotation> annotationClass, Field field, Class<?> ... supportedTypes) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("The annotation @");
        stringBuilder.append(annotationClass.getSimpleName());
        stringBuilder.append(" can only be set on fields of type ");
        for (int i = 0; i < supportedTypes.length; ++i) {
            stringBuilder.append(supportedTypes[i].getSimpleName());
            if (i < supportedTypes.length - 2) {
                stringBuilder.append(", ");
                continue;
            }
            if (i != supportedTypes.length - 2) continue;
            stringBuilder.append(" or ");
        }
        stringBuilder.append(". (The field was '");
        stringBuilder.append(Modifier.toString(field.getModifiers()));
        stringBuilder.append(" ");
        stringBuilder.append(field.getType().getName());
        stringBuilder.append(" ");
        stringBuilder.append(field.getName());
        stringBuilder.append("')");
        throw new IllegalFieldAnnotationException(stringBuilder.toString());
    }
}

