/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.rest.controller;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.cocoon.rest.controller.method.Delete;
import org.apache.cocoon.rest.controller.method.Get;
import org.apache.cocoon.rest.controller.method.Head;
import org.apache.cocoon.rest.controller.method.Options;
import org.apache.cocoon.rest.controller.method.Post;
import org.apache.cocoon.rest.controller.method.Put;
import org.apache.cocoon.rest.controller.response.RestResponse;
import org.apache.cocoon.rest.controller.response.Status;
import org.apache.cocoon.sitemap.util.ExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodDelegator {
    private static final Map<String, MethodDelegate> DELEGATES = new HashMap<String, MethodDelegate>();
    private static final Logger LOG = LoggerFactory.getLogger(MethodDelegator.class);

    public RestResponse delegate(HttpServletRequest request, Object controller) {
        MethodDelegate methodDelegate;
        if (request != null && request.getMethod() != null && (methodDelegate = DELEGATES.get(this.getMethod(request))) != null) {
            return methodDelegate.execute(controller);
        }
        return new Status(405);
    }

    private String getMethod(HttpServletRequest request) {
        String alternativeMethod = request.getParameter("_method");
        if (alternativeMethod == null) {
            return request.getMethod().toUpperCase();
        }
        if (DELEGATES.containsKey(alternativeMethod = alternativeMethod.toUpperCase())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using alternative request method '" + alternativeMethod + "' as provided by the request parameter '_method'");
            }
            return alternativeMethod;
        }
        if (LOG.isWarnEnabled()) {
            LOG.warn("The request parameter '_request' refers to an unsupported request method: _method='" + alternativeMethod + "'");
        }
        return request.getMethod().toUpperCase();
    }

    static {
        DELEGATES.put("DELETE", new DeleteDelegate());
        DELEGATES.put("GET", new GetDelegate());
        DELEGATES.put("HEAD", new HeadDelegate());
        DELEGATES.put("OPTIONS", new OptionsDelegate());
        DELEGATES.put("POST", new PostDelegate());
        DELEGATES.put("PUT", new PutDelegate());
    }

    private static class PutDelegate
    extends MethodDelegate {
        @Override
        public RestResponse execute(Object controller) {
            if (controller instanceof Put) {
                Put put = (Put)controller;
                try {
                    return put.doPut();
                }
                catch (Exception e) {
                    throw ExceptionHandler.getInvocationException((Throwable)e);
                }
            }
            return super.execute(controller);
        }
    }

    private static class PostDelegate
    extends MethodDelegate {
        @Override
        public RestResponse execute(Object controller) {
            if (controller instanceof Post) {
                Post post = (Post)controller;
                try {
                    return post.doPost();
                }
                catch (Exception e) {
                    throw ExceptionHandler.getInvocationException((Throwable)e);
                }
            }
            return super.execute(controller);
        }
    }

    private static class OptionsDelegate
    extends MethodDelegate {
        @Override
        public RestResponse execute(Object controller) {
            if (controller instanceof Options) {
                Options options = (Options)controller;
                try {
                    return options.doOptions();
                }
                catch (Exception e) {
                    throw ExceptionHandler.getInvocationException((Throwable)e);
                }
            }
            return super.execute(controller);
        }
    }

    private static abstract class MethodDelegate {
        public RestResponse execute(Object controller) {
            return new Status(405);
        }
    }

    private static class HeadDelegate
    extends MethodDelegate {
        @Override
        public RestResponse execute(Object controller) {
            if (controller instanceof Head) {
                Head head = (Head)controller;
                try {
                    return head.doHead();
                }
                catch (Exception e) {
                    throw ExceptionHandler.getInvocationException((Throwable)e);
                }
            }
            return new GetDelegate().execute(controller);
        }
    }

    private static class GetDelegate
    extends MethodDelegate {
        @Override
        public RestResponse execute(Object controller) {
            if (controller instanceof Get) {
                Get get = (Get)controller;
                try {
                    return get.doGet();
                }
                catch (Exception e) {
                    throw ExceptionHandler.getInvocationException((Throwable)e);
                }
            }
            return super.execute(controller);
        }
    }

    private static class DeleteDelegate
    extends MethodDelegate {
        @Override
        public RestResponse execute(Object controller) {
            if (controller instanceof Delete) {
                Delete delete = (Delete)controller;
                try {
                    return delete.doDelete();
                }
                catch (Exception e) {
                    throw ExceptionHandler.getInvocationException((Throwable)e);
                }
            }
            return super.execute(controller);
        }
    }
}

