/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.thread.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.cocoon.thread.RunnableManager;
import org.apache.cocoon.thread.ThreadPool;
import org.apache.cocoon.thread.impl.DefaultThreadPool;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultRunnableManager
implements RunnableManager,
Runnable {
    private Log logger = LogFactory.getLog(this.getClass());
    protected SortedSet commandStack = new TreeSet();
    final Map pools = new HashMap();
    private boolean keepRunning = false;
    private Map workerThreadPools;

    public Log getLogger() {
        return this.logger;
    }

    public void setLogger(Log l) {
        this.logger = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws Exception {
        ThreadPool defaultThreadPool;
        if (this.workerThreadPools != null) {
            for (String key : this.workerThreadPools.keySet()) {
                ThreadPool pool = (ThreadPool)this.workerThreadPools.get(key);
                Map map = this.pools;
                synchronized (map) {
                    this.pools.put(pool.getName(), pool);
                }
            }
        }
        if (null == (defaultThreadPool = (ThreadPool)this.pools.get("default"))) {
            this.createPool("default", -1, 5, 5, this.convertPriority("NORM"), false, 60000L, "RUN", false, -1);
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadPool createPool(String name, int queueSize, int maxPoolSize, int minPoolSize, int priority, boolean isDaemon, long keepAliveTime, String blockPolicy, boolean shutdownGraceful, int shutdownWaitTimeMs) {
        if (null != this.pools.get(name)) {
            throw new IllegalArgumentException("ThreadPool \"" + name + "\" already exists");
        }
        DefaultThreadPool pool = new DefaultThreadPool();
        pool.setName(name);
        pool.setQueueSize(queueSize);
        pool.setMaxPoolSize(maxPoolSize);
        pool.setMinPoolSize(minPoolSize);
        pool.setPriority(priority);
        pool.setDaemon(isDaemon);
        pool.setBlockPolicy(blockPolicy);
        pool.setShutdownGraceful(shutdownGraceful);
        pool.setShutdownWaitTimeMs(shutdownWaitTimeMs);
        Map map = this.pools;
        synchronized (map) {
            this.pools.put(pool.getName(), pool);
        }
        return pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadPool createPool(int queueSize, int maxPoolSize, int minPoolSize, int priority, boolean isDaemon, long keepAliveTime, String blockPolicy, boolean shutdownGraceful, int shutdownWaitTime) {
        DefaultThreadPool pool = new DefaultThreadPool();
        String name = "anon-" + ((Object)((Object)pool)).hashCode();
        pool.setName(name);
        pool.setQueueSize(queueSize);
        pool.setMaxPoolSize(maxPoolSize);
        pool.setMinPoolSize(minPoolSize);
        pool.setPriority(priority);
        pool.setDaemon(isDaemon);
        pool.setKeepAliveTime(keepAliveTime);
        pool.setBlockPolicy(blockPolicy);
        pool.setShutdownGraceful(shutdownGraceful);
        Map map = this.pools;
        synchronized (map) {
            this.pools.put(pool.getName(), pool);
        }
        return pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadPool getPool(String name) {
        if (name == null) {
            name = "default";
        }
        Map map = this.pools;
        synchronized (map) {
            return (ThreadPool)this.pools.get(name);
        }
    }

    public void destroy() throws Exception {
        this.stop();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"Disposing all thread pools");
        }
        for (String poolName : this.pools.keySet()) {
            DefaultThreadPool pool = (DefaultThreadPool)((Object)this.pools.get(poolName));
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("Disposing thread pool " + pool.getName()));
            }
            pool.shutdown();
            if (!this.getLogger().isDebugEnabled()) continue;
            this.getLogger().debug((Object)("Thread pool " + pool.getName() + " disposed"));
        }
        try {
            this.pools.clear();
        }
        catch (Throwable t) {
            this.getLogger().error((Object)"Cannot dispose", t);
        }
    }

    public void execute(String threadPoolName, Runnable command, long delay, long interval) {
        if (delay < 0L) {
            throw new IllegalArgumentException("delay < 0");
        }
        if (interval < 0L) {
            throw new IllegalArgumentException("interval < 0");
        }
        ThreadPool pool = (ThreadPool)this.pools.get(threadPoolName);
        if (null == pool) {
            this.getLogger().warn((Object)("ThreadPool \"" + threadPoolName + "\" is not known. Will use ThreadPool \"" + "default" + "\""));
            pool = (ThreadPool)this.pools.get("default");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Command entered: " + command + ", pool=" + (null == pool ? "null" : pool.getName()) + ", delay=" + delay + ", interval=" + interval));
        }
        new ExecutionInfo(pool, command, delay, interval, this.getLogger());
    }

    public void execute(Runnable command, long delay, long interval) {
        this.execute("default", command, delay, interval);
    }

    public void execute(Runnable command, long delay) {
        this.execute("default", command, delay, 0L);
    }

    public void execute(Runnable command) {
        this.execute("default", command, 0L, 0L);
    }

    public void execute(String threadPoolName, Runnable command, long delay) {
        this.execute(threadPoolName, command, delay, 0L);
    }

    public void execute(String threadPoolName, Runnable command) {
        this.execute(threadPoolName, command, 0L, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Runnable command) {
        SortedSet sortedSet = this.commandStack;
        synchronized (sortedSet) {
            Iterator i = this.commandStack.iterator();
            while (i.hasNext()) {
                ExecutionInfo info = (ExecutionInfo)i.next();
                if (info.m_command != command) continue;
                i.remove();
                this.commandStack.notifyAll();
                return;
            }
        }
        this.getLogger().warn((Object)("Could not find command " + command + " for removal"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"Entering loop");
        }
        while (this.keepRunning) {
            SortedSet sortedSet = this.commandStack;
            synchronized (sortedSet) {
                long delay;
                ExecutionInfo info;
                block14: {
                    try {
                        if (this.commandStack.size() > 0) {
                            info = (ExecutionInfo)this.commandStack.first();
                            delay = info.m_nextRun - System.currentTimeMillis();
                            if (delay > 0L) {
                                this.commandStack.wait(delay);
                            }
                        } else {
                            if (this.getLogger().isDebugEnabled()) {
                                this.getLogger().debug((Object)"No commands available. Will just wait for one");
                            }
                            this.commandStack.wait();
                        }
                    }
                    catch (InterruptedException ie) {
                        if (!this.getLogger().isDebugEnabled()) break block14;
                        this.getLogger().debug((Object)"I've been interrupted");
                    }
                }
                if (this.keepRunning && this.commandStack.size() > 0) {
                    info = (ExecutionInfo)this.commandStack.first();
                    delay = info.m_nextRun - System.currentTimeMillis();
                    if (delay < 0L) {
                        info.execute();
                    }
                }
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"Exiting loop");
        }
    }

    protected void start() throws Exception {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"Starting the heart");
        }
        this.keepRunning = true;
        ((ThreadPool)this.pools.get("default")).execute((Runnable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stop() {
        this.keepRunning = false;
        SortedSet sortedSet = this.commandStack;
        synchronized (sortedSet) {
            this.commandStack.notifyAll();
        }
    }

    private int convertPriority(String priority) {
        if ("MIN".equalsIgnoreCase(priority)) {
            return 1;
        }
        if ("NORM".equalsIgnoreCase(priority)) {
            return 5;
        }
        if ("MAX".equalsIgnoreCase(priority)) {
            return 10;
        }
        this.getLogger().warn((Object)("Unknown thread priority \"" + priority + "\". Set to \"NORM\"."));
        return 5;
    }

    public void setWorkerThreadPools(Map workerThreadPools) {
        this.workerThreadPools = workerThreadPools;
    }

    private class ExecutionInfo
    implements Comparable {
        final Log m_logger;
        final Runnable m_command;
        final ThreadPool m_pool;
        final long m_delay;
        final long m_interval;
        long m_nextRun = 0L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ExecutionInfo(ThreadPool pool, Runnable command, long delay, long interval, Log logger) {
            this.m_pool = pool;
            this.m_command = command;
            this.m_delay = delay;
            this.m_interval = interval;
            this.m_logger = logger;
            this.m_nextRun = System.currentTimeMillis() + delay;
            SortedSet sortedSet = DefaultRunnableManager.this.commandStack;
            synchronized (sortedSet) {
                DefaultRunnableManager.this.commandStack.add(this);
                DefaultRunnableManager.this.commandStack.notifyAll();
            }
            Thread.yield();
        }

        public int compareTo(Object other) {
            ExecutionInfo otherInfo = (ExecutionInfo)other;
            int diff = (int)(this.m_nextRun - otherInfo.m_nextRun);
            if (diff == 0) {
                if (this == other) {
                    return 0;
                }
                return System.identityHashCode(this) - System.identityHashCode(other);
            }
            return diff;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void execute() {
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)("Executing command " + this.m_command + " in pool \"" + this.m_pool.getName() + "\", schedule with interval=" + this.m_interval));
            }
            SortedSet sortedSet = DefaultRunnableManager.this.commandStack;
            synchronized (sortedSet) {
                DefaultRunnableManager.this.commandStack.remove(this);
                if (this.m_interval > 0L) {
                    this.m_nextRun = System.currentTimeMillis() + this.m_interval;
                    DefaultRunnableManager.this.commandStack.add(this);
                }
            }
            try {
                this.m_pool.execute(this.m_command);
            }
            catch (InterruptedException ie) {
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)("Interrupted executing command + " + this.m_command));
                }
            }
            catch (Throwable t) {
                this.m_logger.error((Object)("Exception executing command " + this.m_command), t);
            }
        }
    }
}

