/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.jnet;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;

public class URLStreamHandlerFactoryInstaller {
    public static void setURLStreamHandlerFactory(URLStreamHandlerFactory factory) throws Exception {
        try {
            URL.setURLStreamHandlerFactory(new ParentableURLStreamHandlerFactory(factory, null));
        }
        catch (Error err) {
            ParentableURLStreamHandlerFactory currentFactory = URLStreamHandlerFactoryInstaller.getCurrentFactory();
            URLStreamHandlerFactoryInstaller.setCurrentFactory(new ParentableURLStreamHandlerFactory(factory, currentFactory));
        }
    }

    private static ParentableURLStreamHandlerFactory getCurrentFactory() throws Exception {
        Field factoryField = URLStreamHandlerFactoryInstaller.getFactoryField();
        URLStreamHandlerFactory currentFactory = (URLStreamHandlerFactory)factoryField.get(null);
        if (currentFactory instanceof ParentableURLStreamHandlerFactory) {
            return (ParentableURLStreamHandlerFactory)currentFactory;
        }
        return new ParentableURLStreamHandlerFactory(currentFactory, null);
    }

    private static Field getFactoryField() throws Exception {
        Field[] fields = URL.class.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field current = fields[i];
            if (!Modifier.isStatic(current.getModifiers()) || !current.getType().equals(URLStreamHandlerFactory.class)) continue;
            current.setAccessible(true);
            return current;
        }
        throw new Exception("Unable to detect static field in the URL class for the URLStreamHandlerFactory. Please report this error together with your exact environment to the Apache Excalibur project.");
    }

    private static void setCurrentFactory(ParentableURLStreamHandlerFactory parentableURLStreamHandlerFactory) throws Exception {
        Field factoryField = URLStreamHandlerFactoryInstaller.getFactoryField();
        factoryField.set(null, parentableURLStreamHandlerFactory);
    }

    private static class ParentableURLStreamHandlerFactory
    implements URLStreamHandlerFactory {
        private final URLStreamHandlerFactory factory;
        private final ParentableURLStreamHandlerFactory parent;

        public ParentableURLStreamHandlerFactory(URLStreamHandlerFactory factory, ParentableURLStreamHandlerFactory parent) {
            this.parent = parent;
            this.factory = factory;
        }

        public URLStreamHandler createURLStreamHandler(String protocol) {
            URLStreamHandler handler = this.factory.createURLStreamHandler(protocol);
            if (handler == null && this.parent != null) {
                handler = this.parent.createURLStreamHandler(protocol);
            }
            return handler;
        }
    }
}

