/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.jnet;

import java.net.URLStreamHandlerFactory;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.cocoon.jnet.DynamicURLStreamHandlerFactory;
import org.apache.cocoon.jnet.URLStreamHandlerFactoryInstaller;
import org.aspectj.lang.ProceedingJoinPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLHandlerFactoryCollector {
    private Map<String, URLStreamHandlerFactory> urlHandlerFactories = Collections.emptyMap();
    private boolean urlStreamHandlerInstalled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object installURLHandlers(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        try {
            this.pushUrlHandlerFactories();
            Object object = proceedingJoinPoint.proceed();
            return object;
        }
        finally {
            this.popUrlHandlerFactories();
        }
    }

    public void pushUrlHandlerFactories() throws Exception {
        if (!this.urlStreamHandlerInstalled) {
            URLStreamHandlerFactoryInstaller.setURLStreamHandlerFactory(new DynamicURLStreamHandlerFactory());
            this.urlStreamHandlerInstalled = true;
        }
        for (URLStreamHandlerFactory streamHandlerFactory : this.urlHandlerFactories.values()) {
            DynamicURLStreamHandlerFactory.push(streamHandlerFactory);
        }
    }

    public void popUrlHandlerFactories() {
        Iterator<URLStreamHandlerFactory> i = this.urlHandlerFactories.values().iterator();
        while (i.hasNext()) {
            DynamicURLStreamHandlerFactory.pop();
            i.next();
        }
    }

    public void setUrlHandlerFactories(Map<String, URLStreamHandlerFactory> urlHandlerFactories) {
        this.urlHandlerFactories = urlHandlerFactories;
    }
}

