/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.jnet;

import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicURLStreamHandlerFactory
implements URLStreamHandlerFactory {
    private static final ThreadLocal<List<URLStreamHandlerFactory>> FACTORIES = new InheritableThreadLocal<List<URLStreamHandlerFactory>>();

    public static void pop() {
        DynamicURLStreamHandlerFactory.getList().remove(0);
    }

    public static void push(URLStreamHandlerFactory factory) {
        DynamicURLStreamHandlerFactory.getList().add(0, factory);
    }

    private static List<URLStreamHandlerFactory> getList() {
        List<URLStreamHandlerFactory> list = FACTORIES.get();
        if (list == null) {
            list = Collections.synchronizedList(new LinkedList());
            FACTORIES.set(list);
        }
        return list;
    }

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        List<URLStreamHandlerFactory> list = DynamicURLStreamHandlerFactory.getList();
        Iterator<URLStreamHandlerFactory> i = list.iterator();
        while (i.hasNext()) {
            URLStreamHandler handler = i.next().createURLStreamHandler(protocol);
            if (handler == null) continue;
            return handler;
        }
        return null;
    }
}

