/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.el.impl.jexl;

import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Map;
import org.apache.cocoon.el.ExpressionException;
import org.apache.cocoon.el.impl.AbstractExpression;
import org.apache.cocoon.el.impl.jexl.JSIntrospector;
import org.apache.cocoon.el.objectmodel.ObjectModel;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.util.Introspector;
import org.apache.commons.jexl.util.introspection.Info;

public class JexlExpression
extends AbstractExpression {
    private final Expression compiledExpression;

    public JexlExpression(String language, String expression) throws ExpressionException {
        super(language, expression);
        try {
            this.compiledExpression = ExpressionFactory.createExpression((String)expression);
        }
        catch (Exception e) {
            throw new ExpressionException("Couldn't create expression " + expression, (Throwable)e);
        }
    }

    public Object evaluate(ObjectModel objectModel) throws ExpressionException {
        try {
            return this.compiledExpression.evaluate((JexlContext)new ContextAdapter((Map)objectModel));
        }
        catch (Exception e) {
            throw new ExpressionException("Couldn't evaluate expression " + this.getExpression(), (Throwable)e);
        }
    }

    public Iterator iterate(ObjectModel objectModel) throws ExpressionException {
        Iterator iter = null;
        Object result = this.evaluate(objectModel);
        if (result != null) {
            try {
                iter = Introspector.getUberspect().getIterator(result, new Info("Unknown", 0, 0));
            }
            catch (Exception e) {
                throw new ExpressionException("Couldn't get an iterator from expression " + this.getExpression(), (Throwable)e);
            }
        }
        if (iter == null) {
            iter = EMPTY_ITER;
        }
        return iter;
    }

    public void assign(ObjectModel objectModel, Object value) throws ExpressionException {
        throw new UnsupportedOperationException("Assign is not yet implemented for Jexl");
    }

    public Object getNode(ObjectModel objectModel) throws ExpressionException {
        return this.evaluate(objectModel);
    }

    static {
        try {
            Field field = Introspector.class.getDeclaredField("uberSpect");
            field.setAccessible(true);
            field.set(null, (Object)new JSIntrospector());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class ContextAdapter
    implements JexlContext {
        private Map objectModel;

        public ContextAdapter(Map objectModel) {
            this.objectModel = objectModel;
        }

        public Map getVars() {
            return this.objectModel;
        }

        public void setVars(Map map) {
            this.objectModel = map;
        }
    }
}

