/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.simple.storage;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.clerezza.rdf.core.Graph;
import org.apache.clerezza.rdf.core.MGraph;
import org.apache.clerezza.rdf.core.TripleCollection;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.access.EntityAlreadyExistsException;
import org.apache.clerezza.rdf.core.access.EntityUndeletableException;
import org.apache.clerezza.rdf.core.access.NoSuchEntityException;
import org.apache.clerezza.rdf.core.access.WeightedTcProvider;
import org.apache.clerezza.rdf.core.impl.SimpleGraph;
import org.apache.clerezza.rdf.core.impl.SimpleMGraph;

public class SimpleTcProvider
implements WeightedTcProvider {
    private Map<UriRef, TripleCollection> tripleMap = new HashMap<UriRef, TripleCollection>();

    public Graph createGraph(UriRef name, TripleCollection triples) throws EntityAlreadyExistsException {
        if (name == null || name.getUnicodeString() == null || name.getUnicodeString().trim().length() == 0) {
            throw new IllegalArgumentException("Name must not be null");
        }
        try {
            this.getTriples(name);
        }
        catch (NoSuchEntityException e) {
            Object result = triples == null ? new SimpleGraph((TripleCollection)new SimpleMGraph()) : (Graph.class.isAssignableFrom(triples.getClass()) ? (Graph)triples : new SimpleGraph(triples));
            this.tripleMap.put(name, (TripleCollection)result);
            return result;
        }
        throw new EntityAlreadyExistsException(name);
    }

    public MGraph createMGraph(UriRef name) throws EntityAlreadyExistsException {
        if (name == null || name.getUnicodeString() == null || name.getUnicodeString().trim().length() == 0) {
            throw new IllegalArgumentException("Name must not be null");
        }
        try {
            this.getTriples(name);
        }
        catch (NoSuchEntityException e) {
            SimpleMGraph result = new SimpleMGraph();
            this.tripleMap.put(name, (TripleCollection)result);
            return result;
        }
        throw new EntityAlreadyExistsException(name);
    }

    public void deleteTripleCollection(UriRef name) throws NoSuchEntityException, EntityUndeletableException {
        if (this.tripleMap.remove(name) == null) {
            throw new NoSuchEntityException(name);
        }
    }

    public Graph getGraph(UriRef name) throws NoSuchEntityException {
        TripleCollection tripleCollection = this.tripleMap.get(name);
        if (tripleCollection == null) {
            throw new NoSuchEntityException(name);
        }
        if (Graph.class.isAssignableFrom(tripleCollection.getClass())) {
            return (Graph)tripleCollection;
        }
        throw new NoSuchEntityException(name);
    }

    public MGraph getMGraph(UriRef name) throws NoSuchEntityException {
        TripleCollection tripleCollection = this.tripleMap.get(name);
        if (tripleCollection == null) {
            throw new NoSuchEntityException(name);
        }
        if (MGraph.class.isAssignableFrom(tripleCollection.getClass())) {
            return (MGraph)tripleCollection;
        }
        throw new NoSuchEntityException(name);
    }

    public Set<UriRef> getNames(Graph graph) {
        throw new UnsupportedOperationException("Not supported yet. equals() has to be implemented first");
    }

    public TripleCollection getTriples(UriRef name) throws NoSuchEntityException {
        TripleCollection tripleCollection = this.tripleMap.get(name);
        if (tripleCollection == null) {
            throw new NoSuchEntityException(name);
        }
        return tripleCollection;
    }

    public int getWeight() {
        return 1;
    }

    public Set<UriRef> listGraphs() {
        HashSet<UriRef> result = new HashSet<UriRef>();
        for (UriRef uriRef : this.listTripleCollections()) {
            if (!(this.tripleMap.get(uriRef) instanceof Graph)) continue;
            result.add(uriRef);
        }
        return result;
    }

    public Set<UriRef> listMGraphs() {
        HashSet<UriRef> result = new HashSet<UriRef>();
        for (UriRef uriRef : this.listTripleCollections()) {
            if (!(this.tripleMap.get(uriRef) instanceof MGraph)) continue;
            result.add(uriRef);
        }
        return result;
    }

    public Set<UriRef> listTripleCollections() {
        return this.tripleMap.keySet();
    }
}

