/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.value.json;

import org.apache.cayenne.value.json.JsonTokenizer;

abstract class AbstractJsonConsumer<T> {
    private final JsonTokenizer tokenizer;
    private State[] states = new State[4];
    private int currentState = 0;

    AbstractJsonConsumer(String json) {
        this.states[this.currentState] = State.NONE;
        this.tokenizer = new JsonTokenizer(json);
    }

    protected abstract void onArrayStart();

    protected abstract void onArrayEnd();

    protected abstract void onObjectStart();

    protected abstract void onObjectEnd();

    protected abstract void onArrayValue(JsonTokenizer.JsonToken var1);

    protected abstract void onObjectKey(JsonTokenizer.JsonToken var1);

    protected abstract void onObjectValue(JsonTokenizer.JsonToken var1);

    protected abstract void onValue(JsonTokenizer.JsonToken var1);

    protected abstract T output();

    T process() {
        JsonTokenizer.JsonToken token;
        block6: while ((token = this.tokenizer.nextToken()).getType() != JsonTokenizer.TokenType.NONE) {
            switch (token.getType()) {
                case ARRAY_START: {
                    this.onArrayStart();
                    this.pushState(State.ARRAY);
                    continue block6;
                }
                case OBJECT_START: {
                    this.onObjectStart();
                    this.pushState(State.OBJECT_KEY);
                    continue block6;
                }
                case ARRAY_END: {
                    this.popState();
                    this.onArrayEnd();
                    continue block6;
                }
                case OBJECT_END: {
                    this.popState();
                    this.onObjectEnd();
                    continue block6;
                }
            }
            this.processValue(token);
        }
        return this.output();
    }

    private void processValue(JsonTokenizer.JsonToken token) {
        switch (this.states[this.currentState]) {
            case OBJECT_KEY: {
                this.setState(State.OBJECT_VALUE);
                this.onObjectKey(token);
                break;
            }
            case OBJECT_VALUE: {
                this.setState(State.OBJECT_KEY);
                this.onObjectValue(token);
                break;
            }
            case ARRAY: {
                this.onArrayValue(token);
                break;
            }
            default: {
                this.onValue(token);
            }
        }
    }

    protected void pushState(State state) {
        ++this.currentState;
        if (this.currentState >= this.states.length) {
            State[] newStates = new State[this.states.length << 2];
            System.arraycopy(this.states, 0, newStates, 0, this.states.length);
            this.states = newStates;
        }
        this.states[this.currentState] = state;
    }

    protected void setState(State state) {
        this.states[this.currentState] = state;
    }

    protected void popState() {
        this.states[this.currentState--] = null;
    }

    protected State currentState() {
        return this.states[this.currentState];
    }

    protected static enum State {
        NONE,
        ARRAY,
        OBJECT_KEY,
        OBJECT_VALUE;

    }
}

