/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tx;

import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.tx.BaseTransaction;
import org.apache.cayenne.tx.DoNothingTransactionListener;
import org.apache.cayenne.tx.Transaction;
import org.apache.cayenne.tx.TransactionDescriptor;
import org.apache.cayenne.tx.TransactionFactory;
import org.apache.cayenne.tx.TransactionListener;
import org.apache.cayenne.tx.TransactionManager;
import org.apache.cayenne.tx.TransactionalOperation;

public class DefaultTransactionManager
implements TransactionManager {
    private TransactionFactory txFactory;
    private JdbcEventLogger jdbcEventLogger;

    public DefaultTransactionManager(@Inject TransactionFactory txFactory, @Inject JdbcEventLogger jdbcEventLogger) {
        this.txFactory = txFactory;
        this.jdbcEventLogger = jdbcEventLogger;
    }

    @Override
    public <T> T performInTransaction(TransactionalOperation<T> op) {
        return this.performInTransaction(op, DoNothingTransactionListener.getInstance(), TransactionDescriptor.defaultDescriptor());
    }

    @Override
    public <T> T performInTransaction(TransactionalOperation<T> op, TransactionListener callback) {
        return this.performInTransaction(op, callback, TransactionDescriptor.defaultDescriptor());
    }

    @Override
    public <T> T performInTransaction(TransactionalOperation<T> op, TransactionDescriptor descriptor) {
        return this.performInTransaction(op, DoNothingTransactionListener.getInstance(), descriptor);
    }

    @Override
    public <T> T performInTransaction(TransactionalOperation<T> op, TransactionListener callback, TransactionDescriptor descriptor) {
        BaseTransactionHandler handler = this.getHandler(descriptor);
        return handler.handle(op, callback, descriptor);
    }

    protected BaseTransactionHandler getHandler(TransactionDescriptor descriptor) {
        switch (descriptor.getPropagation()) {
            case MANDATORY: {
                return new MandatoryTransactionHandler(this.txFactory, this.jdbcEventLogger);
            }
            case NESTED: {
                return new NestedTransactionHandler(this.txFactory, this.jdbcEventLogger);
            }
            case REQUIRES_NEW: {
                return new RequiresNewTransactionHandler(this.txFactory, this.jdbcEventLogger);
            }
        }
        throw new CayenneRuntimeException("Unsupported transaction propagation: " + descriptor.getPropagation(), new Object[0]);
    }

    protected static abstract class BaseTransactionHandler {
        private TransactionFactory txFactory;
        private JdbcEventLogger jdbcEventLogger;

        private BaseTransactionHandler(TransactionFactory txFactory, JdbcEventLogger jdbcEventLogger) {
            this.txFactory = txFactory;
            this.jdbcEventLogger = jdbcEventLogger;
        }

        protected abstract <T> T handle(TransactionalOperation<T> var1, TransactionListener var2, TransactionDescriptor var3);

        protected <T> T performInNewTransaction(TransactionalOperation<T> op, TransactionListener callback, TransactionDescriptor descriptor) {
            Transaction tx = this.txFactory.createTransaction(descriptor);
            BaseTransaction.bindThreadTransaction(tx);
            try {
                T result = this.performInTransaction(tx, op, callback);
                tx.commit();
                T t = result;
                return t;
            }
            catch (CayenneRuntimeException ex) {
                tx.setRollbackOnly();
                throw ex;
            }
            catch (Exception ex) {
                tx.setRollbackOnly();
                throw new CayenneRuntimeException(ex);
            }
            finally {
                BaseTransaction.bindThreadTransaction(null);
                if (tx.isRollbackOnly()) {
                    try {
                        tx.rollback();
                    }
                    catch (Exception e) {
                        this.jdbcEventLogger.logQueryError(e);
                    }
                }
            }
        }

        protected <T> T performInTransaction(Transaction tx, TransactionalOperation<T> op, TransactionListener callback) {
            tx.addListener(callback);
            return op.perform();
        }
    }

    private static class RequiresNewTransactionHandler
    extends BaseTransactionHandler {
        private RequiresNewTransactionHandler(TransactionFactory txFactory, JdbcEventLogger jdbcEventLogger) {
            super(txFactory, jdbcEventLogger);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected <T> T handle(TransactionalOperation<T> op, TransactionListener callback, TransactionDescriptor descriptor) {
            Transaction currentTx = BaseTransaction.getThreadTransaction();
            try {
                T t = this.performInNewTransaction(op, callback, descriptor);
                return t;
            }
            finally {
                if (currentTx != null) {
                    BaseTransaction.bindThreadTransaction(currentTx);
                }
            }
        }
    }

    private static class MandatoryTransactionHandler
    extends BaseTransactionHandler {
        private MandatoryTransactionHandler(TransactionFactory txFactory, JdbcEventLogger jdbcEventLogger) {
            super(txFactory, jdbcEventLogger);
        }

        @Override
        protected <T> T handle(TransactionalOperation<T> op, TransactionListener callback, TransactionDescriptor descriptor) {
            Transaction currentTx = BaseTransaction.getThreadTransaction();
            if (currentTx == null) {
                throw new CayenneRuntimeException("Transaction operation should join to existing transaction but none found.", new Object[0]);
            }
            return this.performInTransaction(currentTx, op, callback);
        }
    }

    private static class NestedTransactionHandler
    extends BaseTransactionHandler {
        private NestedTransactionHandler(TransactionFactory txFactory, JdbcEventLogger jdbcEventLogger) {
            super(txFactory, jdbcEventLogger);
        }

        @Override
        protected <T> T handle(TransactionalOperation<T> op, TransactionListener callback, TransactionDescriptor descriptor) {
            Transaction currentTx = BaseTransaction.getThreadTransaction();
            if (currentTx != null) {
                return this.performInTransaction(currentTx, op, callback);
            }
            return this.performInNewTransaction(op, callback, descriptor);
        }
    }
}

