/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.ResultBatchIterator;
import org.apache.cayenne.ResultIterator;
import org.apache.cayenne.ResultIteratorCallback;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.IndirectQuery;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.query.Select;

public class SelectById<T>
extends IndirectQuery
implements Select<T> {
    private static final long serialVersionUID = -6589464349051607583L;
    final QueryRoot root;
    final IdSpec idSpec;
    final boolean fetchingDataRows;
    QueryCacheStrategy cacheStrategy;
    String cacheGroup;
    PrefetchTreeNode prefetches;

    public static <T> SelectById<T> query(Class<T> entityType, Object id) {
        ByEntityTypeResolver root = new ByEntityTypeResolver(entityType);
        SingleScalarIdSpec idSpec = new SingleScalarIdSpec(id);
        return new SelectById<T>(root, idSpec);
    }

    public static <T> SelectById<T> query(Class<T> entityType, Map<String, ?> id) {
        ByEntityTypeResolver root = new ByEntityTypeResolver(entityType);
        SingleMapIdSpec idSpec = new SingleMapIdSpec(id);
        return new SelectById<T>(root, idSpec);
    }

    public static <T> SelectById<T> query(Class<T> entityType, ObjectId id) {
        SelectById.checkObjectId(id);
        ByEntityNameResolver root = new ByEntityNameResolver(id.getEntityName());
        SingleMapIdSpec idSpec = new SingleMapIdSpec(id.getIdSnapshot());
        return new SelectById<T>(root, idSpec);
    }

    public static <T> SelectById<T> query(Class<T> entityType, Object firstId, Object ... otherIds) {
        ByEntityTypeResolver root = new ByEntityTypeResolver(entityType);
        MultiScalarIdSpec idSpec = new MultiScalarIdSpec(firstId, otherIds);
        return new SelectById<T>(root, idSpec);
    }

    public static <T> SelectById<T> query(Class<T> entityType, Collection<Object> ids) {
        ByEntityTypeResolver root = new ByEntityTypeResolver(entityType);
        MultiScalarIdSpec idSpec = new MultiScalarIdSpec(ids);
        return new SelectById<T>(root, idSpec);
    }

    @SafeVarargs
    public static <T> SelectById<T> query(Class<T> entityType, Map<String, ?> firstId, Map<String, ?> ... otherIds) {
        ByEntityTypeResolver root = new ByEntityTypeResolver(entityType);
        MultiMapIdSpec idSpec = new MultiMapIdSpec(firstId, otherIds);
        return new SelectById<T>(root, idSpec);
    }

    public static <T> SelectById<T> query(Class<T> entityType, ObjectId firstId, ObjectId ... otherIds) {
        SelectById.checkObjectId(firstId);
        for (ObjectId id : otherIds) {
            SelectById.checkObjectId(id, firstId.getEntityName());
        }
        ByEntityNameResolver root = new ByEntityNameResolver(firstId.getEntityName());
        MultiMapIdSpec idSpec = new MultiMapIdSpec(firstId, otherIds);
        return new SelectById<T>(root, idSpec);
    }

    public static SelectById<DataRow> dataRowQuery(Class<?> entityType, Object id) {
        ByEntityTypeResolver root = new ByEntityTypeResolver(entityType);
        SingleScalarIdSpec idSpec = new SingleScalarIdSpec(id);
        return new SelectById<DataRow>(root, idSpec, true);
    }

    public static SelectById<DataRow> dataRowQuery(Class<?> entityType, Map<String, ?> id) {
        ByEntityTypeResolver root = new ByEntityTypeResolver(entityType);
        SingleMapIdSpec idSpec = new SingleMapIdSpec(id);
        return new SelectById<DataRow>(root, idSpec, true);
    }

    public static SelectById<DataRow> dataRowQuery(ObjectId id) {
        SelectById.checkObjectId(id);
        ByEntityNameResolver root = new ByEntityNameResolver(id.getEntityName());
        SingleMapIdSpec idSpec = new SingleMapIdSpec(id.getIdSnapshot());
        return new SelectById<DataRow>(root, idSpec, true);
    }

    public static SelectById<DataRow> dataRowQuery(Class<?> entityType, Object firstId, Object ... otherIds) {
        ByEntityTypeResolver root = new ByEntityTypeResolver(entityType);
        MultiScalarIdSpec idSpec = new MultiScalarIdSpec(firstId, otherIds);
        return new SelectById<DataRow>(root, idSpec, true);
    }

    @SafeVarargs
    public static SelectById<DataRow> dataRowQuery(Class<?> entityType, Map<String, ?> firstId, Map<String, ?> ... otherIds) {
        ByEntityTypeResolver root = new ByEntityTypeResolver(entityType);
        MultiMapIdSpec idSpec = new MultiMapIdSpec(firstId, otherIds);
        return new SelectById<DataRow>(root, idSpec, true);
    }

    public static SelectById<DataRow> dataRowQuery(ObjectId firstId, ObjectId ... otherIds) {
        SelectById.checkObjectId(firstId);
        for (ObjectId id : otherIds) {
            SelectById.checkObjectId(id, firstId.getEntityName());
        }
        ByEntityNameResolver root = new ByEntityNameResolver(firstId.getEntityName());
        MultiMapIdSpec idSpec = new MultiMapIdSpec(firstId, otherIds);
        return new SelectById<DataRow>(root, idSpec, true);
    }

    protected SelectById(QueryRoot root, IdSpec idSpec, boolean fetchingDataRows) {
        this.root = root;
        this.idSpec = idSpec;
        this.fetchingDataRows = fetchingDataRows;
    }

    protected SelectById(QueryRoot root, IdSpec idSpec) {
        this(root, idSpec, false);
    }

    @Override
    public List<T> select(ObjectContext context) {
        return context.select(this);
    }

    @Override
    public T selectOne(ObjectContext context) {
        return context.selectOne(this);
    }

    @Override
    public T selectFirst(ObjectContext context) {
        return context.selectFirst(this);
    }

    @Override
    public void iterate(ObjectContext context, ResultIteratorCallback<T> callback) {
        context.iterate(this, callback);
    }

    @Override
    public ResultIterator<T> iterator(ObjectContext context) {
        return context.iterator(this);
    }

    @Override
    public ResultBatchIterator<T> batchIterator(ObjectContext context, int size) {
        return context.batchIterator(this, size);
    }

    public SelectById<T> localCache(String cacheGroup) {
        return this.cacheStrategy(QueryCacheStrategy.LOCAL_CACHE, cacheGroup);
    }

    public SelectById<T> localCache() {
        return this.cacheStrategy(QueryCacheStrategy.LOCAL_CACHE);
    }

    public SelectById<T> sharedCache(String cacheGroup) {
        return this.cacheStrategy(QueryCacheStrategy.SHARED_CACHE, cacheGroup);
    }

    public SelectById<T> sharedCache() {
        return this.cacheStrategy(QueryCacheStrategy.SHARED_CACHE);
    }

    public QueryCacheStrategy getCacheStrategy() {
        return this.cacheStrategy;
    }

    public SelectById<T> cacheStrategy(QueryCacheStrategy strategy) {
        if (this.cacheStrategy != strategy) {
            this.cacheStrategy = strategy;
            this.replacementQuery = null;
        }
        return this;
    }

    public SelectById<T> cacheStrategy(QueryCacheStrategy strategy, String cacheGroup) {
        return this.cacheStrategy(strategy).cacheGroup(cacheGroup);
    }

    public String getCacheGroup() {
        return this.cacheGroup;
    }

    public SelectById<T> cacheGroup(String cacheGroup) {
        this.cacheGroup = cacheGroup;
        this.replacementQuery = null;
        return this;
    }

    public boolean isFetchingDataRows() {
        return this.fetchingDataRows;
    }

    public SelectById<T> prefetch(PrefetchTreeNode prefetch) {
        if (prefetch == null) {
            return this;
        }
        if (this.prefetches == null) {
            this.prefetches = new PrefetchTreeNode();
        }
        this.prefetches.merge(prefetch);
        return this;
    }

    public SelectById<T> prefetch(String path, int semantics) {
        if (path == null) {
            return this;
        }
        if (this.prefetches == null) {
            this.prefetches = new PrefetchTreeNode();
        }
        this.prefetches.addPath(path).setSemantics(semantics);
        return this;
    }

    public PrefetchTreeNode getPrefetches() {
        return this.prefetches;
    }

    @Override
    protected Query createReplacementQuery(EntityResolver resolver) {
        ObjEntity entity = this.root.resolve(resolver);
        ObjectSelect query = (ObjectSelect)((ObjectSelect)((ObjectSelect)new ObjectSelect().entityName(entity.getName())).where(this.idSpec.getQualifier(entity))).cacheStrategy(this.cacheStrategy, this.cacheGroup);
        if (this.prefetches != null) {
            query.prefetch(this.prefetches);
        }
        if (this.fetchingDataRows) {
            query.fetchDataRows();
        }
        return query;
    }

    private static String resolveSinglePkName(ObjEntity entity) {
        Collection<String> pkAttributes = entity.getPrimaryKeyNames();
        if (pkAttributes.size() == 1) {
            return pkAttributes.iterator().next();
        }
        throw new CayenneRuntimeException("PK contains %d columns, expected 1.", pkAttributes.size());
    }

    private static void checkObjectId(ObjectId id) {
        if (id.isTemporary() && !id.isReplacementIdAttached()) {
            throw new CayenneRuntimeException("Can't build a query for a temporary id: %s", id);
        }
    }

    private static void checkObjectId(ObjectId id, String entityName) {
        SelectById.checkObjectId(id);
        if (!entityName.equals(id.getEntityName())) {
            throw new CayenneRuntimeException("Can't build a query with mixed object types for given ObjectIds", new Object[0]);
        }
    }

    @SafeVarargs
    private static <E, R> Collection<R> foldArguments(Function<E, R> mapper, E first, E ... other) {
        ArrayList<R> result = new ArrayList<R>(1 + other.length);
        result.add(mapper.apply(first));
        for (E next : other) {
            result.add(mapper.apply(next));
        }
        return result;
    }

    private static class ByEntityNameResolver
    implements QueryRoot {
        private final String entityName;

        public ByEntityNameResolver(String entityName) {
            this.entityName = entityName;
        }

        @Override
        public ObjEntity resolve(EntityResolver resolver) {
            return resolver.getObjEntity(this.entityName);
        }
    }

    private static class ByEntityTypeResolver
    implements QueryRoot {
        private final Class<?> entityType;

        public ByEntityTypeResolver(Class<?> entityType) {
            this.entityType = entityType;
        }

        @Override
        public ObjEntity resolve(EntityResolver resolver) {
            return resolver.getObjEntity(this.entityType);
        }
    }

    protected static class MultiMapIdSpec
    implements IdSpec {
        private final Collection<Map<String, ?>> ids;

        @SafeVarargs
        protected MultiMapIdSpec(Map<String, ?> firstId, Map<String, ?> ... otherIds) {
            this.ids = SelectById.foldArguments(Function.identity(), firstId, otherIds);
        }

        protected MultiMapIdSpec(ObjectId firstId, ObjectId ... otherIds) {
            this.ids = SelectById.foldArguments(ObjectId::getIdSnapshot, firstId, otherIds);
        }

        @Override
        public Expression getQualifier(ObjEntity entity) {
            ArrayList<Expression> expressions = new ArrayList<Expression>();
            for (Map<String, ?> id : this.ids) {
                expressions.add(ExpressionFactory.matchAllDbExp(id, 3));
            }
            return ExpressionFactory.or(expressions);
        }
    }

    protected static class SingleMapIdSpec
    implements IdSpec {
        private final Map<String, ?> id;

        protected SingleMapIdSpec(Map<String, ?> id) {
            this.id = id;
        }

        @Override
        public Expression getQualifier(ObjEntity entity) {
            return ExpressionFactory.matchAllDbExp(this.id, 3);
        }
    }

    protected static class MultiScalarIdSpec
    implements IdSpec {
        private final Collection<Object> ids;

        protected MultiScalarIdSpec(Object firstId, Object ... otherIds) {
            this.ids = SelectById.foldArguments(Function.identity(), firstId, otherIds);
        }

        protected MultiScalarIdSpec(Collection<Object> ids) {
            this.ids = ids;
        }

        @Override
        public Expression getQualifier(ObjEntity entity) {
            return ExpressionFactory.inDbExp(SelectById.resolveSinglePkName(entity), this.ids);
        }
    }

    protected static class SingleScalarIdSpec
    implements IdSpec {
        private final Object id;

        protected SingleScalarIdSpec(Object id) {
            this.id = id;
        }

        @Override
        public Expression getQualifier(ObjEntity entity) {
            return ExpressionFactory.matchDbExp(SelectById.resolveSinglePkName(entity), this.id);
        }
    }

    protected static interface IdSpec
    extends Serializable {
        public Expression getQualifier(ObjEntity var1);
    }

    protected static interface QueryRoot
    extends Serializable {
        public ObjEntity resolve(EntityResolver var1);
    }
}

