/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.List;
import java.util.Map;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.property.BaseProperty;
import org.apache.cayenne.exp.property.ComparableProperty;
import org.apache.cayenne.exp.property.NumericProperty;
import org.apache.cayenne.exp.property.Property;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.ColumnSelect;
import org.apache.cayenne.query.FluentSelect;
import org.apache.cayenne.query.ObjectSelectMetadata;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.ParameterizedQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryMetadata;

public class ObjectSelect<T>
extends FluentSelect<T, ObjectSelect<T>>
implements ParameterizedQuery {
    private static final long serialVersionUID = -156124021150949227L;

    public static <T> ObjectSelect<T> query(Class<T> entityType) {
        return (ObjectSelect)new ObjectSelect<T>().entityType(entityType);
    }

    public static <T> ObjectSelect<T> query(Class<T> entityType, Expression expression) {
        return (ObjectSelect)((ObjectSelect)new ObjectSelect<T>().entityType(entityType)).where(expression);
    }

    public static <T> ObjectSelect<T> query(Class<T> entityType, Expression expression, List<Ordering> orderings) {
        return (ObjectSelect)((ObjectSelect)((ObjectSelect)new ObjectSelect<T>().entityType(entityType)).where(expression)).orderBy(orderings);
    }

    public static ObjectSelect<DataRow> dataRowQuery(Class<?> entityType) {
        return ObjectSelect.query(entityType).fetchDataRows();
    }

    public static ObjectSelect<DataRow> dataRowQuery(Class<?> entityType, Expression expression) {
        return (ObjectSelect)ObjectSelect.query(entityType).fetchDataRows().where(expression);
    }

    public static <T> ObjectSelect<T> query(Class<T> resultType, String entityName) {
        return (ObjectSelect)new ObjectSelect<T>().entityName(entityName);
    }

    public static ObjectSelect<DataRow> dbQuery(String dbEntityName) {
        return (ObjectSelect)new ObjectSelect().fetchDataRows().dbEntityName(dbEntityName);
    }

    public static ObjectSelect<DataRow> dbQuery(String dbEntityName, Expression expression) {
        return (ObjectSelect)((ObjectSelect)new ObjectSelect().fetchDataRows().dbEntityName(dbEntityName)).where(expression);
    }

    public static <E> ColumnSelect<E> columnQuery(Class<?> entityType, Property<E> column) {
        return ((ColumnSelect)new ColumnSelect().entityType(entityType)).column(column);
    }

    public static ColumnSelect<Object[]> columnQuery(Class<?> entityType, Property<?> ... columns) {
        return ((ColumnSelect)new ColumnSelect().entityType(entityType)).columns(columns);
    }

    protected ObjectSelect() {
    }

    @Override
    protected ObjectSelectMetadata createMetadata() {
        return new ObjectSelectMetadata();
    }

    public ObjectSelect<T> having(Expression expression) {
        this.havingExpressionIsActive = true;
        return (ObjectSelect)this.and(expression);
    }

    public ObjectSelect<T> having(String expressionString, Object ... parameters) {
        this.havingExpressionIsActive = true;
        return (ObjectSelect)this.and(ExpressionFactory.exp(expressionString, parameters));
    }

    public ObjectSelect<DataRow> fetchDataRows() {
        this.metaData.setFetchingDataRows(true);
        return (ObjectSelect)this.castSelf();
    }

    public ColumnSelect<Object[]> columns(Property<?> ... properties) {
        return new ColumnSelect(this).columns(properties);
    }

    public <E> ColumnSelect<E> column(Property<E> property) {
        return new ColumnSelect(this).column(property);
    }

    public ColumnSelect<Long> count() {
        return this.column(PropertyFactory.COUNT);
    }

    public ColumnSelect<Long> count(BaseProperty<?> property) {
        return this.column(property.count());
    }

    public <E> ColumnSelect<E> min(ComparableProperty<E> property) {
        return this.column(property.min());
    }

    public <E extends Number> ColumnSelect<E> min(NumericProperty<E> property) {
        return this.column(property.min());
    }

    public <E> ColumnSelect<E> max(ComparableProperty<E> property) {
        return this.column(property.max());
    }

    public <E extends Number> ColumnSelect<E> max(NumericProperty<E> property) {
        return this.column(property.max());
    }

    public <E extends Number> ColumnSelect<E> avg(NumericProperty<E> property) {
        return this.column(property.avg());
    }

    public <E extends Number> ColumnSelect<E> sum(NumericProperty<E> property) {
        return this.column(property.sum());
    }

    public ObjectSelect<T> distinct() {
        this.distinct = true;
        return this;
    }

    public long selectCount(ObjectContext context) {
        return (Long)this.count().selectOne(context);
    }

    @Override
    public T selectFirst(ObjectContext context) {
        return context.selectFirst(this.limit(1));
    }

    @Override
    public QueryMetadata getMetaData(EntityResolver resolver) {
        Object root = this.resolveRoot(resolver);
        this.metaData.resolve(root, resolver, this);
        return this.metaData;
    }

    @Override
    protected ObjectSelectMetadata getBaseMetaData() {
        return this.metaData;
    }

    @Override
    public Query createQuery(Map<String, ?> parameters) {
        if (this.where == null) {
            return this;
        }
        this.where = this.where.params(parameters, true);
        return this;
    }
}

