/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.util.Collections;
import java.util.Iterator;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.ConfigurationNodeVisitor;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.util.CayenneMapEntry;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.util.XMLEncoder;

public class ObjAttribute
extends Attribute<ObjEntity, ObjAttribute, ObjRelationship>
implements ConfigurationNode {
    protected String type;
    protected boolean usedForLocking;
    protected boolean lazy;
    protected String dbAttributePath;

    public ObjAttribute() {
    }

    public ObjAttribute(String name) {
        super(name);
    }

    public ObjAttribute(String name, String type, ObjEntity entity) {
        this.setName(name);
        this.setType(type);
        this.setEntity(entity);
    }

    public ObjAttribute(ObjAttribute attribute) {
        this.setName(attribute.getName());
        this.setType(attribute.getType());
        this.setEntity(attribute.getEntity());
        this.setDbAttributePath(attribute.getDbAttributePath());
        this.setUsedForLocking(attribute.isUsedForLocking());
        this.setLazy(attribute.isLazy());
    }

    public ObjEntity getEntity() {
        return (ObjEntity)super.getEntity();
    }

    @Override
    public <T> T acceptVisitor(ConfigurationNodeVisitor<T> visitor) {
        return visitor.visitObjAttribute(this);
    }

    public Class<?> getJavaClass() {
        if (this.getType() == null) {
            return null;
        }
        try {
            return Util.getJavaClass(this.getType());
        }
        catch (ClassNotFoundException e) {
            throw new CayenneRuntimeException("Failed to load class for name '" + this.getType() + "': " + e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    @Override
    public void encodeAsXML(XMLEncoder encoder, ConfigurationNodeVisitor delegate) {
        encoder.start("obj-attribute").attribute("name", this.getName()).attribute("type", this.getType()).attribute("lock", this.isUsedForLocking()).attribute("lazy", this.isLazy()).attribute("db-attribute-path", this.getDbAttributePath());
        delegate.visitObjAttribute(this);
        encoder.end();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isPrimaryKey() {
        if (this.dbAttributePath == null) {
            return false;
        }
        DbAttribute dbAttribute = this.getDbAttribute();
        return dbAttribute != null && dbAttribute.isPrimaryKey();
    }

    public boolean isUsedForLocking() {
        return this.usedForLocking;
    }

    public void setUsedForLocking(boolean usedForLocking) {
        this.usedForLocking = usedForLocking;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public DbAttribute getDbAttribute() {
        Iterator<CayenneMapEntry> pathIterator = this.getDbPathIterator(this.getEntity());
        CayenneMapEntry o = null;
        while (pathIterator.hasNext()) {
            o = pathIterator.next();
        }
        if (o == null) {
            return this.getParentDbAttribute(this.getEntity());
        }
        return (DbAttribute)o;
    }

    private DbAttribute getParentDbAttribute(ObjEntity entity) {
        ObjEntity parent;
        if (entity != null && (parent = entity.getSuperEntity()) != null) {
            Iterator<CayenneMapEntry> pathIterator = this.getDbPathIterator(parent);
            CayenneMapEntry o = null;
            while (pathIterator.hasNext()) {
                o = pathIterator.next();
            }
            if (o == null) {
                return this.getParentDbAttribute(parent);
            }
            return (DbAttribute)o;
        }
        return null;
    }

    public boolean isInherited() {
        ObjEntity owningEntity = this.getEntity();
        if (owningEntity == null) {
            return false;
        }
        ObjEntity superEntity = owningEntity.getSuperEntity();
        if (superEntity == null) {
            return false;
        }
        return superEntity.getAttribute(this.getName()) != null;
    }

    public Iterator<CayenneMapEntry> getDbPathIterator() {
        return this.getDbPathIterator(this.getEntity());
    }

    public Iterator<CayenneMapEntry> getDbPathIterator(ObjEntity entity) {
        if (this.dbAttributePath == null) {
            return Collections.emptyIterator();
        }
        if (entity == null) {
            return Collections.emptyIterator();
        }
        DbEntity dbEnt = entity.getDbEntity();
        if (dbEnt == null) {
            return Collections.emptyIterator();
        }
        int lastPartStart = this.dbAttributePath.lastIndexOf(46);
        if (lastPartStart < 0) {
            DbAttribute attribute = (DbAttribute)dbEnt.getAttribute(this.dbAttributePath);
            if (attribute == null) {
                return Collections.emptyIterator();
            }
            return Collections.singleton(attribute).iterator();
        }
        return dbEnt.resolvePathComponents(this.dbAttributePath);
    }

    public String getDbAttributeName() {
        if (this.dbAttributePath == null) {
            return null;
        }
        int lastDot = this.dbAttributePath.lastIndexOf(46);
        if (lastDot < 0) {
            return this.dbAttributePath;
        }
        return this.dbAttributePath.substring(lastDot + 1);
    }

    public void setDbAttributePath(String dbAttributePath) {
        this.dbAttributePath = dbAttributePath;
        if (this.isInherited()) {
            ((ObjEntity)this.entity).addAttributeOverride(this.getName(), dbAttributePath);
        }
    }

    public String getDbAttributePath() {
        return this.dbAttributePath;
    }

    public boolean isFlattened() {
        return this.dbAttributePath != null && this.dbAttributePath.indexOf(46) >= 0;
    }

    public boolean isMandatory() {
        DbAttribute dbAttribute = this.getDbAttribute();
        return dbAttribute != null && dbAttribute.isMandatory();
    }

    public int getMaxLength() {
        DbAttribute dbAttribute = this.getDbAttribute();
        return dbAttribute == null ? -1 : dbAttribute.getMaxLength();
    }

    public void updateDbAttributePath() {
        if (this.isFlattened()) {
            StringBuilder newDbAttributePath = new StringBuilder();
            Iterator<CayenneMapEntry> dbPathIterator = this.getDbPathIterator();
            while (dbPathIterator.hasNext()) {
                CayenneMapEntry next = dbPathIterator.next();
                newDbAttributePath.append(next.getName());
                if (!(next instanceof DbRelationship)) continue;
                newDbAttributePath.append('.');
            }
            this.setDbAttributePath(newDbAttributePath.toString());
        }
    }

    @Override
    public String toString() {
        return "ObjAttr: " + this.type + " " + this.name + "; DbPath[" + this.dbAttributePath + "]";
    }
}

