/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.types.ValueObjectTypeRegistry;
import org.apache.cayenne.annotation.PostAdd;
import org.apache.cayenne.annotation.PostLoad;
import org.apache.cayenne.annotation.PostPersist;
import org.apache.cayenne.annotation.PostRemove;
import org.apache.cayenne.annotation.PostUpdate;
import org.apache.cayenne.annotation.PrePersist;
import org.apache.cayenne.annotation.PreRemove;
import org.apache.cayenne.annotation.PreUpdate;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.map.CallbackDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EntityInheritanceTree;
import org.apache.cayenne.map.EntitySorter;
import org.apache.cayenne.map.LifecycleEvent;
import org.apache.cayenne.map.MappingCache;
import org.apache.cayenne.map.MappingNamespace;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProxiedMappingNamespace;
import org.apache.cayenne.map.QueryDescriptor;
import org.apache.cayenne.map.SQLResult;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.ClassDescriptorMap;
import org.apache.cayenne.reflect.LifecycleCallbackRegistry;
import org.apache.cayenne.reflect.SingletonFaultFactory;
import org.apache.cayenne.reflect.generic.DataObjectDescriptorFactory;
import org.apache.cayenne.reflect.generic.ValueComparisonStrategyFactory;
import org.apache.cayenne.reflect.valueholder.ValueHolderDescriptorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityResolver
implements MappingNamespace,
Serializable {
    protected static final Logger logger = LoggerFactory.getLogger(EntityResolver.class);
    protected static AtomicLong incrementer = new AtomicLong();
    protected static final Map<LifecycleEvent, Class<? extends Annotation>> LIFECYCLE_EVENT_MAP = new EnumMap<LifecycleEvent, Class<? extends Annotation>>(LifecycleEvent.class);
    protected Collection<DataMap> maps;
    protected transient MappingNamespace mappingCache;
    protected volatile transient ClassDescriptorMap classDescriptorMap;
    protected transient LifecycleCallbackRegistry callbackRegistry;
    protected transient ValueObjectTypeRegistry valueObjectTypeRegistry;
    protected transient ValueComparisonStrategyFactory valueComparisonStrategyFactory;
    protected transient EntitySorter entitySorter;
    protected transient AdhocObjectFactory objectFactory;

    public EntityResolver() {
        this(Collections.emptyList());
    }

    public EntityResolver(Collection<DataMap> dataMaps) {
        this.maps = new ArrayList<DataMap>(dataMaps);
        this.refreshMappingCache();
    }

    public void applyDBLayerDefaults() {
        for (DataMap map : this.getDataMaps()) {
            for (DbEntity entity : map.getDbEntities()) {
                DbRelationship[] relationships;
                for (DbRelationship relationship : relationships = entity.getRelationships().toArray(new DbRelationship[0])) {
                    if (relationship.getReverseRelationship() != null) continue;
                    DbRelationship reverse = relationship.createReverseRelationship();
                    DbEntity targetEntity = (DbEntity)reverse.getSourceEntity();
                    reverse.setName(this.getUniqueRelationshipName(targetEntity));
                    reverse.setRuntime(true);
                    targetEntity.addRelationship(reverse);
                    logger.info("added runtime complimentary DbRelationship from " + targetEntity.getName() + " to " + reverse.getTargetEntityName());
                }
            }
        }
    }

    private String getUniqueRelationshipName(DbEntity entity) {
        String name;
        while (entity.getRelationship(name = "runtimeRelationship" + incrementer.getAndIncrement()) != null) {
        }
        return name;
    }

    synchronized void initCallbacks() {
        if (this.callbackRegistry == null) {
            LifecycleCallbackRegistry callbackRegistry = new LifecycleCallbackRegistry(this);
            for (ObjEntity entity : this.getObjEntities()) {
                CallbackDescriptor[] callbacks;
                Class entityClass = this.objectFactory.getJavaClass(entity.getJavaClassName());
                for (Method m : entityClass.getDeclaredMethods()) {
                    LIFECYCLE_EVENT_MAP.forEach((eventType, annotationType) -> {
                        if (m.getDeclaredAnnotation(annotationType) != null) {
                            callbackRegistry.addCallback((LifecycleEvent)((Object)eventType), (Class<?>)entityClass, m);
                        }
                    });
                }
                for (CallbackDescriptor callback : callbacks = entity.getCallbackMap().getCallbacks()) {
                    for (String method : callback.getCallbackMethods()) {
                        callbackRegistry.addCallback(callback.getCallbackType(), entityClass, method);
                    }
                }
            }
            this.callbackRegistry = callbackRegistry;
        }
    }

    public LifecycleCallbackRegistry getCallbackRegistry() {
        if (this.callbackRegistry == null) {
            this.initCallbacks();
        }
        return this.callbackRegistry;
    }

    public void setCallbackRegistry(LifecycleCallbackRegistry callbackRegistry) {
        this.callbackRegistry = callbackRegistry;
    }

    @Override
    public Collection<DbEntity> getDbEntities() {
        this.checkMappingCache();
        return this.mappingCache.getDbEntities();
    }

    @Override
    public Collection<ObjEntity> getObjEntities() {
        this.checkMappingCache();
        return this.mappingCache.getObjEntities();
    }

    @Override
    public Collection<Embeddable> getEmbeddables() {
        this.checkMappingCache();
        return this.mappingCache.getEmbeddables();
    }

    @Override
    public Collection<SQLResult> getResults() {
        this.checkMappingCache();
        return this.mappingCache.getResults();
    }

    @Override
    public Collection<Procedure> getProcedures() {
        this.checkMappingCache();
        return this.mappingCache.getProcedures();
    }

    @Override
    public Collection<QueryDescriptor> getQueryDescriptors() {
        this.checkMappingCache();
        return this.mappingCache.getQueryDescriptors();
    }

    @Override
    public DbEntity getDbEntity(String name) {
        this.checkMappingCache();
        DbEntity result = this.mappingCache.getDbEntity(name);
        if (result == null) {
            this.refreshMappingCache();
            result = this.mappingCache.getDbEntity(name);
        }
        return result;
    }

    @Override
    public ObjEntity getObjEntity(String name) {
        this.checkMappingCache();
        ObjEntity result = this.mappingCache.getObjEntity(name);
        if (result == null) {
            this.refreshMappingCache();
            result = this.mappingCache.getObjEntity(name);
        }
        return result;
    }

    @Override
    public Procedure getProcedure(String procedureName) {
        this.checkMappingCache();
        Procedure result = this.mappingCache.getProcedure(procedureName);
        if (result == null) {
            this.refreshMappingCache();
            result = this.mappingCache.getProcedure(procedureName);
        }
        return result;
    }

    @Override
    public QueryDescriptor getQueryDescriptor(String name) {
        this.checkMappingCache();
        QueryDescriptor result = this.mappingCache.getQueryDescriptor(name);
        if (result == null) {
            this.refreshMappingCache();
            result = this.mappingCache.getQueryDescriptor(name);
        }
        return result;
    }

    @Override
    public Embeddable getEmbeddable(String className) {
        this.checkMappingCache();
        Embeddable result = this.mappingCache.getEmbeddable(className);
        if (result == null) {
            this.refreshMappingCache();
            result = this.mappingCache.getEmbeddable(className);
        }
        return result;
    }

    @Override
    public SQLResult getResult(String name) {
        this.checkMappingCache();
        SQLResult result = this.mappingCache.getResult(name);
        if (result == null) {
            this.refreshMappingCache();
            result = this.mappingCache.getResult(name);
        }
        return result;
    }

    public ClassDescriptor getClassDescriptor(String entityName) {
        if (entityName == null) {
            throw new IllegalArgumentException("Null entityName");
        }
        return this.getClassDescriptorMap().getDescriptor(entityName);
    }

    public synchronized void addDataMap(DataMap map) {
        if (!this.maps.contains(map)) {
            this.maps.add(map);
            map.setNamespace(this);
            this.refreshMappingCache();
        }
    }

    private void checkMappingCache() {
        if (this.mappingCache == null) {
            this.refreshMappingCache();
        }
    }

    public void refreshMappingCache() {
        this.mappingCache = new ProxiedMappingNamespace(){

            @Override
            protected MappingCache createDelegate() {
                return new MappingCache(EntityResolver.this.maps);
            }
        };
    }

    public DataMap getDataMap(String mapName) {
        if (mapName == null) {
            return null;
        }
        for (DataMap map : this.maps) {
            if (!mapName.equals(map.getName())) continue;
            return map;
        }
        return null;
    }

    public synchronized void setDataMaps(Collection<DataMap> maps) {
        this.maps.clear();
        this.maps.addAll(maps);
        this.refreshMappingCache();
    }

    public Collection<DataMap> getDataMaps() {
        return Collections.unmodifiableCollection(this.maps);
    }

    @Override
    public EntityInheritanceTree getInheritanceTree(String entityName) {
        this.checkMappingCache();
        EntityInheritanceTree tree = this.mappingCache.getInheritanceTree(entityName);
        if (tree == null) {
            this.refreshMappingCache();
            tree = this.mappingCache.getInheritanceTree(entityName);
        }
        return tree;
    }

    @Override
    public ObjEntity getObjEntity(Class<?> entityClass) {
        this.checkMappingCache();
        ObjEntity result = this.mappingCache.getObjEntity(entityClass);
        if (result == null) {
            this.refreshMappingCache();
            result = this.mappingCache.getObjEntity(entityClass);
        }
        return result;
    }

    @Override
    public ObjEntity getObjEntity(Persistent object) {
        this.checkMappingCache();
        return this.mappingCache.getObjEntity(object);
    }

    public synchronized void removeDataMap(DataMap map) {
        if (this.maps.remove(map)) {
            this.refreshMappingCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassDescriptorMap getClassDescriptorMap() {
        if (this.classDescriptorMap == null) {
            EntityResolver entityResolver = this;
            synchronized (entityResolver) {
                if (this.classDescriptorMap == null) {
                    ClassDescriptorMap classDescriptorMap = new ClassDescriptorMap(this);
                    SingletonFaultFactory faultFactory = new SingletonFaultFactory();
                    classDescriptorMap.addFactory(new ValueHolderDescriptorFactory(classDescriptorMap));
                    classDescriptorMap.addFactory(new DataObjectDescriptorFactory(classDescriptorMap, faultFactory, this.valueComparisonStrategyFactory));
                    for (DataMap map : this.maps) {
                        for (String entityName : map.getObjEntityMap().keySet()) {
                            classDescriptorMap.getDescriptor(entityName);
                        }
                    }
                    this.classDescriptorMap = classDescriptorMap;
                }
            }
        }
        return this.classDescriptorMap;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.refreshMappingCache();
    }

    public ValueObjectTypeRegistry getValueObjectTypeRegistry() {
        return this.valueObjectTypeRegistry;
    }

    public void setValueObjectTypeRegistry(ValueObjectTypeRegistry valueObjectTypeRegistry) {
        this.valueObjectTypeRegistry = valueObjectTypeRegistry;
    }

    public void setValueComparisonStrategyFactory(ValueComparisonStrategyFactory valueComparisonStrategyFactory) {
        this.valueComparisonStrategyFactory = valueComparisonStrategyFactory;
    }

    public void setEntitySorter(EntitySorter entitySorter) {
        this.entitySorter = entitySorter;
    }

    public EntitySorter getEntitySorter() {
        return this.entitySorter;
    }

    public void setObjectFactory(AdhocObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public AdhocObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    static {
        LIFECYCLE_EVENT_MAP.put(LifecycleEvent.POST_ADD, PostAdd.class);
        LIFECYCLE_EVENT_MAP.put(LifecycleEvent.PRE_PERSIST, PrePersist.class);
        LIFECYCLE_EVENT_MAP.put(LifecycleEvent.POST_PERSIST, PostPersist.class);
        LIFECYCLE_EVENT_MAP.put(LifecycleEvent.PRE_UPDATE, PreUpdate.class);
        LIFECYCLE_EVENT_MAP.put(LifecycleEvent.POST_UPDATE, PostUpdate.class);
        LIFECYCLE_EVENT_MAP.put(LifecycleEvent.PRE_REMOVE, PreRemove.class);
        LIFECYCLE_EVENT_MAP.put(LifecycleEvent.POST_REMOVE, PostRemove.class);
        LIFECYCLE_EVENT_MAP.put(LifecycleEvent.POST_LOAD, PostLoad.class);
    }
}

