/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.ConfigurationNodeVisitor;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.util.XMLEncoder;

public class DbRelationship
extends Relationship<DbEntity, DbAttribute, DbRelationship>
implements ConfigurationNode {
    protected List<DbJoin> joins = new ArrayList<DbJoin>(2);
    protected boolean toDependentPK;

    public DbRelationship() {
    }

    public DbRelationship(String name) {
        super(name);
    }

    @Override
    public <T> T acceptVisitor(ConfigurationNodeVisitor<T> visitor) {
        return visitor.visitDbRelationship(this);
    }

    @Override
    public void encodeAsXML(XMLEncoder encoder, ConfigurationNodeVisitor delegate) {
        encoder.start("db-relationship").attribute("name", this.getName()).attribute("source", ((DbEntity)this.getSourceEntity()).getName());
        if (this.getTargetEntityName() != null && this.getTargetEntity() != null) {
            encoder.attribute("target", this.getTargetEntityName());
        }
        encoder.attribute("toDependentPK", this.isToDependentPK() && this.isValidForDepPk());
        encoder.attribute("toMany", this.isToMany());
        encoder.nested(this.getJoins(), delegate);
        delegate.visitDbRelationship(this);
        encoder.end();
    }

    @Override
    public DbEntity getTargetEntity() {
        String targetName = this.getTargetEntityName();
        if (targetName == null) {
            return null;
        }
        return this.getNonNullNamespace().getDbEntity(targetName);
    }

    public Collection<DbAttribute> getTargetAttributes() {
        return this.mapJoinsToAttributes(DbJoin::getTarget);
    }

    public Collection<DbAttribute> getSourceAttributes() {
        return this.mapJoinsToAttributes(DbJoin::getSource);
    }

    private Collection<DbAttribute> mapJoinsToAttributes(Function<DbJoin, DbAttribute> mapper) {
        if (this.joins.size() == 0) {
            return Collections.emptyList();
        }
        if (this.joins.size() == 1) {
            return Collections.singletonList(mapper.apply(this.joins.get(0)));
        }
        ArrayList<DbAttribute> result = new ArrayList<DbAttribute>(this.joins.size());
        for (DbJoin join : this.joins) {
            result.add(mapper.apply(join));
        }
        return result;
    }

    public DbRelationship createReverseRelationship() {
        DbEntity targetEntity = this.getTargetEntity();
        DbRelationship reverse = new DbRelationship();
        reverse.setSourceEntity(targetEntity);
        reverse.setTargetEntityName(((DbEntity)this.getSourceEntity()).getName());
        if (this.isToDependentPK() && !this.toMany && this.joins.size() == targetEntity.getPrimaryKeys().size()) {
            reverse.setToMany(false);
        } else {
            reverse.setToMany(!this.toMany);
        }
        for (DbJoin join : this.joins) {
            DbJoin reverseJoin = join.createReverseJoin();
            reverseJoin.setRelationship(reverse);
            reverse.addJoin(reverseJoin);
        }
        return reverse;
    }

    public DbRelationship getReverseRelationship() {
        DbEntity target = this.getTargetEntity();
        if (target == null) {
            return null;
        }
        DbEntity src = (DbEntity)this.getSourceEntity();
        if (target == src && this.joins.size() == 0) {
            return null;
        }
        TestJoin testJoin = new TestJoin(this);
        for (DbRelationship rel : target.getRelationships()) {
            List<DbJoin> otherJoins;
            if (rel.getTargetEntity() != src || (otherJoins = rel.getJoins()).size() != this.joins.size()) continue;
            boolean joinsMatch = true;
            for (DbJoin join : otherJoins) {
                testJoin.setSourceName(join.getTargetName());
                testJoin.setTargetName(join.getSourceName());
                if (this.joins.contains(testJoin)) continue;
                joinsMatch = false;
                break;
            }
            if (!joinsMatch) continue;
            return rel;
        }
        return null;
    }

    public boolean isToPK() {
        for (DbJoin join : this.getJoins()) {
            DbAttribute target = join.getTarget();
            if (target == null) {
                return false;
            }
            if (target.isPrimaryKey()) continue;
            return false;
        }
        return true;
    }

    public boolean isFromPK() {
        for (DbJoin join : this.getJoins()) {
            DbAttribute source = join.getSource();
            if (source == null) {
                return false;
            }
            if (!source.isPrimaryKey()) continue;
            return true;
        }
        return false;
    }

    public boolean isToMasterPK() {
        if (this.isToMany() || this.isToDependentPK()) {
            return false;
        }
        DbRelationship revRel = this.getReverseRelationship();
        return revRel != null && revRel.isToDependentPK();
    }

    public boolean isSourceIndependentFromTargetChange() {
        return this.isToMany() || this.isToDependentPK() || !this.isToPK();
    }

    public boolean isToDependentPK() {
        return this.toDependentPK;
    }

    public void setToDependentPK(boolean toDependentPK) {
        this.toDependentPK = toDependentPK;
    }

    public boolean isValidForDepPk() {
        if (this.getJoins().size() == 0) {
            return false;
        }
        for (DbJoin join : this.getJoins()) {
            DbAttribute target = join.getTarget();
            DbAttribute source = join.getSource();
            if ((target == null || target.isPrimaryKey()) && (source == null || source.isPrimaryKey())) continue;
            return false;
        }
        return true;
    }

    public List<DbJoin> getJoins() {
        return this.joins;
    }

    public void addJoin(DbJoin join) {
        if (join != null) {
            this.joins.add(join);
        }
    }

    public void removeJoin(DbJoin join) {
        this.joins.remove(join);
    }

    public void removeAllJoins() {
        this.joins.clear();
    }

    public void setJoins(Collection<DbJoin> newJoins) {
        this.removeAllJoins();
        if (newJoins != null) {
            this.joins.addAll(newJoins);
        }
    }

    public Map<String, Object> targetPkSnapshotWithSrcSnapshot(Map<String, Object> srcSnapshot) {
        Map<Object, Object> idMap;
        if (this.isToMany()) {
            throw new CayenneRuntimeException("Only 'to one' relationships support this method.", new Object[0]);
        }
        int numJoins = this.joins.size();
        int foundNulls = 0;
        if (numJoins == 1) {
            DbJoin join = this.joins.get(0);
            Object val = srcSnapshot.get(join.getSourceName());
            if (val == null) {
                ++foundNulls;
                idMap = Collections.emptyMap();
            } else {
                idMap = Collections.singletonMap(join.getTargetName(), val);
            }
        } else {
            idMap = new HashMap(numJoins * 2);
            for (DbJoin join : this.joins) {
                DbAttribute source = join.getSource();
                Object val = srcSnapshot.get(join.getSourceName());
                if (val == null) {
                    if (!source.isMandatory()) {
                        return null;
                    }
                    ++foundNulls;
                    continue;
                }
                idMap.put(join.getTargetName(), val);
            }
        }
        if (foundNulls == 0) {
            return idMap;
        }
        if (foundNulls == numJoins) {
            return null;
        }
        throw new CayenneRuntimeException("Some parts of FK are missing in snapshot, relationship: %s", this);
    }

    private Map<String, Object> srcSnapshotWithTargetSnapshot(Map<String, Object> targetSnapshot) {
        int len = this.joins.size();
        if (len == 1) {
            DbJoin join = this.joins.get(0);
            Object val = targetSnapshot.get(join.getTargetName());
            return Collections.singletonMap(join.getSourceName(), val);
        }
        HashMap<String, Object> idMap = new HashMap<String, Object>(len * 2);
        for (DbJoin join : this.joins) {
            Object val = targetSnapshot.get(join.getTargetName());
            idMap.put(join.getSourceName(), val);
        }
        return idMap;
    }

    public Map<String, Object> srcFkSnapshotWithTargetSnapshot(Map<String, Object> targetSnapshot) {
        if (this.isToMany()) {
            throw new CayenneRuntimeException("Only 'to one' relationships support this method.", new Object[0]);
        }
        return this.srcSnapshotWithTargetSnapshot(targetSnapshot);
    }

    public Map<String, Object> srcPkSnapshotWithTargetSnapshot(Map<String, Object> targetSnapshot) {
        if (!this.isToMany()) {
            throw new CayenneRuntimeException("Only 'to many' relationships support this method.", new Object[0]);
        }
        return this.srcSnapshotWithTargetSnapshot(targetSnapshot);
    }

    public void setToMany(boolean toMany) {
        this.toMany = toMany;
    }

    @Override
    public boolean isMandatory() {
        for (DbJoin join : this.getJoins()) {
            if (!join.getSource().isMandatory()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder res = new StringBuilder("Db Relationship : ");
        res.append(this.toMany ? "toMany" : "toOne ");
        String sourceEntityName = this.getSourceEntityName();
        for (DbJoin join : this.joins) {
            res.append(" (").append(sourceEntityName).append(".").append(join.getSourceName()).append(", ").append(this.targetEntityName).append(".").append(join.getTargetName()).append(")");
        }
        return res.toString();
    }

    public String getSourceEntityName() {
        if (this.sourceEntity == null) {
            return null;
        }
        return ((DbEntity)this.sourceEntity).name;
    }

    static final class TestJoin
    extends DbJoin {
        TestJoin(DbRelationship relationship) {
            super(relationship);
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof DbJoin)) {
                return false;
            }
            DbJoin j = (DbJoin)o;
            return j.relationship == this.relationship && Util.nullSafeEquals(j.sourceName, this.sourceName) && Util.nullSafeEquals(j.targetName, this.targetName);
        }
    }
}

