/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.io.Serializable;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.ConfigurationNodeVisitor;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.util.ToStringBuilder;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.cayenne.util.XMLSerializable;

public class DbJoin
implements XMLSerializable,
Serializable {
    protected DbRelationship relationship;
    protected String sourceName;
    protected String targetName;

    protected DbJoin() {
    }

    public DbJoin(DbRelationship relationship) {
        this.relationship = relationship;
    }

    public DbJoin(DbRelationship relationship, String sourceName, String targetName) {
        this.relationship = relationship;
        this.sourceName = sourceName;
        this.targetName = targetName;
    }

    public DbJoin createReverseJoin() {
        DbJoin reverse = new DbJoin();
        reverse.setTargetName(this.sourceName);
        reverse.setSourceName(this.targetName);
        return reverse;
    }

    public DbAttribute getSource() {
        if (this.sourceName == null) {
            return null;
        }
        DbRelationship r = this.getNonNullRelationship();
        DbEntity entity = (DbEntity)r.getSourceEntity();
        if (entity == null) {
            return null;
        }
        return (DbAttribute)entity.getAttribute(this.sourceName);
    }

    public DbAttribute getTarget() {
        if (this.targetName == null) {
            return null;
        }
        DbRelationship r = this.getNonNullRelationship();
        DbEntity entity = r.getTargetEntity();
        if (entity == null) {
            return null;
        }
        return (DbAttribute)entity.getAttribute(this.targetName);
    }

    @Override
    public void encodeAsXML(XMLEncoder encoder, ConfigurationNodeVisitor delegate) {
        encoder.start("db-attribute-pair").attribute("source", this.getSourceName()).attribute("target", this.getTargetName()).end();
    }

    public DbRelationship getRelationship() {
        return this.relationship;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public void setRelationship(DbRelationship relationship) {
        this.relationship = relationship;
    }

    public void setSourceName(String string) {
        this.sourceName = string;
    }

    public void setTargetName(String string) {
        this.targetName = string;
    }

    private DbRelationship getNonNullRelationship() {
        if (this.relationship == null) {
            throw new CayenneRuntimeException("Join has no parent Relationship.", new Object[0]);
        }
        return this.relationship;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this);
        builder.append("source", this.getSourceName());
        builder.append("target", this.getTargetName());
        return builder.toString();
    }
}

