/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.log;

import java.sql.SQLException;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.translator.DbAttributeBinding;
import org.apache.cayenne.access.translator.ParameterBinding;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jJdbcEventLogger
implements JdbcEventLogger {
    private static final Logger logger = LoggerFactory.getLogger(JdbcEventLogger.class);
    protected long queryExecutionTimeLoggingThreshold;

    public Slf4jJdbcEventLogger(@Inject RuntimeProperties runtimeProperties) {
        this.queryExecutionTimeLoggingThreshold = runtimeProperties.getLong("cayenne.server.query_execution_time_logging_threshold", 0L);
    }

    @Override
    public void log(String message) {
        if (message != null) {
            logger.info(message);
        }
    }

    @Override
    public void logGeneratedKey(DbAttribute attribute, Object value) {
        if (this.isLoggable()) {
            String entity = attribute.getEntity().getName();
            logger.info("Generated PK: " + entity + "." + attribute.getName() + " = " + value);
        }
    }

    @Override
    public void logQuery(String sql, ParameterBinding[] bindings) {
        if (this.isLoggable()) {
            StringBuilder buffer = new StringBuilder(sql).append(" ");
            this.appendParameters(buffer, "bind", bindings);
            if (buffer.length() > 0) {
                logger.info(buffer.toString());
            }
        }
    }

    @Override
    public void logQueryParameters(String label, ParameterBinding[] bindings) {
        if (this.isLoggable() && bindings.length > 0) {
            StringBuilder buffer = new StringBuilder();
            this.appendParameters(buffer, label, bindings);
            if (buffer.length() > 0) {
                logger.info(buffer.toString());
            }
        }
    }

    protected void appendParameters(StringBuilder buffer, String label, ParameterBinding[] bindings) {
        int len = bindings.length;
        if (len > 0) {
            boolean hasIncluded = false;
            int j = 1;
            for (int i = 0; i < len; ++i) {
                DbAttribute attribute;
                ParameterBinding b = bindings[i];
                if (b.isExcluded()) continue;
                if (hasIncluded) {
                    buffer.append(", ");
                } else {
                    hasIncluded = true;
                    buffer.append("[").append(label).append(": ");
                }
                buffer.append(j++);
                if (b instanceof DbAttributeBinding && (attribute = ((DbAttributeBinding)b).getAttribute()) != null) {
                    buffer.append("->");
                    buffer.append(attribute.getName());
                }
                buffer.append(":");
                if (b.getExtendedType() != null) {
                    buffer.append(b.getExtendedType().toString(b.getValue()));
                    continue;
                }
                if (b.getValue() == null) {
                    buffer.append("NULL");
                    continue;
                }
                buffer.append(b.getValue().getClass().getName()).append("@").append(System.identityHashCode(b.getValue()));
            }
            if (hasIncluded) {
                buffer.append("]");
            }
        }
    }

    @Override
    public void logSelectCount(int count, long time) {
        this.logSelectCount(count, time, null);
    }

    @Override
    public void logSelectCount(int count, long time, String sql) {
        if (this.isLoggable()) {
            StringBuilder buf = new StringBuilder();
            if (count == 1) {
                buf.append("=== returned 1 row.");
            } else {
                buf.append("=== returned ").append(count).append(" rows.");
            }
            if (time >= 0L) {
                buf.append(" - took ").append(time).append(" ms.");
            }
            logger.info(buf.toString());
        }
        if (this.queryExecutionTimeLoggingThreshold > 0L && time > this.queryExecutionTimeLoggingThreshold) {
            String message = "Query time exceeded threshold (" + time + " ms): ";
            logger.warn(message + sql, (Throwable)new CayenneRuntimeException(message + "%s", sql));
        }
    }

    @Override
    public void logUpdateCount(int count) {
        if (this.isLoggable()) {
            if (count < 0) {
                logger.info("=== updated ? rows");
            } else {
                Object countStr = count == 1 ? "=== updated 1 row." : "=== updated " + count + " rows.";
                logger.info((String)countStr);
            }
        }
    }

    @Override
    public void logBeginTransaction(String transactionLabel) {
        logger.info("--- " + transactionLabel);
    }

    @Override
    public void logCommitTransaction(String transactionLabel) {
        logger.info("+++ " + transactionLabel);
    }

    @Override
    public void logRollbackTransaction(String transactionLabel) {
        logger.info("*** " + transactionLabel);
    }

    @Override
    public void logQueryError(Throwable th) {
        if (this.isLoggable()) {
            if (th != null) {
                th = Util.unwindException(th);
            }
            logger.info("*** error.", th);
            if (th instanceof SQLException) {
                for (SQLException sqlException = ((SQLException)th).getNextException(); sqlException != null; sqlException = sqlException.getNextException()) {
                    logger.info("*** nested SQL error.", (Throwable)sqlException);
                }
            }
        }
    }

    @Override
    public boolean isLoggable() {
        return logger.isInfoEnabled();
    }
}

